/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.configuration.FiftyOneDegreesConfiguration;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.data.DataFileProvider;
import com.liferay.portal.mobile.device.detection.fiftyonedegrees.internal.FiftyOneDegreesDevice;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.Provider;
import fiftyone.mobile.detection.factories.StreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.mobile.device.detection.fiftyonedegrees.configuration.FiftyOneDegreesConfiguration"}, service={FiftyOneDegreesEngineProxy.class})
public class FiftyOneDegreesEngineProxy {
    private static final Log _log = LogFactoryUtil.getLog(FiftyOneDegreesEngineProxy.class);
    @Reference
    private DataFileProvider _dataFileProvider;
    private Dataset _dataset;
    private volatile FiftyOneDegreesConfiguration _fiftyOneDegreesConfiguration;
    private Provider _provider;

    public Dataset getDataset() {
        return this._provider.dataSet;
    }

    public Device getDevice(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        try {
            Match match = this._provider.match(userAgent);
            return new FiftyOneDegreesDevice(match);
        }
        catch (IOException ioe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get match for user agent: " + userAgent), (Throwable)ioe);
            }
            return UnknownDevice.getInstance();
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._fiftyOneDegreesConfiguration = (FiftyOneDegreesConfiguration)ConfigurableUtil.createConfigurable(FiftyOneDegreesConfiguration.class, properties);
        try (InputStream inputStream = this._dataFileProvider.getDataFileInputStream();){
            this._dataset = StreamFactory.create((byte[])IOUtils.toByteArray((InputStream)inputStream));
            this._provider = new Provider(this._dataset, this._fiftyOneDegreesConfiguration.cacheSize());
        }
        catch (IOException ioe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to load 51Degrees provider data", (Throwable)ioe);
            }
            throw new IllegalStateException(ioe);
        }
    }

    @Deactivate
    protected void deactivate() throws IOException {
        this._fiftyOneDegreesConfiguration = null;
        this._provider = null;
        if (this._dataset != null) {
            this._dataset.close();
        }
    }
}

