/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusInterceptor;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.messaging.internal.BaseAsyncDestination;
import com.liferay.portal.messaging.internal.MessageBusThreadLocalUtil;
import com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={MessageBus.class})
public class DefaultMessageBus
implements MessageBus {
    private static final Log _log = LogFactoryUtil.getLog(DefaultMessageBus.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private final Map<String, DestinationWorkerConfiguration> _destinationWorkerConfigurations = new ConcurrentHashMap<String, DestinationWorkerConfiguration>();
    private final Map<String, String> _factoryPidsToDestinationNames = new ConcurrentHashMap<String, String>();
    private ServiceRegistration<ManagedServiceFactory> _serviceRegistration;
    private ServiceTrackerList<MessageBusInterceptor> _serviceTrackerList;
    private ServiceTrackerMap<String, Destination> _serviceTrackerMap;

    public Destination getDestination(String destinationName) {
        return (Destination)this._serviceTrackerMap.getService((Object)destinationName);
    }

    public void sendMessage(String destinationName, Message message) {
        Long[] companyIds;
        MessageBusThreadLocalUtil.populateMessageFromThreadLocals(message);
        for (MessageBusInterceptor messageBusInterceptor : this._serviceTrackerList) {
            if (!messageBusInterceptor.intercept((MessageBus)this, destinationName, message)) continue;
            return;
        }
        Destination destination = (Destination)this._serviceTrackerMap.getService((Object)destinationName);
        if (destination == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Destination " + destinationName + " is not configured"));
            }
            return;
        }
        message.setDestinationName(destinationName);
        if (message.get("companyId") == null && (companyIds = (Long[])message.get("companyIds")) != null) {
            this._companyLocalService.forEachCompanyId(companyId -> {
                message.put("companyId", companyId);
                destination.send(message.clone());
            }, ArrayUtil.toArray((Long[])companyIds));
            return;
        }
        destination.send(message);
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Destination.class, (String)"destination.name", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Destination, Destination>(){

            public Destination addingService(ServiceReference<Destination> serviceReference) {
                Destination destination = (Destination)bundleContext.getService(serviceReference);
                destination.open();
                DestinationWorkerConfiguration destinationWorkerConfiguration = DefaultMessageBus.this._destinationWorkerConfigurations.get(destination.getName());
                DefaultMessageBus.this._updateDestination(destination, destinationWorkerConfiguration);
                return destination;
            }

            public void modifiedService(ServiceReference<Destination> serviceReference, Destination destination) {
            }

            public void removedService(ServiceReference<Destination> serviceReference, Destination destination) {
                destination.destroy();
                bundleContext.ungetService(serviceReference);
            }
        });
        this._serviceRegistration = bundleContext.registerService(ManagedServiceFactory.class, (Object)new DefaultMessageBusManagedServiceFactory(), (Dictionary)HashMapDictionaryBuilder.put((Object)"service.pid", (Object)"com.liferay.portal.messaging.internal.configuration.DestinationWorkerConfiguration").build());
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, MessageBusInterceptor.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceRegistration.unregister();
        this._serviceTrackerMap.close();
    }

    private void _updateDestination(Destination destination, DestinationWorkerConfiguration destinationWorkerConfiguration) {
        if (destination == null || destinationWorkerConfiguration == null) {
            return;
        }
        if (destination instanceof BaseAsyncDestination) {
            BaseAsyncDestination baseAsyncDestination = (BaseAsyncDestination)destination;
            baseAsyncDestination.setMaximumQueueSize(destinationWorkerConfiguration.maxQueueSize());
            baseAsyncDestination.setWorkersSize(destinationWorkerConfiguration.workerCoreSize(), destinationWorkerConfiguration.workerMaxSize());
        }
    }

    private class DefaultMessageBusManagedServiceFactory
    implements ManagedServiceFactory {
        private DefaultMessageBusManagedServiceFactory() {
        }

        public void deleted(String factoryPid) {
            String destinationName = DefaultMessageBus.this._factoryPidsToDestinationNames.remove(factoryPid);
            DefaultMessageBus.this._destinationWorkerConfigurations.remove(destinationName);
        }

        public String getName() {
            return "Default Message Bus";
        }

        public void updated(String factoryPid, Dictionary<String, ?> dictionary) {
            DestinationWorkerConfiguration destinationWorkerConfiguration = (DestinationWorkerConfiguration)ConfigurableUtil.createConfigurable(DestinationWorkerConfiguration.class, dictionary);
            DefaultMessageBus.this._factoryPidsToDestinationNames.put(factoryPid, destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._destinationWorkerConfigurations.put(destinationWorkerConfiguration.destinationName(), destinationWorkerConfiguration);
            Destination destination = (Destination)DefaultMessageBus.this._serviceTrackerMap.getService((Object)destinationWorkerConfiguration.destinationName());
            DefaultMessageBus.this._updateDestination(destination, destinationWorkerConfiguration);
        }
    }
}

