/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageListenerRegistry;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.messaging.internal.DestinationPrototype;
import com.liferay.portal.messaging.internal.ParallelDestinationPrototype;
import com.liferay.portal.messaging.internal.SerialDestinationPrototype;
import com.liferay.portal.messaging.internal.SynchronousDestinationPrototype;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DestinationFactory.class})
public class DefaultDestinationFactory
implements DestinationFactory {
    private final ConcurrentMap<String, DestinationPrototype> _destinationPrototypes = new ConcurrentHashMap<String, DestinationPrototype>();
    @Reference
    private MessageListenerRegistry _messageListenerRegistry;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private UserLocalService _userLocalService;

    public Destination createDestination(DestinationConfiguration destinationConfiguration) {
        String type = destinationConfiguration.getDestinationType();
        DestinationPrototype destinationPrototype = (DestinationPrototype)this._destinationPrototypes.get(type);
        if (destinationPrototype == null) {
            throw new IllegalArgumentException("No destination prototype configured for " + type);
        }
        return destinationPrototype.createDestination(destinationConfiguration);
    }

    public Collection<String> getDestinationTypes() {
        return Collections.unmodifiableCollection(this._destinationPrototypes.keySet());
    }

    @Activate
    protected void activate() {
        this._destinationPrototypes.put("parallel", new ParallelDestinationPrototype(this._messageListenerRegistry, this._portalExecutorManager, this._permissionCheckerFactory, this._userLocalService));
        this._destinationPrototypes.put("serial", new SerialDestinationPrototype(this._messageListenerRegistry, this._portalExecutorManager, this._permissionCheckerFactory, this._userLocalService));
        this._destinationPrototypes.put("synchronous", new SynchronousDestinationPrototype(this._messageListenerRegistry));
    }

    @Deactivate
    protected void deactivate() {
        this._destinationPrototypes.clear();
    }
}

