/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.sender;

import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationSynchronousMessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.messaging.internal.sender.DefaultSingleDestinationMessageSender;
import com.liferay.portal.messaging.internal.sender.DefaultSingleDestinationSynchronousMessageSender;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Deprecated
@Component(immediate=true, service={SingleDestinationMessageSenderFactory.class})
public class DefaultSingleDestinationMessageSenderFactory
implements SingleDestinationMessageSenderFactory {
    private final Map<String, DefaultSingleDestinationMessageSender> _defaultSingleDestinationMessageSenders = new ConcurrentHashMap<String, DefaultSingleDestinationMessageSender>();
    private final Map<String, DefaultSingleDestinationSynchronousMessageSender> _defaultSingleDestinationSynchronousMessageSenders = new ConcurrentHashMap<String, DefaultSingleDestinationSynchronousMessageSender>();
    private MessageBus _messageBus;
    private final Map<SynchronousMessageSender.Mode, SynchronousMessageSender> _synchronousMessageSenders = new HashMap<SynchronousMessageSender.Mode, SynchronousMessageSender>();

    public SingleDestinationMessageSender createSingleDestinationMessageSender(String destinationName) {
        DefaultSingleDestinationMessageSender defaultSingleDestinationMessageSender = this._defaultSingleDestinationMessageSenders.get(destinationName);
        if (defaultSingleDestinationMessageSender == null) {
            defaultSingleDestinationMessageSender = new DefaultSingleDestinationMessageSender();
            defaultSingleDestinationMessageSender.setDestinationName(destinationName);
            defaultSingleDestinationMessageSender.setMessageBus(this._messageBus);
            this._defaultSingleDestinationMessageSenders.put(destinationName, defaultSingleDestinationMessageSender);
        }
        return defaultSingleDestinationMessageSender;
    }

    public SingleDestinationSynchronousMessageSender createSingleDestinationSynchronousMessageSender(String destinationName, SynchronousMessageSender.Mode mode) {
        DefaultSingleDestinationSynchronousMessageSender defaultSingleDestinationSynchronousMessageSender = this._defaultSingleDestinationSynchronousMessageSenders.get(destinationName);
        if (defaultSingleDestinationSynchronousMessageSender == null) {
            SynchronousMessageSender synchronousMessageSender = this._synchronousMessageSenders.get(mode);
            if (synchronousMessageSender == null) {
                throw new IllegalStateException("No synchronous message sender configured for " + mode);
            }
            defaultSingleDestinationSynchronousMessageSender = new DefaultSingleDestinationSynchronousMessageSender();
            defaultSingleDestinationSynchronousMessageSender.setDestinationName(destinationName);
            defaultSingleDestinationSynchronousMessageSender.setSynchronousMessageSender(synchronousMessageSender);
            this._defaultSingleDestinationSynchronousMessageSenders.put(destinationName, defaultSingleDestinationSynchronousMessageSender);
        }
        return defaultSingleDestinationSynchronousMessageSender;
    }

    public int getModesCount() {
        return this._synchronousMessageSenders.size();
    }

    public SynchronousMessageSender getSynchronousMessageSender(SynchronousMessageSender.Mode mode) {
        return this._synchronousMessageSenders.get(mode);
    }

    protected SynchronousMessageSender.Mode getMode(Map<String, Object> properties) {
        String mode = GetterUtil.getString((Object)properties.get("mode"));
        return SynchronousMessageSender.Mode.valueOf((String)mode);
    }

    @Reference(unbind="-")
    protected void setMessageBus(MessageBus messageBus) {
        this._messageBus = messageBus;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSynchronousMessageSender(SynchronousMessageSender synchronousMessageSender, Map<String, Object> properties) {
        this._synchronousMessageSenders.put(this.getMode(properties), synchronousMessageSender);
    }

    protected void unsetSynchronousMessageSender(SynchronousMessageSender synchronousMessageSender, Map<String, Object> properties) {
        this._synchronousMessageSenders.remove(this.getMode(properties));
    }
}

