/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.messaging.internal.DestinationPrototype;
import com.liferay.portal.messaging.internal.ParallelDestination;

public class ParallelDestinationPrototype
implements DestinationPrototype {
    private final PortalExecutorManager _portalExecutorManager;

    public ParallelDestinationPrototype(PortalExecutorManager portalExecutorManager) {
        this._portalExecutorManager = portalExecutorManager;
    }

    @Override
    public Destination createDestination(DestinationConfiguration destinationConfiguration) {
        ParallelDestination parallelDestination = new ParallelDestination();
        parallelDestination.setName(destinationConfiguration.getDestinationName());
        parallelDestination.setMaximumQueueSize(destinationConfiguration.getMaximumQueueSize());
        parallelDestination.setPortalExecutorManager(this._portalExecutorManager);
        parallelDestination.setRejectedExecutionHandler(destinationConfiguration.getRejectedExecutionHandler());
        parallelDestination.setWorkersSize(destinationConfiguration.getWorkersCoreSize(), destinationConfiguration.getWorkersMaxSize());
        parallelDestination.afterPropertiesSet();
        return parallelDestination;
    }
}

