/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class BaseAsyncDestination
extends BaseDestination {
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static final Log _log = LogFactoryUtil.getLog(BaseAsyncDestination.class);
    private int _maximumQueueSize = Integer.MAX_VALUE;
    private PortalExecutorManager _portalExecutorManager;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    public void close(boolean force) {
        if (this._threadPoolExecutor == null || this._threadPoolExecutor.isShutdown()) {
            return;
        }
        if (force) {
            this._threadPoolExecutor.shutdownNow();
        } else {
            this._threadPoolExecutor.shutdown();
        }
    }

    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setActiveThreadCount(this._threadPoolExecutor.getActiveCount());
        destinationStatistics.setCurrentThreadCount(this._threadPoolExecutor.getPoolSize());
        destinationStatistics.setLargestThreadCount(this._threadPoolExecutor.getLargestPoolSize());
        destinationStatistics.setMaxThreadPoolSize(this._threadPoolExecutor.getMaxPoolSize());
        destinationStatistics.setMinThreadPoolSize(this._threadPoolExecutor.getCorePoolSize());
        destinationStatistics.setPendingMessageCount((long)this._threadPoolExecutor.getPendingTaskCount());
        destinationStatistics.setSentMessageCount(this._threadPoolExecutor.getCompletedTaskCount());
        return destinationStatistics;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    public void open() {
        if (this._threadPoolExecutor != null && !this._threadPoolExecutor.isShutdown()) {
            return;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        if (this._rejectedExecutionHandler == null) {
            this._rejectedExecutionHandler = this._createRejectionExecutionHandler();
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 60L, TimeUnit.SECONDS, false, this._maximumQueueSize, this._rejectedExecutionHandler, (ThreadFactory)new NamedThreadFactory(this.getName(), 5, classLoader), (ThreadPoolHandler)new ThreadPoolHandlerAdapter());
        ThreadPoolExecutor oldThreadPoolExecutor = this._portalExecutorManager.registerPortalExecutor(this.getName(), threadPoolExecutor);
        if (oldThreadPoolExecutor != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Abort creating a new thread pool for destination " + this.getName() + " and reuse previous one"));
            }
            threadPoolExecutor.shutdownNow();
            threadPoolExecutor = oldThreadPoolExecutor;
        }
        this._threadPoolExecutor = threadPoolExecutor;
    }

    public void send(Message message) {
        if (this.messageListeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No message listeners for destination " + this.getName()));
            }
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this._threadPoolExecutor;
        if (threadPoolExecutor.isShutdown()) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Destination ", this.getName(), " is shutdown and cannot ", "receive more messages"}));
        }
        this.populateMessageFromThreadLocals(message);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending message ", message, " from destination ", this.getName(), " to message listeners ", this.messageListeners}));
        }
        this.dispatch(this.messageListeners, message);
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    public void setPortalExecutorManager(PortalExecutorManager portalExecutorManager) {
        this._portalExecutorManager = portalExecutorManager;
    }

    @Deprecated
    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    @Deprecated
    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
        if (this._threadPoolExecutor != null) {
            this._threadPoolExecutor.adjustPoolSize(workersCoreSize, this._workersMaxSize);
        }
    }

    @Deprecated
    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
        if (this._threadPoolExecutor != null) {
            this._threadPoolExecutor.adjustPoolSize(this._workersCoreSize, workersMaxSize);
        }
    }

    public void setWorkersSize(int workersCoreSize, int workersMaxSize) {
        if (workersCoreSize < 0 || workersMaxSize <= 0 || workersMaxSize < workersCoreSize) {
            throw new IllegalArgumentException();
        }
        this._workersCoreSize = workersCoreSize;
        this._workersMaxSize = workersMaxSize;
        if (this._threadPoolExecutor != null) {
            this._threadPoolExecutor.adjustPoolSize(workersCoreSize, workersMaxSize);
        }
    }

    @Deprecated
    protected RejectedExecutionHandler createRejectionExecutionHandler() {
        return this._createRejectionExecutionHandler();
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);

    @Deprecated
    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this._threadPoolExecutor;
    }

    protected void populateMessageFromThreadLocals(Message message) {
        if (!message.contains("companyId")) {
            message.put("companyId", (Object)CompanyThreadLocal.getCompanyId());
        }
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            message.put("clusterInvoke", (Object)Boolean.FALSE);
        }
        if (!message.contains("defaultLocale")) {
            message.put("defaultLocale", (Object)LocaleThreadLocal.getDefaultLocale());
        }
        if (!message.contains("groupId")) {
            message.put("groupId", (Object)GroupThreadLocal.getGroupId());
        }
        if (!message.contains("permissionChecker")) {
            message.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
        }
        if (!message.contains("principalName")) {
            message.put("principalName", (Object)PrincipalThreadLocal.getName());
        }
        if (!message.contains("principalPassword")) {
            message.put("principalPassword", (Object)PrincipalThreadLocal.getPassword());
        }
        if (!message.contains("siteDefaultLocale")) {
            message.put("siteDefaultLocale", (Object)LocaleThreadLocal.getSiteDefaultLocale());
        }
        if (!message.contains("themeDisplayLocale")) {
            message.put("themeDisplayLocale", (Object)LocaleThreadLocal.getThemeDisplayLocale());
        }
    }

    protected void populateThreadLocalsFromMessage(Message message) {
        Locale themeDisplayLocale;
        Locale siteDefaultLocale;
        String principalPassword;
        long groupId;
        Locale defaultLocale;
        Boolean clusterInvoke;
        long companyId = message.getLong("companyId");
        if (companyId > 0L) {
            CompanyThreadLocal.setCompanyId((Long)companyId);
        }
        if ((clusterInvoke = (Boolean)message.get("clusterInvoke")) != null) {
            ClusterInvokeThreadLocal.setEnabled((boolean)clusterInvoke);
        }
        if ((defaultLocale = (Locale)message.get("defaultLocale")) != null) {
            LocaleThreadLocal.setDefaultLocale((Locale)defaultLocale);
        }
        if ((groupId = message.getLong("groupId")) > 0L) {
            GroupThreadLocal.setGroupId((Long)groupId);
        }
        PermissionChecker permissionChecker = (PermissionChecker)message.get("permissionChecker");
        String principalName = message.getString("principalName");
        if (Validator.isNotNull((String)principalName)) {
            PrincipalThreadLocal.setName((String)principalName);
        }
        if (permissionChecker == null && Validator.isNotNull((String)principalName)) {
            try {
                User user = UserLocalServiceUtil.fetchUser((long)PrincipalThreadLocal.getUserId());
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (permissionChecker != null) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        if (Validator.isNotNull((String)(principalPassword = message.getString("principalPassword")))) {
            PrincipalThreadLocal.setPassword((String)principalPassword);
        }
        if ((siteDefaultLocale = (Locale)message.get("siteDefaultLocale")) != null) {
            LocaleThreadLocal.setSiteDefaultLocale((Locale)siteDefaultLocale);
        }
        if ((themeDisplayLocale = (Locale)message.get("themeDisplayLocale")) != null) {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)themeDisplayLocale);
        }
    }

    private RejectedExecutionHandler _createRejectionExecutionHandler() {
        return new RejectedExecutionHandler(){

            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (!_log.isWarnEnabled()) {
                    return;
                }
                MessageRunnable messageRunnable = (MessageRunnable)runnable;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Discarding message ", messageRunnable.getMessage(), " because it exceeds the maximum queue size of ", BaseAsyncDestination.this._maximumQueueSize}));
            }
        };
    }
}

