/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.internal.configuration;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instances.internal.configuration.PortalInstancesConfiguration;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.auth.CompanyInheritableThreadLocalCallable;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.util.PortalInstances;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.instances.internal.configuration.PortalInstancesConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class PortalInstancesConfigurationFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstancesConfigurationFactory.class);
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;

    @Activate
    protected void activate(Map<String, Object> properties) throws PortalException {
        PortalInstancesConfiguration portalInstancesConfiguration = (PortalInstancesConfiguration)ConfigurableUtil.createConfigurable(PortalInstancesConfiguration.class, properties);
        DependencyManagerSyncUtil.registerSyncCallable((Callable)new CompanyInheritableThreadLocalCallable(() -> {
            Company company;
            boolean active;
            int maxUsers;
            String mx;
            String virtualHostname;
            String webId;
            block6: {
                if (!this._clusterMasterExecutor.isMaster()) {
                    return null;
                }
                webId = this._getWebId(properties);
                virtualHostname = portalInstancesConfiguration.virtualHostname();
                mx = portalInstancesConfiguration.mx();
                maxUsers = portalInstancesConfiguration.maxUsers();
                active = portalInstancesConfiguration.active();
                company = null;
                try {
                    company = this._companyLocalService.getCompanyByWebId(webId);
                }
                catch (NoSuchCompanyException noSuchCompanyException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)noSuchCompanyException);
                }
            }
            if (company == null) {
                PortalInstances.addCompany((String)portalInstancesConfiguration.siteInitializerKey(), () -> this._companyLocalService.addCompany(null, webId, virtualHostname, mx, maxUsers, portalInstancesConfiguration.active(), portalInstancesConfiguration.addDefaultAdminUser(), portalInstancesConfiguration.adminPassword(), portalInstancesConfiguration.adminScreenName(), portalInstancesConfiguration.adminEmailAddress(), portalInstancesConfiguration.adminFirstName(), portalInstancesConfiguration.adminMiddleName(), portalInstancesConfiguration.adminLastName()));
            } else {
                if (company.getCompanyId() == PortalInstancePool.getDefaultCompanyId()) {
                    active = true;
                }
                this._companyLocalService.updateCompany(company.getCompanyId(), virtualHostname, mx, maxUsers, active);
            }
            return null;
        }));
    }

    private String _getWebId(Map<String, Object> properties) {
        String pid = GetterUtil.getString((Object)properties.get("service.pid"));
        int index = pid.indexOf(126);
        if (index > 0) {
            pid = pid.substring(index + 1);
        }
        return pid;
    }
}

