/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.internal.operation;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instances.internal.configuration.ExtractPortalInstanceConfiguration;
import com.liferay.portal.instances.internal.operation.BasePortalInstanceOperation;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.instances.internal.configuration.ExtractPortalInstanceConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, enabled=false, service={})
public class ExtractPortalInstanceOperation
extends BasePortalInstanceOperation {
    private static final Log _log = LogFactoryUtil.getLog(ExtractPortalInstanceOperation.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    @Override
    public String getOperationCompletedMessage(long companyId) {
        return "Portal instance with company ID " + companyId + " extracted successfully";
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.onPortalInstance(() -> {
            ExtractPortalInstanceConfiguration extractPortalInstanceConfiguration = (ExtractPortalInstanceConfiguration)ConfigurableUtil.createConfigurable(ExtractPortalInstanceConfiguration.class, (Map)properties);
            long companyId = extractPortalInstanceConfiguration.extractCompanyId();
            if (this._companyLocalService.fetchCompany(companyId) == null) {
                _log.error((Object)("Portal instance with company ID " + companyId + " does not exist"));
                return null;
            }
            return this._companyLocalService.extractDBPartitionCompany(companyId);
        }, properties);
    }
}

