/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.internal.operation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instances.internal.configuration.CopyPortalInstanceConfiguration;
import com.liferay.portal.instances.internal.operation.BasePortalInstanceOperation;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.instances.internal.configuration.CopyPortalInstanceConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, enabled=false, service={})
public class CopyPortalInstanceOperation
extends BasePortalInstanceOperation {
    private static final Log _log = LogFactoryUtil.getLog(CopyPortalInstanceOperation.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    @Override
    public String getOperationCompletedMessage(long companyId) {
        return "Portal instance with company ID " + companyId + " copied successfully";
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.onPortalInstance(() -> {
            CopyPortalInstanceConfiguration copyPortalInstanceConfiguration = (CopyPortalInstanceConfiguration)ConfigurableUtil.createConfigurable(CopyPortalInstanceConfiguration.class, (Map)properties);
            long sourceCompanyId = copyPortalInstanceConfiguration.sourceCompanyId();
            Company sourceCompany = this._companyLocalService.fetchCompany(sourceCompanyId);
            if (sourceCompany == null) {
                _log.error((Object)("Portal instance with company ID " + sourceCompanyId + " does not exist"));
                return null;
            }
            if (sourceCompanyId == PortalInstancePool.getDefaultCompanyId()) {
                _log.error((Object)("Portal instance with company ID " + sourceCompanyId + " is the default company"));
                return null;
            }
            long destinationCompanyId = copyPortalInstanceConfiguration.destinationCompanyId();
            Company destinationCompany = this._companyLocalService.fetchCompany(destinationCompanyId);
            if (destinationCompany != null) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Portal instance with company ID ", destinationCompanyId, " already exists"}));
                return null;
            }
            return this._companyLocalService.copyDBPartitionCompany(sourceCompanyId, destinationCompanyId > 0L ? Long.valueOf(destinationCompanyId) : null, copyPortalInstanceConfiguration.name(), copyPortalInstanceConfiguration.virtualHostname(), copyPortalInstanceConfiguration.webId());
        }, properties);
    }
}

