/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.instances.service.impl;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.instances.service.base.PortalInstancesLocalServiceBaseImpl;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.CompanyService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.util.PortalInstances"}, service={AopService.class})
public class PortalInstancesLocalServiceImpl
extends PortalInstancesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstancesLocalServiceImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CompanyService _companyService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void addCompanyId(long companyId) {
        PortalInstances.addCompanyId((long)companyId);
    }

    public long getCompanyId(HttpServletRequest httpServletRequest) {
        return PortalInstances.getCompanyId((HttpServletRequest)httpServletRequest);
    }

    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    public long[] getCompanyIdsBySQL() throws SQLException {
        return PortalInstances.getCompanyIdsBySQL();
    }

    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    public String[] getWebIds() {
        return PortalInstances.getWebIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializePortalInstance(long companyId, String siteInitializerKey, ServletContext servletContext) throws PortalException {
        Company company = this._companyLocalService.getCompany(companyId);
        PortalInstances.initCompany((ServletContext)servletContext, (String)company.getWebId());
        if (Validator.isNull((String)siteInitializerKey)) {
            return;
        }
        SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
        if (siteInitializer == null) {
            throw new PortalException("Invalid site initializer key " + siteInitializerKey);
        }
        Role role = this._roleLocalService.fetchRole(companyId, "Administrator");
        List users = this._userLocalService.getRoleUsers(role.getRoleId());
        User user = (User)users.get(0);
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionCheckerFactory.create(user));
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setInitializingPortalInstance((boolean)true);){
            Group group = this._groupLocalService.getGroup(company.getCompanyId(), "Guest");
            siteInitializer.initialize(group.getGroupId());
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((String)name);
        }
    }

    @Deprecated
    public void initializePortalInstance(ServletContext servletContext, String webId) {
        PortalInstances.initCompany((ServletContext)servletContext, (String)webId);
    }

    public boolean isAutoLoginIgnoreHost(String host) {
        return PortalInstances.isAutoLoginIgnoreHost((String)host);
    }

    public boolean isAutoLoginIgnorePath(String path) {
        return PortalInstances.isAutoLoginIgnorePath((String)path);
    }

    public boolean isCompanyActive(long companyId) {
        return PortalInstances.isCompanyActive((long)companyId);
    }

    public boolean isVirtualHostsIgnoreHost(String host) {
        return PortalInstances.isVirtualHostsIgnoreHost((String)host);
    }

    public boolean isVirtualHostsIgnorePath(String path) {
        return PortalInstances.isVirtualHostsIgnorePath((String)path);
    }

    public void reload(ServletContext servletContext) {
        PortalInstances.reload((ServletContext)servletContext);
    }

    public void removeCompany(long companyId) {
        PortalInstances.removeCompany((long)companyId);
    }

    @Clusterable
    public void synchronizePortalInstances() {
        try {
            long[] initializedCompanyIds = this._portal.getCompanyIds();
            List removeableCompanyIds = ListUtil.fromArray((long[])initializedCompanyIds);
            List companies = this._companyLocalService.getCompanies();
            for (Company company : companies) {
                long companyId = company.getCompanyId();
                removeableCompanyIds.remove(companyId);
                if (ArrayUtil.contains((long[])initializedCompanyIds, (long)companyId)) continue;
                ServletContext portalContext = ServletContextPool.get((String)this._portal.getPathContext());
                PortalInstances.initCompany((ServletContext)portalContext, (String)company.getWebId());
            }
            Iterator iterator = removeableCompanyIds.iterator();
            while (iterator.hasNext()) {
                long companyId = (Long)iterator.next();
                PortalInstances.removeCompany((long)companyId);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

