/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.migration.schema.exporter.internal.sql.writer;

import com.liferay.portal.db.migration.schema.exporter.internal.sql.provider.DBPartitionSQLProvider;
import com.liferay.portal.db.migration.schema.exporter.internal.sql.provider.PortalSQLProvider;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropsValues;
import java.io.File;

public class SQLWriter {
    public void writeFiles(File directory) throws Exception {
        if (PropsValues.DATABASE_PARTITION_ENABLED) {
            this._writeDBPartitionFiles(directory);
        } else {
            this._writeFiles(directory);
        }
    }

    private void _writeDBPartitionFiles(File directory) throws Exception {
        DBPartitionSQLProvider.clearCache();
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            if (companyId == PortalInstancePool.getDefaultCompanyId()) {
                this._writeFiles(directory);
                return;
            }
            DBPartitionSQLProvider sqlProvider = new DBPartitionSQLProvider((long)companyId);
            FileUtil.write((File)new File(directory, companyId + "_indexes.sql"), (String)sqlProvider.getIndexesSQL());
            FileUtil.write((File)new File(directory, companyId + "_tables.sql"), (String)sqlProvider.getTablesSQL());
        });
    }

    private void _writeFiles(File directory) throws Exception {
        PortalSQLProvider sqlProvider = new PortalSQLProvider();
        FileUtil.write((File)new File(directory, "indexes.sql"), (String)sqlProvider.getIndexesSQL());
        FileUtil.write((File)new File(directory, "tables.sql"), (String)sqlProvider.getTablesSQL());
    }
}

