/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.db.migration.schema.exporter.internal.sql.provider;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.PostgreSQLDB;
import com.liferay.portal.db.migration.schema.exporter.internal.sql.provider.BaseSQLProvider;
import com.liferay.portal.db.migration.schema.exporter.internal.sql.provider.ObjectSQLProvider;
import com.liferay.portal.db.partition.db.DBPartitionPostgreSQLDB;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public class DBPartitionSQLProvider
extends BaseSQLProvider {
    private static List<String> _controlTableNames;
    private static String _partitionIndexesSQL;
    private static String _partitionTablesSQL;
    private static Set<List<String>> _rulesTableColumn;
    private final ObjectSQLProvider _objectSQLProvider;
    private final String _partitionName;

    public static void clearCache() {
        _controlTableNames = null;
        _partitionIndexesSQL = null;
        _partitionTablesSQL = null;
        _rulesTableColumn = null;
    }

    public DBPartitionSQLProvider(long companyId) throws Exception {
        this._objectSQLProvider = new ObjectSQLProvider(companyId, this.db);
        this._partitionName = DBPartitionUtil.getPartitionName((long)companyId);
        if (_partitionIndexesSQL == null || _partitionTablesSQL == null) {
            _partitionTablesSQL = this._getPartitionTablesSQL();
            _partitionIndexesSQL = this._getPartitionIndexesSQL();
        }
    }

    @Override
    public String getIndexesSQL() {
        return StringUtil.replace((String)StringBundler.concat((String[])new String[]{_partitionIndexesSQL, "\n", this._objectSQLProvider.getIndexesSQL()}), (String)" on ", (String)StringBundler.concat((String[])new String[]{" on ", this._partitionName, "."}));
    }

    @Override
    public String getTablesSQL() {
        return StringBundler.concat((String[])new String[]{this._getCreatePartitionSQL(), StringUtil.replace((String)(_partitionTablesSQL + "\n" + this._objectSQLProvider.getTablesSQL()), (String)"create table ", (String)StringBundler.concat((String[])new String[]{"create table ", this._partitionName, "."})), this._getViewsSQL(), this._getRulesSQL()});
    }

    private String _getCreatePartitionSQL() {
        return StringBundler.concat((String[])new String[]{"create schema if not exists ", this._partitionName, ";", "\n"});
    }

    private String _getPartitionIndexesSQL() {
        List lowerCaseControlTableNames = TransformUtil.transform(_controlTableNames, String::toLowerCase);
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.split((String)super.getIndexesSQL(), (char)';')) {
            String lowerCaseLine = StringUtil.trim((String)StringUtil.toLowerCase((String)line));
            String[] parts = StringUtil.split((String)StringUtil.extractLast((String)lowerCaseLine, (String)" on "), (char)' ');
            if (lowerCaseControlTableNames.contains(StringUtil.toLowerCase((String)parts[0]))) continue;
            sb.append(line);
            sb.append(";");
        }
        return sb.toString();
    }

    private String _getPartitionTablesSQL() throws Exception {
        String[] createTableSQLs = StringUtil.split((String)super.getTablesSQL(), (char)';');
        _controlTableNames = new ArrayList<String>();
        _rulesTableColumn = new HashSet<List<String>>();
        StringBundler sb = new StringBundler();
        DataSource dataSource = InfrastructureUtil.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            DBInspector dbInspector = new DBInspector(connection);
            for (String createTableSQL : createTableSQLs) {
                String[] parts;
                if (StringUtil.startsWith((String)(createTableSQL = StringUtil.trim((String)createTableSQL)), (String)"create or replace rule")) {
                    String[] ruleTableColumn = DBPartitionPostgreSQLDB.getRuleTableColumn((String)createTableSQL);
                    _rulesTableColumn.add(Arrays.asList(ruleTableColumn[0], ruleTableColumn[1]));
                    continue;
                }
                if (StringUtil.startsWith((String)createTableSQL, (String)"create table") && dbInspector.isControlTable((parts = createTableSQL.split(" "))[2])) {
                    _controlTableNames.add(parts[2]);
                    continue;
                }
                sb.append("\n");
                sb.append(createTableSQL);
                sb.append(";");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String _getRulesSQL() {
        StringBundler sb = new StringBundler();
        for (List<String> ruleTableColumn : _rulesTableColumn) {
            sb.append("\n");
            sb.append(PostgreSQLDB.getCreateRulesSQL((String)StringBundler.concat((String[])new String[]{this._partitionName, ".", ruleTableColumn.get(0)}), (String)ruleTableColumn.get(1)));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _getViewsSQL() {
        StringBundler sb = new StringBundler(_controlTableNames.size());
        for (String controlTableName : _controlTableNames) {
            sb.append("\n");
            sb.append(StringBundler.concat((String[])new String[]{"create or replace view ", this._partitionName, ".", controlTableName, " as select * from ", controlTableName, ";"}));
            sb.append("\n");
        }
        return sb.toString();
    }
}

