/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.extender.internal;

import com.liferay.portal.configuration.extender.internal.BundleStorage;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContent;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContentFactory;
import com.liferay.portal.configuration.extender.internal.PropertiesFileNamedConfigurationContent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MappingEnumeration;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={NamedConfigurationContentFactory.class})
public class NamedConfigurationPathContentFactory
implements NamedConfigurationContentFactory {
    @Override
    public List<NamedConfigurationContent> create(BundleStorage bundleStorage) {
        Dictionary<String, String> headers = bundleStorage.getHeaders();
        String configurationPath = headers.get("Liferay-Configuration-Path");
        if (configurationPath == null) {
            return null;
        }
        Enumeration<URL> entries = bundleStorage.findEntries(configurationPath, "*.properties", true);
        return ListUtil.fromEnumeration((Enumeration)new MappingEnumeration(entries, (MappingEnumeration.Mapper)new MappingEnumeration.Mapper<URL, NamedConfigurationContent>(){

            public NamedConfigurationContent map(URL url) {
                return new PropertiesFileNamedConfigurationContent(url);
            }
        }));
    }
}

