/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.extender.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.extender.internal.ConfigurationDescription;
import com.liferay.portal.configuration.extender.internal.ConfigurationDescriptionFactory;
import com.liferay.portal.configuration.extender.internal.NamedConfigurationContent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Supplier;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfiguratorExtension
implements Extension {
    private final ConfigurationAdmin _configurationAdmin;
    private final Collection<NamedConfigurationContent> _configurationContents;
    private final Collection<ConfigurationDescriptionFactory> _configurationDescriptionFactories;
    private final Logger _logger;
    private final String _namespace;

    public ConfiguratorExtension(ConfigurationAdmin configurationAdmin, Logger logger, String namespace, Collection<NamedConfigurationContent> namedConfigurationContents, Collection<ConfigurationDescriptionFactory> configurationDescriptionFactories) {
        this._configurationAdmin = configurationAdmin;
        this._logger = logger;
        this._namespace = namespace;
        this._configurationDescriptionFactories = configurationDescriptionFactories;
        this._configurationContents = namedConfigurationContents;
    }

    public void destroy() throws Exception {
    }

    public void start() throws Exception {
        for (NamedConfigurationContent namedConfigurationContent : this._configurationContents) {
            try {
                this._createConfiguration(namedConfigurationContent);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean _configurationExists(String filter) throws InvalidSyntaxException, IOException {
        Object[] configurations = this._configurationAdmin.listConfigurations(filter);
        return ArrayUtil.isNotEmpty((Object[])configurations);
    }

    private void _createConfiguration(NamedConfigurationContent namedConfigurationContent) throws Exception {
        for (ConfigurationDescriptionFactory configurationDescriptionFactory : this._configurationDescriptionFactories) {
            ConfigurationDescription configurationDescription = configurationDescriptionFactory.create(namedConfigurationContent);
            if (configurationDescription == null) continue;
            this._process(configurationDescription);
        }
    }

    private void _process(ConfigurationDescription configurationDescription) throws InvalidSyntaxException, IOException {
        Configuration configuration = null;
        String configuratorURL = null;
        if (configurationDescription.getFactoryPid() == null) {
            String pid = configurationDescription.getPid();
            if (this._configurationExists("(service.pid=" + pid + ")")) {
                return;
            }
            configuration = this._configurationAdmin.getConfiguration(pid, "?");
        } else {
            configuratorURL = this._namespace + "#" + configurationDescription.getPid();
            if (this._configurationExists("(configurator.url=" + configuratorURL + ")")) {
                return;
            }
            configuration = this._configurationAdmin.createFactoryConfiguration(configurationDescription.getFactoryPid(), "?");
        }
        Dictionary properties = null;
        Supplier<Dictionary<String, Object>> propertiesSupplier = configurationDescription.getPropertiesSupplier();
        try {
            properties = (Dictionary)propertiesSupplier.get();
        }
        catch (Throwable t) {
            this._logger.log(2, StringBundler.concat((Object[])new Object[]{"Supplier from description ", configurationDescription, " threw an exception: "}), t);
            return;
        }
        if (configuratorURL != null) {
            properties.put("configurator.url", configuratorURL);
        }
        configuration.update(properties);
    }
}

