/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.jgroups.AddressImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

public class JGroupsReceiver
extends ReceiverAdapter {
    private static final Log _log = LogFactoryUtil.getLog(JGroupsReceiver.class);
    private final Map<ClassLoader, ClassLoader> _classLoaders;
    private final ClusterReceiver _clusterReceiver;
    private final AtomicBoolean _portalStarted = new AtomicBoolean(false);

    public JGroupsReceiver(ClusterReceiver clusterReceiver, Map<ClassLoader, ClassLoader> classLoaders) {
        if (clusterReceiver == null) {
            throw new NullPointerException("Cluster receiver is null");
        }
        this._clusterReceiver = clusterReceiver;
        this._classLoaders = classLoaders;
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            this._portalStarted.set(true);
            return null;
        });
    }

    public void receive(Message message) {
        block12: {
            byte[] rawBuffer = message.getRawBuffer();
            if (rawBuffer == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Message content is null");
                }
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(rawBuffer, message.getOffset(), message.getLength());
            Deserializer deserializer = new Deserializer(byteBuffer.slice());
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)this._classLoaders.computeIfAbsent(contextClassLoader, keyClassLoader -> AggregateClassLoader.getAggregateClassLoader((ClassLoader)keyClassLoader, (ClassLoader[])new ClassLoader[]{JGroupsReceiver.class.getClassLoader()})));){
                this._clusterReceiver.receive(deserializer.readObject(), new AddressImpl(message.getSrc()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this._portalStarted.get()) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Unable to deserialize message payload during startup", (Throwable)classNotFoundException);
                    }
                    return;
                }
                if (!_log.isWarnEnabled()) break block12;
                _log.warn((Object)"Unable to deserialize message payload", (Throwable)classNotFoundException);
            }
        }
    }

    public void viewAccepted(View view) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Accepted view " + String.valueOf(view)));
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        AddressImpl coordinatorAddress = null;
        List jGroupsAddresses = view.getMembers();
        for (int i = 0; i < jGroupsAddresses.size(); ++i) {
            AddressImpl address = new AddressImpl((org.jgroups.Address)jGroupsAddresses.get(i));
            if (i == 0) {
                coordinatorAddress = address;
            }
            addresses.add(address);
        }
        this._clusterReceiver.coordinatorAddressUpdated(coordinatorAddress);
        this._clusterReceiver.addressesUpdated(addresses);
    }
}

