package org.jgroups.tests;

import org.jgroups.util.Util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla implements Runnable {
    protected ServerSocketChannel ch;
    protected Selector selector;
    protected volatile boolean running;

    protected void start() throws IOException {
        ch=ServerSocketChannel.open();
        ch.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 7500));
        ch.configureBlocking(false);
        selector=Selector.open();
        ch.register(selector, SelectionKey.OP_ACCEPT, null);
        running=true;

        new Thread(this).start();

        while(running) {
            selector.select();
            Iterator<SelectionKey> it=selector.selectedKeys().iterator();
            while(it.hasNext()) {
                SelectionKey key=it.next();
                it.remove();
                System.out.printf("selection key: %s\n", key);
                if(key.isAcceptable()) {
                    SocketChannel client_sock=ch.accept();
                    Util.close(client_sock);
                }
            }
        }
        Util.close(selector, ch);
    }

    public void run() {
        Util.sleep(5000);
        running=false;
        System.out.printf("--set running=%b, waking up selector\n", running);
        selector.wakeup();
    }

    public static void main(String[] args) throws Exception {
        new bla().start();


    }


}



