/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration"}, enabled=false, service={ClusterEventListener.class})
public class DebuggingClusterEventListener
implements ClusterEventListener {
    private static final Log _log = LogFactoryUtil.getLog(DebuggingClusterEventListener.class);
    private volatile ClusterExecutorConfiguration _clusterExecutorConfiguration;

    public void processClusterEvent(ClusterEvent clusterEvent) {
        if (!this._clusterExecutorConfiguration.debugEnabled() || !_log.isInfoEnabled()) {
            return;
        }
        ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
        List clusterNodes = clusterEvent.getClusterNodes();
        StringBundler sb = new StringBundler(clusterNodes.size() * 3 + 3);
        sb.append("Cluster event ");
        sb.append((Object)clusterEventType);
        sb.append("\n");
        for (ClusterNode clusterNode : clusterNodes) {
            sb.append("Cluster node ");
            sb.append((Object)clusterNode);
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 1);
        _log.info((Object)sb.toString());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._clusterExecutorConfiguration = (ClusterExecutorConfiguration)ConfigurableUtil.createConfigurable(ClusterExecutorConfiguration.class, properties);
    }
}

