/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.internal.ClusterChannel;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public abstract class BaseClusterChannel
implements ClusterChannel {
    private static final Log _log = LogFactoryUtil.getLog(BaseClusterChannel.class);
    private final ExecutorService _executorService;

    public BaseClusterChannel(ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException("Executor service is null");
        }
        this._executorService = executorService;
    }

    @Override
    public void sendMulticastMessage(Serializable message) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        try {
            this._executorService.execute(() -> this.doSendMessage(message, null));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _log.error((Object)("Unable to send multicast message " + message), (Throwable)rejectedExecutionException);
        }
    }

    @Override
    public void sendUnicastMessage(Serializable message, Address address) {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (address == null) {
            throw new IllegalArgumentException("Address is null");
        }
        try {
            this._executorService.execute(() -> this.doSendMessage(message, address));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to send unitcast message ", message, " to ", address}), (Throwable)rejectedExecutionException);
        }
    }

    protected abstract void doSendMessage(Serializable var1, Address var2);
}

