/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link.messaging;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import com.liferay.portal.cache.multiple.internal.cluster.link.ClusterLinkMessageUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import java.io.Serializable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(enabled=false, property={"destination.name=liferay/cache_replication"}, service={MessageListener.class})
public class ClusterLinkPortalCacheClusterListener
extends BaseMessageListener {
    private ServiceTrackerMap<String, PortalCacheManager<? extends Serializable, ?>> _serviceTrackerMap;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PortalCacheManager.class, null, (serviceReference, emitter) -> {
            PortalCacheManager portalCacheManager = (PortalCacheManager)bundleContext.getService(serviceReference);
            emitter.emit((Object)portalCacheManager.getPortalCacheManagerName());
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    protected void doReceive(Message message) throws Exception {
        PortalCacheManager portalCacheManager = (PortalCacheManager)this._serviceTrackerMap.getService((Object)ClusterLinkMessageUtil.getPortalCacheManagerName(message));
        if (portalCacheManager == null) {
            return;
        }
        PortalCache portalCache = portalCacheManager.fetchPortalCache(ClusterLinkMessageUtil.getPortalCacheName(message));
        if (portalCache == null) {
            return;
        }
        if (portalCache.isSharded()) {
            try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)ClusterLinkMessageUtil.getCompanyId(message));){
                this._handlePortalCacheClusterEvent(message, (PortalCache<Serializable, Serializable>)portalCache);
            }
            return;
        }
        this._handlePortalCacheClusterEvent(message, (PortalCache<Serializable, Serializable>)portalCache);
    }

    private void _handlePortalCacheClusterEvent(Message message, PortalCache<Serializable, Serializable> portalCache) {
        PortalCacheClusterEventType portalCacheClusterEventType = ClusterLinkMessageUtil.getPortalCacheClusterEventType(message);
        if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
            PortalCacheHelperUtil.removeAllWithoutReplicator(portalCache);
        } else if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.PUT) || portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.UPDATE)) {
            Serializable key = ClusterLinkMessageUtil.getKey(message);
            Serializable value = ClusterLinkMessageUtil.getValue(message);
            if (value == null) {
                PortalCacheHelperUtil.removeWithoutReplicator(portalCache, (Serializable)key);
            } else {
                PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)key, (Object)value, (int)ClusterLinkMessageUtil.getTimeToLive(message));
            }
        } else {
            PortalCacheHelperUtil.removeWithoutReplicator(portalCache, (Serializable)ClusterLinkMessageUtil.getKey(message));
        }
    }
}

