/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link;

import com.liferay.portal.cache.multiple.configuration.PortalCacheClusterConfiguration;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEvent;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannel;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannelFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.cache.multiple.configuration.PortalCacheClusterConfiguration"}, enabled=false, service={PortalCacheClusterLink.class})
public class PortalCacheClusterLink {
    @Reference
    private ClusterLink _clusterLink;
    private final AtomicLong _eventCounter = new AtomicLong(0L);
    private volatile List<PortalCacheClusterChannel> _portalCacheClusterChannels;

    public void sendEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        long count = this._eventCounter.getAndIncrement();
        int size = this._portalCacheClusterChannels.size();
        PortalCacheClusterChannel portalCacheClusterChannel = this._portalCacheClusterChannels.get((int)(count % (long)size));
        portalCacheClusterChannel.sendEvent(portalCacheClusterEvent);
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        PortalCacheClusterConfiguration portalCacheClusterConfiguration = (PortalCacheClusterConfiguration)ConfigurableUtil.createConfigurable(PortalCacheClusterConfiguration.class, (Dictionary)componentContext.getProperties());
        Priority[] priorities = portalCacheClusterConfiguration.priorities();
        this._portalCacheClusterChannels = new ArrayList<PortalCacheClusterChannel>(priorities.length);
        for (Priority priority : priorities) {
            PortalCacheClusterChannel portalCacheClusterChannel = PortalCacheClusterChannelFactory.createPortalCacheClusterChannel(this._clusterLink, priority, portalCacheClusterConfiguration.usingCoalescedPipe());
            this._portalCacheClusterChannels.add(portalCacheClusterChannel);
        }
    }

    @Deactivate
    protected void deactivate() {
        for (PortalCacheClusterChannel portalCacheClusterChannel : this._portalCacheClusterChannels) {
            portalCacheClusterChannel.destroy();
        }
        this._portalCacheClusterChannels.clear();
        this._portalCacheClusterChannels = null;
    }
}

