/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"bulk.selection.action.key=delete.object"}, service={BulkSelectionAction.class})
public class DeleteObjectBulkSelectionAction
implements BulkSelectionAction<Object> {
    private static final Log _log = LogFactoryUtil.getLog(DeleteObjectBulkSelectionAction.class);
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private TrashHelper _trashHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(User user, BulkSelection<Object> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(GetterUtil.getLong((Object)inputMap.get("bulkActionTaskId")));
        Map values = objectEntry.getValues();
        values.put("numberOfItems", bulkSelection.getSize());
        String executionStatus = "completed";
        AtomicInteger numberOfFailedItems = new AtomicInteger(0);
        AtomicInteger numberOfSuccessfulItems = new AtomicInteger(0);
        try {
            values.put("executionStatus", "started");
            objectEntry = this._partialUpdateObjectEntry(user.getUserId(), objectEntry, values);
            values = objectEntry.getValues();
            bulkSelection.forEach(object -> {
                try {
                    if (object instanceof ObjectEntry) {
                        ObjectEntry objectObjectEntry = (ObjectEntry)object;
                        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectObjectEntry.getObjectDefinitionId());
                        DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getCompanyId(), objectDefinition.getStorageType()));
                        defaultObjectEntryManager.deleteObjectEntry(objectDefinition, objectObjectEntry.getObjectEntryId());
                    } else {
                        ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
                        this._deleteObjectEntryFolder(user.getUserId(), objectEntryFolder);
                    }
                    numberOfSuccessfulItems.getAndIncrement();
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Throwable)exception);
                    }
                    numberOfFailedItems.getAndIncrement();
                }
            });
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            executionStatus = "failed";
        }
        finally {
            values.put("completionDate", new Date());
            values.put("executionStatus", executionStatus);
            values.put("numberOfFailedItems", numberOfFailedItems.get());
            values.put("numberOfSuccessfulItems", numberOfSuccessfulItems.get());
            this._partialUpdateObjectEntry(user.getUserId(), objectEntry, values);
        }
    }

    private void _deleteObjectEntryFolder(long userId, ObjectEntryFolder objectEntryFolder) throws PortalException {
        if (FeatureFlagManagerUtil.isEnabled((long)objectEntryFolder.getCompanyId(), (String)"LPD-17564") && objectEntryFolder.isTrashable(this._trashHelper)) {
            this._objectEntryFolderLocalService.moveObjectEntryFolderToTrash(userId, objectEntryFolder, new ServiceContext());
        } else {
            this._objectEntryFolderLocalService.deleteObjectEntryFolder(objectEntryFolder.getObjectEntryFolderId());
        }
    }

    private ObjectEntry _partialUpdateObjectEntry(long userId, ObjectEntry objectEntry, Map<String, Serializable> values) throws PortalException {
        return this._objectEntryLocalService.partialUpdateObjectEntry(userId, objectEntry.getObjectEntryId(), objectEntry.getObjectEntryFolderId(), values, new ServiceContext());
    }
}

