/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.service.ObjectValidationRuleLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectValidationRule service. Represents a row in the &quot;ObjectValidationRule&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectValidationRuleImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectValidationRuleImpl
 * @see ObjectValidationRule
 * @generated
 */
public abstract class ObjectValidationRuleBaseImpl
	extends ObjectValidationRuleModelImpl implements ObjectValidationRule {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object validation rule model instance should use the <code>ObjectValidationRule</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectValidationRuleLocalServiceUtil.addObjectValidationRule(this);
		}
		else {
			ObjectValidationRuleLocalServiceUtil.updateObjectValidationRule(
				this);
		}
	}

}