/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectLayoutTabModelListener
extends BaseModelListener<ObjectLayoutTab> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectLayoutTab objectLayoutTab) throws ModelListenerException {
        this._route("ADD", objectLayoutTab);
    }

    public void onBeforeRemove(ObjectLayoutTab objectLayoutTab) throws ModelListenerException {
        this._route("DELETE", objectLayoutTab);
    }

    public void onBeforeUpdate(ObjectLayoutTab originalObjectLayoutTab, ObjectLayoutTab objectLayoutTab) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectLayoutTab.class.getName(), (long)objectLayoutTab.getObjectLayoutTabId(), this._getModifiedAttributes(originalObjectLayoutTab, objectLayoutTab)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectLayoutTab originalObjectLayoutTab, ObjectLayoutTab objectLayoutTab) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectLayoutTab, (Object)originalObjectLayoutTab);
        attributesBuilder.add("nameMap");
        attributesBuilder.add("objectLayoutId");
        attributesBuilder.add("objectRelationshipId");
        attributesBuilder.add("priority");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectLayoutTab objectLayoutTab) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectLayoutTab.class.getName(), (long)objectLayoutTab.getObjectLayoutTabId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("nameMap", (Object)objectLayoutTab.getNameMap()).put("objectLayoutId", objectLayoutTab.getObjectLayoutId()).put("objectRelationshipId", objectLayoutTab.getObjectRelationshipId()).put("priority", objectLayoutTab.getPriority());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

