/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.workflow;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectEntryWorkflowHandler
extends BaseWorkflowHandler<ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryWorkflowHandler.class);
    private final KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public ObjectEntryWorkflowHandler(KaleoDefinitionLocalService kaleoDefinitionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._kaleoDefinitionLocalService = kaleoDefinitionLocalService;
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }

    public AssetRenderer<ObjectEntry> getAssetRenderer(long classPK) throws PortalException {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(classPK);
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        AssetRendererFactory objectEntryAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)objectDefinition.getClassName());
        return objectEntryAssetRendererFactory.getAssetRenderer(classPK);
    }

    public String getClassName() {
        return this._objectDefinition.getClassName();
    }

    public long getEntryClassPK(long companyId, HttpServletRequest httpServletRequest, WorkflowTask workflowTask) throws PortalException {
        long assetEntryClassPK = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"assetEntryClassPK");
        if (assetEntryClassPK > 0L) {
            return assetEntryClassPK;
        }
        return super.getEntryClassPK(companyId, httpServletRequest, workflowTask);
    }

    public String getTitle(long classPK, Locale locale) {
        try {
            ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(classPK);
            return objectEntry.getTitleValue();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return "";
        }
    }

    public String getType(Locale locale) {
        return this._objectDefinition.getLabel(locale);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-42553")) {
            workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, ObjectEntryFolder.class.getName(), this._getObjectEntryFolderId(classPK), -1L, true);
        }
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = super.getWorkflowDefinitionLink(companyId, groupId, classPK);
        }
        if (workflowDefinitionLink == null) {
            return null;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.fetchKaleoDefinition(workflowDefinitionLink.getWorkflowDefinitionName(), serviceContext);
        if (kaleoDefinition != null && kaleoDefinition.isActive()) {
            return workflowDefinitionLink;
        }
        return null;
    }

    public boolean isVisible(Group group) {
        return !group.isSite() || Objects.equals("site", this._objectDefinition.getScope());
    }

    public ObjectEntry updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._objectEntryLocalService.updateStatus(userId, classPK, status, serviceContext);
    }

    public ObjectEntry updateStatus(ObjectEntry objectEntry, int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        return this._objectEntryLocalService.updateStatus(userId, objectEntry, status, serviceContext);
    }

    private long _getObjectEntryFolderId(long classPK) throws PortalException {
        Long objectEntryFolderId = ObjectEntryThreadLocal.getObjectEntryFolderId();
        if (objectEntryFolderId != null) {
            return objectEntryFolderId;
        }
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(classPK);
        return objectEntry.getObjectEntryFolderId();
    }
}

