/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.UserBagFactoryUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class ObjectEntryModelResourcePermission
implements ModelResourcePermission<ObjectEntry> {
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final GroupLocalService _groupLocalService;
    private final String _modelName;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final Supplier<ModelResourcePermissionLogic<ObjectEntry>> _objectEntryModelResourcePermissionLogicSupplier;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final PortletResourcePermission _portletResourcePermission;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;

    public ObjectEntryModelResourcePermission(AccountEntryLocalService accountEntryLocalService, AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, GroupLocalService groupLocalService, String modelName, ObjectActionLocalService objectActionLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, Supplier<ModelResourcePermissionLogic<ObjectEntry>> objectEntryModelResourcePermissionLogicSupplier, ObjectFieldLocalService objectFieldLocalService, PortletResourcePermission portletResourcePermission, ResourcePermissionLocalService resourcePermissionLocalService, UserGroupRoleLocalService userGroupRoleLocalService) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._groupLocalService = groupLocalService;
        this._modelName = modelName;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectEntryModelResourcePermissionLogicSupplier = objectEntryModelResourcePermissionLogicSupplier;
        this._objectFieldLocalService = objectFieldLocalService;
        this._portletResourcePermission = portletResourcePermission;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
    }

    public void check(PermissionChecker permissionChecker, long objectEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectEntryId, actionId)) {
            this._throwPrincipalException(actionId, this._objectEntryLocalService.getObjectEntry(objectEntryId), permissionChecker);
        }
    }

    public void check(PermissionChecker permissionChecker, ObjectEntry objectEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectEntry, actionId)) {
            this._throwPrincipalException(actionId, objectEntry, permissionChecker);
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long objectEntryId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._objectEntryLocalService.getObjectEntry(objectEntryId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, ObjectEntry objectEntry, String actionId) throws PortalException {
        if (objectEntry.getRootObjectEntryId() != 0L && !this._isObjectActionName(actionId, objectEntry.getObjectDefinitionId())) {
            ObjectEntry rootObjectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntry.getRootObjectEntryId());
            if (rootObjectEntry == null) {
                return true;
            }
            objectEntry = rootObjectEntry;
        }
        User user = permissionChecker.getUser();
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        if (this._hasAssigneeUpdatePermission(actionId, objectDefinition, objectEntry, user)) {
            return true;
        }
        if (user.isGuestUser()) {
            return permissionChecker.hasPermission(objectEntry.getGroupId(), objectDefinition.getClassName(), objectEntry.getHeadObjectEntryId(), actionId);
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), objectDefinition.getClassName(), objectEntry.getHeadObjectEntryId(), objectEntry.getUserId(), actionId) || permissionChecker.hasPermission(objectEntry.getGroupId(), objectDefinition.getClassName(), objectEntry.getHeadObjectEntryId(), actionId)) {
            return true;
        }
        ModelResourcePermissionLogic<ObjectEntry> objectEntryModelResourcePermissionLogic = this._objectEntryModelResourcePermissionLogicSupplier.get();
        if (!objectEntry.isHead()) {
            objectEntry = this._objectEntryLocalService.fetchObjectEntry(objectEntry.getHeadObjectEntryId());
        }
        if ((!actionId.equals("VIEW") || objectEntry.isApproved()) && objectEntryModelResourcePermissionLogic != null && Objects.equals(objectEntryModelResourcePermissionLogic.contains(permissionChecker, objectDefinition.getClassName(), (GroupedModel)objectEntry, actionId), Boolean.TRUE)) {
            return true;
        }
        if (!objectDefinition.isAccountEntryRestricted()) {
            return false;
        }
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectDefinition.getAccountEntryRestrictedObjectFieldId());
        long accountEntryId = MapUtil.getLong((Map)objectEntry.getValues(), (String)objectField.getName());
        if (accountEntryId == 0L) {
            return true;
        }
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
        if (Objects.equals(actionId, "VIEW")) {
            return ArrayUtil.contains((long[])ListUtil.toLongArray((List)this._accountEntryLocalService.getUserAccountEntries(permissionChecker.getUserId(), Long.valueOf(0L), null, AccountConstants.ACCOUNT_ENTRY_TYPES_DEFAULT_ALLOWED_TYPES, Integer.valueOf(0), -1, -1), AccountEntryModel::getAccountEntryId), (long)accountEntryId);
        }
        HashSet rolesIds = new HashSet();
        rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), accountEntry.getAccountEntryGroupId()), UserGroupRoleModel::getRoleId));
        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRels(accountEntryId);
        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
            Organization organization = accountEntryOrganizationRel.getOrganization();
            Group group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), organization.getOrganizationId());
            rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            for (Organization ancestorOrganization : organization.getAncestors()) {
                group = this._groupLocalService.getOrganizationGroup(objectDefinition.getCompanyId(), ancestorOrganization.getOrganizationId());
                rolesIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRoles(permissionChecker.getUserId(), group.getGroupId()), UserGroupRoleModel::getRoleId));
            }
        }
        for (Long roleId : rolesIds) {
            ResourcePermission resourcePermission = this._resourcePermissionLocalService.fetchResourcePermission(objectDefinition.getCompanyId(), objectDefinition.getClassName(), 3, "0", roleId.longValue());
            if (resourcePermission == null || !resourcePermission.hasActionId(actionId)) continue;
            return true;
        }
        return false;
    }

    public String getModelName() {
        return this._modelName;
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }

    private boolean _hasAssigneeUpdatePermission(String actionId, ObjectDefinition objectDefinition, ObjectEntry objectEntry, User user) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-6233") || !actionId.equals("UPDATE")) {
            return false;
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectFieldByBusinessType(objectDefinition.getObjectDefinitionId(), "Assignee", null);
        if (objectField == null) {
            return false;
        }
        Map values = objectEntry.getValues();
        Map assigneeMap = (Map)values.get(objectField.getName());
        if (MapUtil.isEmpty((Map)assigneeMap)) {
            return false;
        }
        String className = PortalUtil.fetchClassName((long)GetterUtil.getLong(assigneeMap.get("classNameId")));
        long classPK = GetterUtil.getLong(assigneeMap.get("classPK"));
        if (StringUtil.equals((String)className, (String)Role.class.getName())) {
            UserBag userBag = UserBagFactoryUtil.create((User)user);
            for (long roleId : userBag.getRoleIds()) {
                if (roleId != classPK) continue;
                return true;
            }
            Object object = this._userGroupRoleLocalService.getUserGroupRoles(user.getUserId()).iterator();
            while (object.hasNext()) {
                UserGroupRole userGroupRole = (UserGroupRole)object.next();
                if (userGroupRole.getRoleId() != classPK) continue;
                return true;
            }
        } else if (StringUtil.equals((String)className, (String)User.class.getName()) && user.getUserId() == classPK) {
            return true;
        }
        return false;
    }

    private boolean _isObjectActionName(String actionId, long objectDefinitionId) {
        for (ObjectAction objectAction : this._objectActionLocalService.getObjectActions(objectDefinitionId, "standalone")) {
            if (!Objects.equals(objectAction.getName(), actionId)) continue;
            return true;
        }
        return false;
    }

    private void _throwPrincipalException(String actionId, ObjectEntry objectEntry, PermissionChecker permissionChecker) throws PortalException {
        if (objectEntry.getRootObjectEntryId() != 0L) {
            objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntry.getRootObjectEntryId());
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            throw new PrincipalException.MustHavePermission(permissionChecker, objectDefinition.getClassName(), objectEntry.getHeadObjectEntryId(), new String[]{actionId});
        }
        throw new PrincipalException.MustHavePermission(permissionChecker, this._modelName, objectEntry.getHeadObjectEntryId(), new String[]{actionId});
    }
}

