/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.Assignee;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lazy.referencing.LazyReferencingThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Assignee"}, service={ObjectFieldBusinessType.class})
public class AssigneeObjectFieldBusinessType
implements ObjectFieldBusinessType {
    private static final Log _log = LogFactoryUtil.getLog(AssigneeObjectFieldBusinessType.class);
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "assignee";
    }

    public String getDescription(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"assign-the-entry-to-a-user-or-role");
    }

    public Object getDisplayContextValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        return values.get(objectField.getName());
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"assignee");
    }

    public String getName() {
        return "Assignee";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public Object getValue(Long groupId, ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        Object value = values.get(objectField.getName());
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Assignee) {
                Assignee assignee = (Assignee)value;
                return this._getValue(objectField.getCompanyId(), assignee.getExternalReferenceCode(), assignee.getName(), assignee.getTypeAsString());
            }
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                return this._getValue(objectField.getCompanyId(), MapUtil.getString((Map)valueMap, (Object)"externalReferenceCode"), MapUtil.getString((Map)valueMap, (Object)"name"), MapUtil.getString((Map)valueMap, (Object)"type"));
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new ObjectEntryValuesException.InvalidValue(objectField.getName());
        }
        return null;
    }

    public boolean isLocalizationSupported(ObjectField objectField) {
        return false;
    }

    public boolean isVisible(ObjectDefinition objectDefinition) {
        return FeatureFlagManagerUtil.isEnabled((long)objectDefinition.getCompanyId(), (String)"LPD-6233");
    }

    private Object _getValue(long companyId, String externalReferenceCode, String name, String type) throws Exception {
        if (StringUtil.equals((String)type, (String)Assignee.Type.ROLE.toString())) {
            return HashMapBuilder.put((Object)"classNameId", (Object)this._portal.getClassNameId(Role.class.getName())).put((Object)"classPK", () -> {
                Role role = null;
                role = LazyReferencingThreadLocal.isEnabled() ? this._roleService.getOrAddEmptyRole(externalReferenceCode, "", 0L, name, 1) : this._roleLocalService.getRoleByExternalReferenceCode(externalReferenceCode, companyId);
                return role.getRoleId();
            }).build();
        }
        if (StringUtil.equals((String)type, (String)Assignee.Type.USER.toString())) {
            return HashMapBuilder.put((Object)"classNameId", (Object)this._portal.getClassNameId(User.class.getName())).put((Object)"classPK", () -> {
                User user = this._userLocalService.getUserByExternalReferenceCode(externalReferenceCode, companyId);
                return user.getUserId();
            }).build();
        }
        return Collections.emptyMap();
    }
}

