/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.base.ObjectEntryVersionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntryVersion"}, service={AopService.class})
public class ObjectEntryVersionServiceImpl
extends ObjectEntryVersionServiceBaseImpl {
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryService _objectEntryService;

    public ObjectEntryVersion deleteObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        this._checkModelResourcePermission(objectEntryId, "DELETE");
        return this.objectEntryVersionLocalService.deleteObjectEntryVersion(objectEntryId, version);
    }

    public ObjectEntryVersion expireObjectEntryVersion(ObjectEntry objectEntry, ServiceContext serviceContext, int version) throws PortalException {
        this._objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        return this.objectEntryVersionLocalService.expireObjectEntryVersion(this.getUserId(), objectEntry, version, serviceContext);
    }

    public void expireObjectEntryVersions(ObjectEntry objectEntry, ServiceContext serviceContext) throws Exception {
        this._objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        this.objectEntryVersionLocalService.expireObjectEntryVersions(this.getUserId(), objectEntry, serviceContext);
    }

    public ObjectEntryVersion getObjectEntryVersion(long objectEntryId, int version) throws PortalException {
        this._checkModelResourcePermission(objectEntryId, "UPDATE");
        return this.objectEntryVersionLocalService.getObjectEntryVersion(objectEntryId, version);
    }

    public List<ObjectEntryVersion> getObjectEntryVersions(long objectEntryId, int start, int end) throws PortalException {
        this._checkModelResourcePermission(objectEntryId, "UPDATE");
        return this.objectEntryVersionLocalService.getObjectEntryVersions(objectEntryId, start, end);
    }

    public int getObjectEntryVersionsCount(long objectEntryId) throws PortalException {
        this._checkModelResourcePermission(objectEntryId, "UPDATE");
        return this.objectEntryVersionLocalService.getObjectEntryVersionsCount(objectEntryId);
    }

    private void _checkModelResourcePermission(long objectEntryId, String actionId) throws PortalException {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntryId);
        this._objectEntryService.checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntryId, actionId);
    }
}

