/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;

public class ObjectEntryBatchReindexer {
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;

    public ObjectEntryBatchReindexer(DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, ObjectEntryLocalService objectEntryLocalService, ObjectDefinition objectDefinition) {
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectDefinition = objectDefinition;
    }

    public String getClassName() {
        return this._objectDefinition.getClassName();
    }

    public void reindex(IndexerDocumentBuilder indexerDocumentBuilder, long accountEntryId, long companyId) {
        BatchIndexingActionable batchIndexingActionable = this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._objectEntryLocalService.getIndexableActionableDynamicQuery());
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName((String)"objectDefinitionId");
            dynamicQuery.add(property.eq((Object)this._objectDefinition.getObjectDefinitionId()));
        });
        batchIndexingActionable.setCompanyId(companyId);
        batchIndexingActionable.setPerformActionMethod(objectEntry -> batchIndexingActionable.addDocuments(new Document[]{indexerDocumentBuilder.getDocument((BaseModel)objectEntry)}));
        batchIndexingActionable.performActions();
    }
}

