/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.model.ObjectEntryVersionModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectEntryVersion service. Represents a row in the &quot;ObjectEntryVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectEntryVersionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectEntryVersionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectEntryVersionImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectEntryVersionModelImpl
	extends BaseModelImpl<ObjectEntryVersion>
	implements ObjectEntryVersionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object entry version model instance should use the <code>ObjectEntryVersion</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectEntryVersion";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectEntryVersionId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectDefinitionId", Types.BIGINT}, {"objectEntryId", Types.BIGINT},
		{"content", Types.CLOB}, {"displayDate", Types.TIMESTAMP},
		{"expirationDate", Types.TIMESTAMP}, {"reviewDate", Types.TIMESTAMP},
		{"version", Types.INTEGER}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectEntryVersionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("content", Types.CLOB);
		TABLE_COLUMNS_MAP.put("displayDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("reviewDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("version", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectEntryVersion (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectEntryVersionId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId LONG,objectEntryId LONG,content TEXT null,displayDate DATE null,expirationDate DATE null,reviewDate DATE null,version INTEGER,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectEntryVersion";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectEntryVersion.objectEntryVersionId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectEntryVersion.objectEntryVersionId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTENTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTENTRYVERSIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectEntryVersionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectEntryVersionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectEntryVersionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectEntryVersionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectEntryVersion.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectEntryVersion.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectEntryVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectEntryVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectEntryVersion, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectEntryVersion)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectEntryVersion, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectEntryVersion, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectEntryVersion)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectEntryVersion, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectEntryVersion, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectEntryVersion, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectEntryVersion, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectEntryVersion, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectEntryVersion::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectEntryVersion::getUuid);
			attributeGetterFunctions.put(
				"objectEntryVersionId",
				ObjectEntryVersion::getObjectEntryVersionId);
			attributeGetterFunctions.put(
				"companyId", ObjectEntryVersion::getCompanyId);
			attributeGetterFunctions.put(
				"userId", ObjectEntryVersion::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectEntryVersion::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectEntryVersion::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectEntryVersion::getModifiedDate);
			attributeGetterFunctions.put(
				"objectDefinitionId",
				ObjectEntryVersion::getObjectDefinitionId);
			attributeGetterFunctions.put(
				"objectEntryId", ObjectEntryVersion::getObjectEntryId);
			attributeGetterFunctions.put(
				"content", ObjectEntryVersion::getContent);
			attributeGetterFunctions.put(
				"displayDate", ObjectEntryVersion::getDisplayDate);
			attributeGetterFunctions.put(
				"expirationDate", ObjectEntryVersion::getExpirationDate);
			attributeGetterFunctions.put(
				"reviewDate", ObjectEntryVersion::getReviewDate);
			attributeGetterFunctions.put(
				"version", ObjectEntryVersion::getVersion);
			attributeGetterFunctions.put(
				"status", ObjectEntryVersion::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", ObjectEntryVersion::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", ObjectEntryVersion::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", ObjectEntryVersion::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectEntryVersion, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectEntryVersion, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectEntryVersion, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectEntryVersion, String>)
					ObjectEntryVersion::setUuid);
			attributeSetterBiConsumers.put(
				"objectEntryVersionId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setObjectEntryVersionId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectEntryVersion, String>)
					ObjectEntryVersion::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectDefinitionId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setObjectDefinitionId);
			attributeSetterBiConsumers.put(
				"objectEntryId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setObjectEntryId);
			attributeSetterBiConsumers.put(
				"content",
				(BiConsumer<ObjectEntryVersion, String>)
					ObjectEntryVersion::setContent);
			attributeSetterBiConsumers.put(
				"displayDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setDisplayDate);
			attributeSetterBiConsumers.put(
				"expirationDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setExpirationDate);
			attributeSetterBiConsumers.put(
				"reviewDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setReviewDate);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<ObjectEntryVersion, Integer>)
					ObjectEntryVersion::setVersion);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<ObjectEntryVersion, Integer>)
					ObjectEntryVersion::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<ObjectEntryVersion, Long>)
					ObjectEntryVersion::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<ObjectEntryVersion, String>)
					ObjectEntryVersion::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<ObjectEntryVersion, Date>)
					ObjectEntryVersion::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getObjectEntryVersionId() {
		return _objectEntryVersionId;
	}

	@Override
	public void setObjectEntryVersionId(long objectEntryVersionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectEntryVersionId = objectEntryVersionId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalCreateDate() {
		return getColumnOriginalValue("createDate");
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
	}

	@JSON
	@Override
	public long getObjectEntryId() {
		return _objectEntryId;
	}

	@Override
	public void setObjectEntryId(long objectEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectEntryId = objectEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectEntryId"));
	}

	@JSON
	@Override
	public String getContent() {
		if (_content == null) {
			return "";
		}
		else {
			return _content;
		}
	}

	@Override
	public void setContent(String content) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_content = content;
	}

	@JSON
	@Override
	public Date getDisplayDate() {
		return _displayDate;
	}

	@Override
	public void setDisplayDate(Date displayDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_displayDate = displayDate;
	}

	@JSON
	@Override
	public Date getExpirationDate() {
		return _expirationDate;
	}

	@Override
	public void setExpirationDate(Date expirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_expirationDate = expirationDate;
	}

	@JSON
	@Override
	public Date getReviewDate() {
		return _reviewDate;
	}

	@Override
	public void setReviewDate(Date reviewDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reviewDate = reviewDate;
	}

	@JSON
	@Override
	public int getVersion() {
		return _version;
	}

	@Override
	public void setVersion(int version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalVersion() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("version"));
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectEntryVersion.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectEntryVersion.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectEntryVersion toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectEntryVersion>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectEntryVersionImpl objectEntryVersionImpl =
			new ObjectEntryVersionImpl();

		objectEntryVersionImpl.setMvccVersion(getMvccVersion());
		objectEntryVersionImpl.setUuid(getUuid());
		objectEntryVersionImpl.setObjectEntryVersionId(
			getObjectEntryVersionId());
		objectEntryVersionImpl.setCompanyId(getCompanyId());
		objectEntryVersionImpl.setUserId(getUserId());
		objectEntryVersionImpl.setUserName(getUserName());
		objectEntryVersionImpl.setCreateDate(getCreateDate());
		objectEntryVersionImpl.setModifiedDate(getModifiedDate());
		objectEntryVersionImpl.setObjectDefinitionId(getObjectDefinitionId());
		objectEntryVersionImpl.setObjectEntryId(getObjectEntryId());
		objectEntryVersionImpl.setContent(getContent());
		objectEntryVersionImpl.setDisplayDate(getDisplayDate());
		objectEntryVersionImpl.setExpirationDate(getExpirationDate());
		objectEntryVersionImpl.setReviewDate(getReviewDate());
		objectEntryVersionImpl.setVersion(getVersion());
		objectEntryVersionImpl.setStatus(getStatus());
		objectEntryVersionImpl.setStatusByUserId(getStatusByUserId());
		objectEntryVersionImpl.setStatusByUserName(getStatusByUserName());
		objectEntryVersionImpl.setStatusDate(getStatusDate());

		objectEntryVersionImpl.resetOriginalValues();

		return objectEntryVersionImpl;
	}

	@Override
	public ObjectEntryVersion cloneWithOriginalValues() {
		ObjectEntryVersionImpl objectEntryVersionImpl =
			new ObjectEntryVersionImpl();

		objectEntryVersionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectEntryVersionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectEntryVersionImpl.setObjectEntryVersionId(
			this.<Long>getColumnOriginalValue("objectEntryVersionId"));
		objectEntryVersionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectEntryVersionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectEntryVersionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectEntryVersionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectEntryVersionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectEntryVersionImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectEntryVersionImpl.setObjectEntryId(
			this.<Long>getColumnOriginalValue("objectEntryId"));
		objectEntryVersionImpl.setContent(
			this.<String>getColumnOriginalValue("content"));
		objectEntryVersionImpl.setDisplayDate(
			this.<Date>getColumnOriginalValue("displayDate"));
		objectEntryVersionImpl.setExpirationDate(
			this.<Date>getColumnOriginalValue("expirationDate"));
		objectEntryVersionImpl.setReviewDate(
			this.<Date>getColumnOriginalValue("reviewDate"));
		objectEntryVersionImpl.setVersion(
			this.<Integer>getColumnOriginalValue("version"));
		objectEntryVersionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		objectEntryVersionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		objectEntryVersionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		objectEntryVersionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return objectEntryVersionImpl;
	}

	@Override
	public int compareTo(ObjectEntryVersion objectEntryVersion) {
		long primaryKey = objectEntryVersion.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectEntryVersion)) {
			return false;
		}

		ObjectEntryVersion objectEntryVersion = (ObjectEntryVersion)object;

		long primaryKey = objectEntryVersion.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectEntryVersion> toCacheModel() {
		ObjectEntryVersionCacheModel objectEntryVersionCacheModel =
			new ObjectEntryVersionCacheModel();

		objectEntryVersionCacheModel.mvccVersion = getMvccVersion();

		objectEntryVersionCacheModel.uuid = getUuid();

		String uuid = objectEntryVersionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectEntryVersionCacheModel.uuid = null;
		}

		objectEntryVersionCacheModel.objectEntryVersionId =
			getObjectEntryVersionId();

		objectEntryVersionCacheModel.companyId = getCompanyId();

		objectEntryVersionCacheModel.userId = getUserId();

		objectEntryVersionCacheModel.userName = getUserName();

		String userName = objectEntryVersionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectEntryVersionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectEntryVersionCacheModel.createDate = createDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectEntryVersionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectEntryVersionCacheModel.objectDefinitionId =
			getObjectDefinitionId();

		objectEntryVersionCacheModel.objectEntryId = getObjectEntryId();

		objectEntryVersionCacheModel.content = getContent();

		String content = objectEntryVersionCacheModel.content;

		if ((content != null) && (content.length() == 0)) {
			objectEntryVersionCacheModel.content = null;
		}

		Date displayDate = getDisplayDate();

		if (displayDate != null) {
			objectEntryVersionCacheModel.displayDate = displayDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.displayDate = Long.MIN_VALUE;
		}

		Date expirationDate = getExpirationDate();

		if (expirationDate != null) {
			objectEntryVersionCacheModel.expirationDate =
				expirationDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.expirationDate = Long.MIN_VALUE;
		}

		Date reviewDate = getReviewDate();

		if (reviewDate != null) {
			objectEntryVersionCacheModel.reviewDate = reviewDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.reviewDate = Long.MIN_VALUE;
		}

		objectEntryVersionCacheModel.version = getVersion();

		objectEntryVersionCacheModel.status = getStatus();

		objectEntryVersionCacheModel.statusByUserId = getStatusByUserId();

		objectEntryVersionCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = objectEntryVersionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			objectEntryVersionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			objectEntryVersionCacheModel.statusDate = statusDate.getTime();
		}
		else {
			objectEntryVersionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return objectEntryVersionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectEntryVersion, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectEntryVersion, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectEntryVersion, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectEntryVersion)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectEntryVersion>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectEntryVersion.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectEntryVersionId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId;
	private long _objectEntryId;
	private String _content;
	private Date _displayDate;
	private Date _expirationDate;
	private Date _reviewDate;
	private int _version;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectEntryVersion, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectEntryVersion)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"objectEntryVersionId", _objectEntryVersionId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("objectEntryId", _objectEntryId);
		_columnOriginalValues.put("content", _content);
		_columnOriginalValues.put("displayDate", _displayDate);
		_columnOriginalValues.put("expirationDate", _expirationDate);
		_columnOriginalValues.put("reviewDate", _reviewDate);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectEntryVersionId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectDefinitionId", 256L);

		columnBitmasks.put("objectEntryId", 512L);

		columnBitmasks.put("content", 1024L);

		columnBitmasks.put("displayDate", 2048L);

		columnBitmasks.put("expirationDate", 4096L);

		columnBitmasks.put("reviewDate", 8192L);

		columnBitmasks.put("version", 16384L);

		columnBitmasks.put("status", 32768L);

		columnBitmasks.put("statusByUserId", 65536L);

		columnBitmasks.put("statusByUserName", 131072L);

		columnBitmasks.put("statusDate", 262144L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectEntryVersion _escapedModel;

}