/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.exception.NoSuchObjectViewException;
import com.liferay.object.model.ObjectView;
import com.liferay.object.model.ObjectViewTable;
import com.liferay.object.model.impl.ObjectViewImpl;
import com.liferay.object.model.impl.ObjectViewModelImpl;
import com.liferay.object.service.persistence.ObjectViewPersistence;
import com.liferay.object.service.persistence.ObjectViewUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectViewPersistence.class})
public class ObjectViewPersistenceImpl
extends BasePersistenceImpl<ObjectView>
implements ObjectViewPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ObjectViewImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "objectView.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(objectView.uuid IS NULL OR objectView.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "objectView.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(objectView.uuid IS NULL OR objectView.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "objectView.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathWithoutPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathCountByObjectDefinitionId;
    private static final String _FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2 = "objectView.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByODI_DOV;
    private FinderPath _finderPathWithoutPaginationFindByODI_DOV;
    private FinderPath _finderPathCountByODI_DOV;
    private static final String _FINDER_COLUMN_ODI_DOV_OBJECTDEFINITIONID_2 = "objectView.objectDefinitionId = ? AND ";
    private static final String _FINDER_COLUMN_ODI_DOV_DEFAULTOBJECTVIEW_2 = "objectView.defaultObjectView = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OBJECTVIEW = "SELECT objectView FROM ObjectView objectView";
    private static final String _SQL_SELECT_OBJECTVIEW_WHERE = "SELECT objectView FROM ObjectView objectView WHERE ";
    private static final String _SQL_COUNT_OBJECTVIEW = "SELECT COUNT(objectView) FROM ObjectView objectView";
    private static final String _SQL_COUNT_OBJECTVIEW_WHERE = "SELECT COUNT(objectView) FROM ObjectView objectView WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "objectView.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ObjectView exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ObjectView exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ObjectViewPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<ObjectView> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<ObjectView> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<ObjectView> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectView> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<ObjectView> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectView> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectView objectView : list) {
                if (uuid.equals(objectView.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectView.objectViewId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectView findByUuid_First(String uuid, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByUuid_First(uuid, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByUuid_First(String uuid, OrderByComparator<ObjectView> orderByComparator) {
        List<ObjectView> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView findByUuid_Last(String uuid, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByUuid_Last(uuid, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByUuid_Last(String uuid, OrderByComparator<ObjectView> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<ObjectView> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView[] findByUuid_PrevAndNext(long objectViewId, String uuid, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        uuid = Objects.toString(uuid, "");
        ObjectView objectView = this.findByPrimaryKey(objectViewId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectView[] array = new ObjectViewImpl[]{this.getByUuid_PrevAndNext(session, objectView, uuid, orderByComparator, true), objectView, this.getByUuid_PrevAndNext(session, objectView, uuid, orderByComparator, false)};
            ObjectView[] objectViewArray = array;
            return objectViewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectView getByUuid_PrevAndNext(Session session, ObjectView objectView, String uuid, OrderByComparator<ObjectView> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectView.objectViewId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectView)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectView)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (ObjectView objectView : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)objectView);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTVIEW_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectView> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<ObjectView> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<ObjectView> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectView> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<ObjectView> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectView> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectView objectView : list) {
                if (uuid.equals(objectView.getUuid()) && companyId == objectView.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectView.objectViewId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectView findByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator) {
        List<ObjectView> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView findByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<ObjectView> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView[] findByUuid_C_PrevAndNext(long objectViewId, String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        uuid = Objects.toString(uuid, "");
        ObjectView objectView = this.findByPrimaryKey(objectViewId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectView[] array = new ObjectViewImpl[]{this.getByUuid_C_PrevAndNext(session, objectView, uuid, companyId, orderByComparator, true), objectView, this.getByUuid_C_PrevAndNext(session, objectView, uuid, companyId, orderByComparator, false)};
            ObjectView[] objectViewArray = array;
            return objectViewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectView getByUuid_C_PrevAndNext(Session session, ObjectView objectView, String uuid, long companyId, OrderByComparator<ObjectView> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectView.objectViewId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectView)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectView)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (ObjectView objectView : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)objectView);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTVIEW_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectView> findByObjectDefinitionId(long objectDefinitionId) {
        return this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null);
    }

    public List<ObjectView> findByObjectDefinitionId(long objectDefinitionId, int start, int end) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, null);
    }

    public List<ObjectView> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectView> orderByComparator) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectView> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectView> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByObjectDefinitionId;
                finderArgs = new Object[]{objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByObjectDefinitionId;
            finderArgs = new Object[]{objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectView objectView : list) {
                if (objectDefinitionId == objectView.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
            sb.append(_FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectView.objectViewId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectView findByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByObjectDefinitionId_First(objectDefinitionId, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator) {
        List<ObjectView> list = this.findByObjectDefinitionId(objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView findByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByObjectDefinitionId_Last(objectDefinitionId, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator) {
        int count = this.countByObjectDefinitionId(objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectView> list = this.findByObjectDefinitionId(objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView[] findByObjectDefinitionId_PrevAndNext(long objectViewId, long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.findByPrimaryKey(objectViewId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectView[] array = new ObjectViewImpl[]{this.getByObjectDefinitionId_PrevAndNext(session, objectView, objectDefinitionId, orderByComparator, true), objectView, this.getByObjectDefinitionId_PrevAndNext(session, objectView, objectDefinitionId, orderByComparator, false)};
            ObjectView[] objectViewArray = array;
            return objectViewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectView getByObjectDefinitionId_PrevAndNext(Session session, ObjectView objectView, long objectDefinitionId, OrderByComparator<ObjectView> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
        sb.append(_FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectView.objectViewId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectView)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectView)list.get(1);
        }
        return null;
    }

    public void removeByObjectDefinitionId(long objectDefinitionId) {
        for (ObjectView objectView : this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectView);
        }
    }

    public int countByObjectDefinitionId(long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByObjectDefinitionId;
        Object[] finderArgs = new Object[]{objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTVIEW_WHERE);
            sb.append(_FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectView> findByODI_DOV(long objectDefinitionId, boolean defaultObjectView) {
        return this.findByODI_DOV(objectDefinitionId, defaultObjectView, -1, -1, null);
    }

    public List<ObjectView> findByODI_DOV(long objectDefinitionId, boolean defaultObjectView, int start, int end) {
        return this.findByODI_DOV(objectDefinitionId, defaultObjectView, start, end, null);
    }

    public List<ObjectView> findByODI_DOV(long objectDefinitionId, boolean defaultObjectView, int start, int end, OrderByComparator<ObjectView> orderByComparator) {
        return this.findByODI_DOV(objectDefinitionId, defaultObjectView, start, end, orderByComparator, true);
    }

    public List<ObjectView> findByODI_DOV(long objectDefinitionId, boolean defaultObjectView, int start, int end, OrderByComparator<ObjectView> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByODI_DOV;
                finderArgs = new Object[]{objectDefinitionId, defaultObjectView};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByODI_DOV;
            finderArgs = new Object[]{objectDefinitionId, defaultObjectView, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ObjectView objectView : list) {
                if (objectDefinitionId == objectView.getObjectDefinitionId() && defaultObjectView == objectView.isDefaultObjectView()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
            sb.append(_FINDER_COLUMN_ODI_DOV_OBJECTDEFINITIONID_2);
            sb.append(_FINDER_COLUMN_ODI_DOV_DEFAULTOBJECTVIEW_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectView.objectViewId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(defaultObjectView);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectView findByODI_DOV_First(long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByODI_DOV_First(objectDefinitionId, defaultObjectView, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", defaultObjectView=");
        sb.append(defaultObjectView);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByODI_DOV_First(long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator) {
        List<ObjectView> list = this.findByODI_DOV(objectDefinitionId, defaultObjectView, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView findByODI_DOV_Last(long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.fetchByODI_DOV_Last(objectDefinitionId, defaultObjectView, orderByComparator);
        if (objectView != null) {
            return objectView;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", defaultObjectView=");
        sb.append(defaultObjectView);
        sb.append("}");
        throw new NoSuchObjectViewException(sb.toString());
    }

    public ObjectView fetchByODI_DOV_Last(long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator) {
        int count = this.countByODI_DOV(objectDefinitionId, defaultObjectView);
        if (count == 0) {
            return null;
        }
        List<ObjectView> list = this.findByODI_DOV(objectDefinitionId, defaultObjectView, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectView[] findByODI_DOV_PrevAndNext(long objectViewId, long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator) throws NoSuchObjectViewException {
        ObjectView objectView = this.findByPrimaryKey(objectViewId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectView[] array = new ObjectViewImpl[]{this.getByODI_DOV_PrevAndNext(session, objectView, objectDefinitionId, defaultObjectView, orderByComparator, true), objectView, this.getByODI_DOV_PrevAndNext(session, objectView, objectDefinitionId, defaultObjectView, orderByComparator, false)};
            ObjectView[] objectViewArray = array;
            return objectViewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectView getByODI_DOV_PrevAndNext(Session session, ObjectView objectView, long objectDefinitionId, boolean defaultObjectView, OrderByComparator<ObjectView> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTVIEW_WHERE);
        sb.append(_FINDER_COLUMN_ODI_DOV_OBJECTDEFINITIONID_2);
        sb.append(_FINDER_COLUMN_ODI_DOV_DEFAULTOBJECTVIEW_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectView.objectViewId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        queryPos.add(defaultObjectView);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectView)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectView)list.get(1);
        }
        return null;
    }

    public void removeByODI_DOV(long objectDefinitionId, boolean defaultObjectView) {
        for (ObjectView objectView : this.findByODI_DOV(objectDefinitionId, defaultObjectView, -1, -1, null)) {
            this.remove((BaseModel)objectView);
        }
    }

    public int countByODI_DOV(long objectDefinitionId, boolean defaultObjectView) {
        FinderPath finderPath = this._finderPathCountByODI_DOV;
        Object[] finderArgs = new Object[]{objectDefinitionId, defaultObjectView};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTVIEW_WHERE);
            sb.append(_FINDER_COLUMN_ODI_DOV_OBJECTDEFINITIONID_2);
            sb.append(_FINDER_COLUMN_ODI_DOV_DEFAULTOBJECTVIEW_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(defaultObjectView);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectViewPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(ObjectView.class);
        this.setModelImplClass(ObjectViewImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)ObjectViewTable.INSTANCE);
    }

    public void cacheResult(ObjectView objectView) {
        this.entityCache.putResult(ObjectViewImpl.class, (Serializable)Long.valueOf(objectView.getPrimaryKey()), (Serializable)objectView);
    }

    public void cacheResult(List<ObjectView> objectViews) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && objectViews.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ObjectView objectView : objectViews) {
            if (this.entityCache.getResult(ObjectViewImpl.class, (Serializable)Long.valueOf(objectView.getPrimaryKey())) != null) continue;
            this.cacheResult(objectView);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ObjectViewImpl.class);
        this.finderCache.clearCache(ObjectViewImpl.class);
    }

    public void clearCache(ObjectView objectView) {
        this.entityCache.removeResult(ObjectViewImpl.class, (BaseModel)objectView);
    }

    public void clearCache(List<ObjectView> objectViews) {
        for (ObjectView objectView : objectViews) {
            this.entityCache.removeResult(ObjectViewImpl.class, (BaseModel)objectView);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(ObjectViewImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ObjectViewImpl.class, primaryKey);
        }
    }

    public ObjectView create(long objectViewId) {
        ObjectViewImpl objectView = new ObjectViewImpl();
        objectView.setNew(true);
        objectView.setPrimaryKey(objectViewId);
        String uuid = PortalUUIDUtil.generate();
        objectView.setUuid(uuid);
        objectView.setCompanyId(CompanyThreadLocal.getCompanyId());
        return objectView;
    }

    public ObjectView remove(long objectViewId) throws NoSuchObjectViewException {
        return this.remove(Long.valueOf(objectViewId));
    }

    public ObjectView remove(Serializable primaryKey) throws NoSuchObjectViewException {
        Session session = null;
        try {
            session = this.openSession();
            ObjectView objectView = (ObjectView)session.get(ObjectViewImpl.class, primaryKey);
            if (objectView == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchObjectViewException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            ObjectView objectView2 = (ObjectView)this.remove((BaseModel)objectView);
            return objectView2;
        }
        catch (NoSuchObjectViewException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectView removeImpl(ObjectView objectView) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)objectView)) {
                objectView = (ObjectView)session.get(ObjectViewImpl.class, objectView.getPrimaryKeyObj());
            }
            if (objectView != null) {
                session.delete((Object)objectView);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (objectView != null) {
            this.clearCache(objectView);
        }
        return objectView;
    }

    public ObjectView updateImpl(ObjectView objectView) {
        boolean isNew = objectView.isNew();
        if (!(objectView instanceof ObjectViewModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)objectView.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)objectView);
                throw new IllegalArgumentException("Implement ModelWrapper in objectView proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ObjectView implementation " + String.valueOf(objectView.getClass()));
        }
        ObjectViewModelImpl objectViewModelImpl = (ObjectViewModelImpl)objectView;
        if (Validator.isNull((String)objectView.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            objectView.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && objectView.getCreateDate() == null) {
            if (serviceContext == null) {
                objectView.setCreateDate(date);
            } else {
                objectView.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!objectViewModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                objectView.setModifiedDate(date);
            } else {
                objectView.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)objectView);
            } else {
                objectView = (ObjectView)session.merge((Object)objectView);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(ObjectViewImpl.class, (BaseModel)objectViewModelImpl, false, true);
        if (isNew) {
            objectView.setNew(false);
        }
        objectView.resetOriginalValues();
        return objectView;
    }

    public ObjectView findByPrimaryKey(Serializable primaryKey) throws NoSuchObjectViewException {
        ObjectView objectView = (ObjectView)this.fetchByPrimaryKey(primaryKey);
        if (objectView == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchObjectViewException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return objectView;
    }

    public ObjectView findByPrimaryKey(long objectViewId) throws NoSuchObjectViewException {
        return this.findByPrimaryKey(Long.valueOf(objectViewId));
    }

    public ObjectView fetchByPrimaryKey(long objectViewId) {
        return (ObjectView)this.fetchByPrimaryKey(Long.valueOf(objectViewId));
    }

    public List<ObjectView> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ObjectView> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ObjectView> findAll(int start, int end, OrderByComparator<ObjectView> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ObjectView> findAll(int start, int end, OrderByComparator<ObjectView> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OBJECTVIEW);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OBJECTVIEW;
                sql = sql.concat(" ORDER BY objectView.objectViewId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ObjectView objectView : this.findAll()) {
            this.remove((BaseModel)objectView);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OBJECTVIEW);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "objectViewId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OBJECTVIEW;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ObjectViewModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathCountByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByODI_DOV = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByODI_DOV", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId", "defaultObjectView"}, true);
        this._finderPathWithoutPaginationFindByODI_DOV = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByODI_DOV", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"objectDefinitionId", "defaultObjectView"}, true);
        this._finderPathCountByODI_DOV = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByODI_DOV", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"objectDefinitionId", "defaultObjectView"}, false);
        ObjectViewUtil.setPersistence((ObjectViewPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        ObjectViewUtil.setPersistence(null);
        this.entityCache.removeCache(ObjectViewImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.object.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

