/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectFolderItem;
import com.liferay.object.model.ObjectFolderItemModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectFolderItem service. Represents a row in the &quot;ObjectFolderItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectFolderItemModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFolderItemImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFolderItemImpl
 * @generated
 */
public class ObjectFolderItemModelImpl
	extends BaseModelImpl<ObjectFolderItem> implements ObjectFolderItemModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object folder item model instance should use the <code>ObjectFolderItem</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectFolderItem";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectFolderItemId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectDefinitionId", Types.BIGINT}, {"objectFolderId", Types.BIGINT},
		{"positionX", Types.INTEGER}, {"positionY", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFolderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("positionX", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("positionY", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectFolderItem (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectFolderItemId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId LONG,objectFolderId LONG,positionX INTEGER,positionY INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectFolderItem";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectFolderItem.objectFolderItemId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectFolderItem.objectFolderItemId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFOLDERID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFOLDERITEMID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectFolderItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectFolderItemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectFolderItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectFolderItemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectFolderItem.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectFolderItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectFolderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectFolderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFolderItem, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectFolderItem)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectFolderItem, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectFolderItem, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectFolderItem)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectFolderItem, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectFolderItem, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectFolderItem, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectFolderItem, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<ObjectFolderItem, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectFolderItem::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectFolderItem::getUuid);
			attributeGetterFunctions.put(
				"objectFolderItemId", ObjectFolderItem::getObjectFolderItemId);
			attributeGetterFunctions.put(
				"companyId", ObjectFolderItem::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectFolderItem::getUserId);
			attributeGetterFunctions.put(
				"userName", ObjectFolderItem::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectFolderItem::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectFolderItem::getModifiedDate);
			attributeGetterFunctions.put(
				"objectDefinitionId", ObjectFolderItem::getObjectDefinitionId);
			attributeGetterFunctions.put(
				"objectFolderId", ObjectFolderItem::getObjectFolderId);
			attributeGetterFunctions.put(
				"positionX", ObjectFolderItem::getPositionX);
			attributeGetterFunctions.put(
				"positionY", ObjectFolderItem::getPositionY);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectFolderItem, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectFolderItem, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<ObjectFolderItem, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectFolderItem, String>)
					ObjectFolderItem::setUuid);
			attributeSetterBiConsumers.put(
				"objectFolderItemId",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setObjectFolderItemId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectFolderItem, String>)
					ObjectFolderItem::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectFolderItem, Date>)
					ObjectFolderItem::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectFolderItem, Date>)
					ObjectFolderItem::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectDefinitionId",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setObjectDefinitionId);
			attributeSetterBiConsumers.put(
				"objectFolderId",
				(BiConsumer<ObjectFolderItem, Long>)
					ObjectFolderItem::setObjectFolderId);
			attributeSetterBiConsumers.put(
				"positionX",
				(BiConsumer<ObjectFolderItem, Integer>)
					ObjectFolderItem::setPositionX);
			attributeSetterBiConsumers.put(
				"positionY",
				(BiConsumer<ObjectFolderItem, Integer>)
					ObjectFolderItem::setPositionY);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectFolderItemId() {
		return _objectFolderItemId;
	}

	@Override
	public void setObjectFolderItemId(long objectFolderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFolderItemId = objectFolderItemId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
	}

	@Override
	public long getObjectFolderId() {
		return _objectFolderId;
	}

	@Override
	public void setObjectFolderId(long objectFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFolderId = objectFolderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectFolderId"));
	}

	@Override
	public int getPositionX() {
		return _positionX;
	}

	@Override
	public void setPositionX(int positionX) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_positionX = positionX;
	}

	@Override
	public int getPositionY() {
		return _positionY;
	}

	@Override
	public void setPositionY(int positionY) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_positionY = positionY;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectFolderItem.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectFolderItem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectFolderItem toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectFolderItem>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectFolderItemImpl objectFolderItemImpl = new ObjectFolderItemImpl();

		objectFolderItemImpl.setMvccVersion(getMvccVersion());
		objectFolderItemImpl.setUuid(getUuid());
		objectFolderItemImpl.setObjectFolderItemId(getObjectFolderItemId());
		objectFolderItemImpl.setCompanyId(getCompanyId());
		objectFolderItemImpl.setUserId(getUserId());
		objectFolderItemImpl.setUserName(getUserName());
		objectFolderItemImpl.setCreateDate(getCreateDate());
		objectFolderItemImpl.setModifiedDate(getModifiedDate());
		objectFolderItemImpl.setObjectDefinitionId(getObjectDefinitionId());
		objectFolderItemImpl.setObjectFolderId(getObjectFolderId());
		objectFolderItemImpl.setPositionX(getPositionX());
		objectFolderItemImpl.setPositionY(getPositionY());

		objectFolderItemImpl.resetOriginalValues();

		return objectFolderItemImpl;
	}

	@Override
	public ObjectFolderItem cloneWithOriginalValues() {
		ObjectFolderItemImpl objectFolderItemImpl = new ObjectFolderItemImpl();

		objectFolderItemImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectFolderItemImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectFolderItemImpl.setObjectFolderItemId(
			this.<Long>getColumnOriginalValue("objectFolderItemId"));
		objectFolderItemImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectFolderItemImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectFolderItemImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectFolderItemImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectFolderItemImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectFolderItemImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectFolderItemImpl.setObjectFolderId(
			this.<Long>getColumnOriginalValue("objectFolderId"));
		objectFolderItemImpl.setPositionX(
			this.<Integer>getColumnOriginalValue("positionX"));
		objectFolderItemImpl.setPositionY(
			this.<Integer>getColumnOriginalValue("positionY"));

		return objectFolderItemImpl;
	}

	@Override
	public int compareTo(ObjectFolderItem objectFolderItem) {
		long primaryKey = objectFolderItem.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectFolderItem)) {
			return false;
		}

		ObjectFolderItem objectFolderItem = (ObjectFolderItem)object;

		long primaryKey = objectFolderItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectFolderItem> toCacheModel() {
		ObjectFolderItemCacheModel objectFolderItemCacheModel =
			new ObjectFolderItemCacheModel();

		objectFolderItemCacheModel.mvccVersion = getMvccVersion();

		objectFolderItemCacheModel.uuid = getUuid();

		String uuid = objectFolderItemCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectFolderItemCacheModel.uuid = null;
		}

		objectFolderItemCacheModel.objectFolderItemId = getObjectFolderItemId();

		objectFolderItemCacheModel.companyId = getCompanyId();

		objectFolderItemCacheModel.userId = getUserId();

		objectFolderItemCacheModel.userName = getUserName();

		String userName = objectFolderItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectFolderItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectFolderItemCacheModel.createDate = createDate.getTime();
		}
		else {
			objectFolderItemCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectFolderItemCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectFolderItemCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectFolderItemCacheModel.objectDefinitionId = getObjectDefinitionId();

		objectFolderItemCacheModel.objectFolderId = getObjectFolderId();

		objectFolderItemCacheModel.positionX = getPositionX();

		objectFolderItemCacheModel.positionY = getPositionY();

		return objectFolderItemCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectFolderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectFolderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFolderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectFolderItem)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectFolderItem>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectFolderItem.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectFolderItemId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId;
	private long _objectFolderId;
	private int _positionX;
	private int _positionY;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectFolderItem, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectFolderItem)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectFolderItemId", _objectFolderItemId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("objectFolderId", _objectFolderId);
		_columnOriginalValues.put("positionX", _positionX);
		_columnOriginalValues.put("positionY", _positionY);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectFolderItemId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectDefinitionId", 256L);

		columnBitmasks.put("objectFolderId", 512L);

		columnBitmasks.put("positionX", 1024L);

		columnBitmasks.put("positionY", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectFolderItem _escapedModel;

}