/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Formula"}, service={ObjectFieldBusinessType.class})
public class FormulaObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"output", "script"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-an-algorithm-that-derives-its-value-from-other-fields");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "formula");
    }

    public String getName() {
        return "Formula";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return SetUtil.fromArray((Object[])new String[]{"output"});
    }

    public boolean isLocalizationSupported(ObjectField objectField) {
        return false;
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectField, objectFieldSettings);
        Map<String, String> objectFieldSettingsValues = this.getObjectFieldSettingsValues(objectFieldSettings);
        String script = objectFieldSettingsValues.get("script");
        if (Validator.isNull((String)script)) {
            return;
        }
        try {
            this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new ScriptingException((Throwable)ddmExpressionException);
        }
    }
}

