/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.ArrayList;
import java.util.List;

/**
 * The extended model base implementation for the ObjectEntryFolder service. Represents a row in the &quot;ObjectEntryFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectEntryFolderImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectEntryFolderImpl
 * @see ObjectEntryFolder
 * @generated
 */
public abstract class ObjectEntryFolderBaseImpl
	extends ObjectEntryFolderModelImpl implements ObjectEntryFolder {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object entry folder model instance should use the <code>ObjectEntryFolder</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectEntryFolderLocalServiceUtil.addObjectEntryFolder(this);
		}
		else {
			ObjectEntryFolderLocalServiceUtil.updateObjectEntryFolder(this);
		}
	}

	@Override
	@SuppressWarnings("unused")
	public String buildTreePath() throws PortalException {
		List<ObjectEntryFolder> objectEntryFolders =
			new ArrayList<ObjectEntryFolder>();

		ObjectEntryFolder objectEntryFolder = this;

		while (objectEntryFolder != null) {
			objectEntryFolders.add(objectEntryFolder);

			objectEntryFolder =
				ObjectEntryFolderLocalServiceUtil.fetchObjectEntryFolder(
					objectEntryFolder.getParentObjectEntryFolderId());
		}

		StringBundler sb = new StringBundler(
			(objectEntryFolders.size() * 2) + 1);

		sb.append("/");

		for (int i = objectEntryFolders.size() - 1; i >= 0; i--) {
			objectEntryFolder = objectEntryFolders.get(i);

			sb.append(objectEntryFolder.getObjectEntryFolderId());
			sb.append("/");
		}

		return sb.toString();
	}

	@Override
	public void updateTreePath(String treePath) {
		ObjectEntryFolder objectEntryFolder = this;

		objectEntryFolder.setTreePath(treePath);

		ObjectEntryFolderLocalServiceUtil.updateObjectEntryFolder(
			objectEntryFolder);
	}

}