/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.shortcut.internal.spi.scope.finder;

import com.liferay.oauth2.provider.scope.spi.application.descriptor.ApplicationDescriptor;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandler;
import com.liferay.oauth2.provider.scope.spi.prefix.handler.PrefixHandlerFactory;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;

public class OAuth2ProviderShortcutScopeFinder
implements ApplicationDescriptor,
PrefixHandlerFactory,
ScopeFinder,
ScopeMapper {
    private static final List<String> _scopeAliasesList = Arrays.asList("analytics.read", "analytics.write");
    private final SAPEntryLocalService _sapEntryLocalService;

    public OAuth2ProviderShortcutScopeFinder(SAPEntryLocalService sapEntryLocalService) {
        this._sapEntryLocalService = sapEntryLocalService;
    }

    public PrefixHandler create(Function<String, Object> propertyAccessorFunction) {
        return PrefixHandler.PASS_THROUGH_PREFIX_HANDLER;
    }

    public String describeApplication(Locale locale) {
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)ResourceBundleUtil.getBundle((Locale)locale, OAuth2ProviderShortcutScopeFinder.class), (String)"liferay-json-web-services-analytics-name"), (String)"liferay-json-web-services-analytics-name");
    }

    public Collection<String> findScopes() {
        Long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId == null) {
            return _scopeAliasesList;
        }
        ArrayList<String> scopes = new ArrayList<String>();
        for (String scopeAlias : _scopeAliasesList) {
            String name = "OAUTH2_" + scopeAlias;
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId.longValue(), name);
            if (sapEntry == null || !sapEntry.isEnabled()) continue;
            scopes.add(scopeAlias);
        }
        return scopes;
    }

    public Set<String> map(String scope) {
        return Collections.singleton(scope);
    }
}

