/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.shortcut.internal.instance.lifecycle;

import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"applicationName=Fragment Renderer", "clientId=FragmentRenderer"}, service={PortalInstanceLifecycleListener.class})
public class FragmentRendererPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private String _applicationName = "Fragment Renderer";
    private String _clientId = "FragmentRenderer";
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(company.getCompanyId(), this._clientId);
        if (oAuth2Application != null) {
            return;
        }
        User user = this._userLocalService.getDefaultUser(company.getCompanyId());
        this._oAuth2ApplicationLocalService.addOAuth2Application(company.getCompanyId(), user.getUserId(), user.getScreenName(), (List)new ArrayList<GrantType>(){
            {
                this.add(GrantType.REFRESH_TOKEN);
                this.add(GrantType.RESOURCE_OWNER_PASSWORD);
            }
        }, user.getUserId(), this._clientId, ClientProfile.NATIVE_APPLICATION.id(), "", null, null, null, 0L, this._applicationName, null, Collections.emptyList(), builder -> builder.forApplication("liferay-json-web-services", "com.liferay.oauth2.provider.jsonws", scopeAssigner -> scopeAssigner.assignScope(new String[]{"everything.read", "everything.write"}).mapToScopeAlias(new String[]{"liferay-json-web-services.everything.read", "liferay-json-web-services.everything.write"})), new ServiceContext());
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._applicationName = GetterUtil.getString((Object)properties.get("applicationName"));
        this._clientId = GetterUtil.getString((Object)properties.get("clientId"));
    }
}

