/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationUserAgentConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.internal.configuration.BaseConfigurationFactory;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationUserAgentConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"_portalK8sConfigMapModifier.cardinality.minimum=1"}, service={})
public class OAuth2ProviderApplicationUserAgentConfigurationFactory
extends BaseConfigurationFactory {
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ProviderApplicationUserAgentConfigurationFactory.class);
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + String.valueOf(properties)));
        }
        ConfigurationFactoryUtil.executeAsCompany((CompanyLocalService)this.companyLocalService, properties, companyId -> {
            String externalReferenceCode = ConfigurationFactoryUtil.getExternalReferenceCode((Map)properties);
            OAuth2ProviderApplicationUserAgentConfiguration oAuth2ProviderApplicationUserAgentConfiguration = (OAuth2ProviderApplicationUserAgentConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderApplicationUserAgentConfiguration.class, (Map)properties);
            Company company = this.companyLocalService.getCompanyById(companyId.longValue());
            List scopeAliasesList = ListUtil.fromArray((Object[])oAuth2ProviderApplicationUserAgentConfiguration.scopes());
            this.oAuth2Application = this._addOrUpdateOAuth2Application((long)companyId, externalReferenceCode, oAuth2ProviderApplicationUserAgentConfiguration, TransformUtil.transform((Collection)this._virtualHostLocalService.getVirtualHosts(companyId.longValue()), virtualHost -> StringBundler.concat((String[])new String[]{"@protocol@", "://", virtualHost.getHostname(), "@port-with-colon@", "/o/oauth2/redirect"})), scopeAliasesList);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("OAuth 2 application " + String.valueOf(this.oAuth2Application)));
            }
            this.modifyConfigMap(company, HashMapBuilder.put((Object)(externalReferenceCode + ".oauth2.authorization.uri"), (Object)"/o/oauth2/authorize").put((Object)(externalReferenceCode + ".oauth2.home.page.uri"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.introspection.uri"), (Object)"/o/oauth2/introspect").put((Object)(externalReferenceCode + ".oauth2.jwks.uri"), (Object)"/o/oauth2/jwks").put((Object)(externalReferenceCode + ".oauth2.redirect.uris"), (Object)"/o/oauth2/redirect").put((Object)(externalReferenceCode + ".oauth2.token.uri"), (Object)"/o/oauth2/token").put((Object)(externalReferenceCode + ".oauth2.user.agent.audience"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.user.agent.client.id"), (Object)this.oAuth2Application.getClientId()).put((Object)(externalReferenceCode + ".oauth2.user.agent.scopes"), (Object)StringUtil.merge((Collection)scopeAliasesList, (String)"\n")).build(), properties);
        });
    }

    @Override
    protected Log getLog() {
        return _log;
    }

    private OAuth2Application _addOrUpdateOAuth2Application(long companyId, String externalReferenceCode, OAuth2ProviderApplicationUserAgentConfiguration oAuth2ProviderApplicationUserAgentConfiguration, List<String> redirectURIsList, List<String> scopeAliasesList) throws Exception {
        User user = this.userLocalService.getGuestUser(companyId);
        String clientId = OAuth2SecureRandomGenerator.generateClientId();
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.fetchOAuth2ApplicationByExternalReferenceCode(externalReferenceCode, companyId);
        if (oAuth2Application != null) {
            clientId = oAuth2Application.getClientId();
        }
        String homePageURL = this.getHomePageURL(oAuth2ProviderApplicationUserAgentConfiguration.homePageURL(), oAuth2ProviderApplicationUserAgentConfiguration.baseURL());
        oAuth2Application = this.oAuth2ApplicationLocalService.addOrUpdateOAuth2Application(externalReferenceCode, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.AUTHORIZATION_CODE_PKCE, GrantType.JWT_BEARER}), "none", user.getUserId(), clientId, ClientProfile.USER_AGENT_APPLICATION.id(), null, oAuth2ProviderApplicationUserAgentConfiguration.description(), Arrays.asList("token.introspection"), homePageURL, 0L, null, this.getName(oAuth2ProviderApplicationUserAgentConfiguration.name(), externalReferenceCode), oAuth2ProviderApplicationUserAgentConfiguration.privacyPolicyURL(), redirectURIsList, false, true, null, new ServiceContext());
        this.updateScopes(oAuth2Application, scopeAliasesList);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"OAuth 2 application with external reference code ", oAuth2Application.getExternalReferenceCode(), " and company ID ", oAuth2Application.getCompanyId(), " has client ID ", oAuth2Application.getClientId()}));
        }
        return oAuth2Application;
    }
}

