/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.k8s.agent.PortalK8sConfigMapModifier;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import jakarta.ws.rs.core.Application;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

public abstract class BaseConfigurationFactory {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected Collection<Application> applications;
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    protected ModuleServiceLifecycle moduleServiceLifecycle;
    protected volatile OAuth2Application oAuth2Application;
    @Reference
    protected OAuth2ApplicationLocalService oAuth2ApplicationLocalService;
    @Reference
    protected OAuth2ApplicationScopeAliasesLocalService oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    protected ScopeLocator scopeLocator;
    @Reference
    protected UserLocalService userLocalService;
    private static final Snapshot<PortalK8sConfigMapModifier> _portalK8sConfigMapModifierSnapshot = new Snapshot(BaseConfigurationFactory.class, PortalK8sConfigMapModifier.class, null, true);
    private volatile String _configMapName;
    private volatile Map<String, String> _extensionProperties;
    private volatile String _projectName;
    private volatile String _virtualInstanceId;

    @Deactivate
    protected void deactivate(Integer reason) throws PortalException {
        if (reason != 4) {
            return;
        }
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating " + String.valueOf(this.oAuth2Application)));
        }
        ConfigurationFactoryUtil.executeAsCompany((CompanyLocalService)this.companyLocalService, (Map)HashMapBuilder.put((Object)"companyId", (Object)this.oAuth2Application.getCompanyId()).build(), companyId -> {
            this.oAuth2ApplicationLocalService.deleteOAuth2Application(this.oAuth2Application);
            if (Validator.isNull((String)this._configMapName)) {
                return;
            }
            PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
            portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
                this._extensionProperties.forEach(configMapModel.data()::remove);
                Map labels = configMapModel.labels();
                labels.put("dxp.lxc.liferay.com/virtualInstanceId", this._virtualInstanceId);
                labels.put("ext.lxc.liferay.com/projectName", this._projectName);
            }, this._configMapName);
        });
    }

    protected String getHomePageURL(String homePageURL, String baseURL) {
        if (Validator.isNull((String)homePageURL)) {
            return baseURL;
        }
        return homePageURL;
    }

    protected abstract Log getLog();

    protected String getName(String name, String defaultValue) {
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        return defaultValue;
    }

    protected String getServiceAddress(Company company) {
        return "https://".concat(company.getVirtualHostname());
    }

    protected void modifyConfigMap(Company company, Map<String, String> extensionProperties, Map<String, Object> properties) {
        this._extensionProperties = extensionProperties;
        PortalK8sConfigMapModifier portalK8sConfigMapModifier = (PortalK8sConfigMapModifier)_portalK8sConfigMapModifierSnapshot.get();
        String projectName = GetterUtil.getString((Object)properties.get("ext.lxc.liferay.com.projectName"), (String)((String)properties.get("projectName")));
        String serviceIdOrProjectName = GetterUtil.getString((Object)properties.get("ext.lxc.liferay.com.serviceId"), (String)projectName);
        if (portalK8sConfigMapModifier == null || Validator.isNull((String)serviceIdOrProjectName)) {
            return;
        }
        this._configMapName = StringBundler.concat((String[])new String[]{serviceIdOrProjectName, "-", company.getWebId(), "-lxc-ext-init-metadata"});
        this._projectName = projectName;
        this._virtualInstanceId = company.getWebId();
        portalK8sConfigMapModifier.modifyConfigMap(configMapModel -> {
            Map data = configMapModel.data();
            extensionProperties.forEach(data::put);
            Map labels = configMapModel.labels();
            labels.put("dxp.lxc.liferay.com/virtualInstanceId", this._virtualInstanceId);
            labels.put("ext.lxc.liferay.com/projectId", GetterUtil.getString(properties.get("ext.lxc.liferay.com.projectId"), (String)GetterUtil.getString(properties.get("ext.lxc.liferay.com/projectId"))));
            labels.put("ext.lxc.liferay.com/projectName", this._projectName);
            labels.put("ext.lxc.liferay.com/projectUid", GetterUtil.getString(properties.get("ext.lxc.liferay.com.projectUid"), (String)GetterUtil.getString(properties.get("ext.lxc.liferay.com/projectUid"))));
            labels.put("ext.lxc.liferay.com/serviceId", GetterUtil.getString(properties.get("ext.lxc.liferay.com.serviceId"), (String)GetterUtil.getString(properties.get("ext.lxc.liferay.com/serviceId"))));
            labels.put("ext.lxc.liferay.com/serviceUid", GetterUtil.getString(properties.get("ext.lxc.liferay.com.serviceUid"), (String)GetterUtil.getString(properties.get("ext.lxc.liferay.com/serviceUid"))));
            labels.put("lxc.liferay.com/metadataType", "ext-init");
        }, this._configMapName);
    }

    protected void updateScopes(OAuth2Application oAuth2Application, List<String> scopeAliasesList) throws Exception {
        List currentScopeAliasesList;
        boolean update = true;
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this.oAuth2ApplicationScopeAliasesLocalService.fetchOAuth2ApplicationScopeAliases(oAuth2Application.getOAuth2ApplicationId(), scopeAliasesList);
        if (oAuth2ApplicationScopeAliases != null && (currentScopeAliasesList = this.oAuth2ApplicationScopeAliasesLocalService.getScopeAliasesList(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId())).containsAll(scopeAliasesList) && currentScopeAliasesList.size() == scopeAliasesList.size()) {
            update = false;
        }
        if (update) {
            this.scopeLocator.getLiferayOAuth2Scopes(oAuth2Application.getCompanyId());
            this.oAuth2ApplicationLocalService.updateScopeAliases(oAuth2Application.getUserId(), oAuth2Application.getUserName(), oAuth2Application.getOAuth2ApplicationId(), scopeAliasesList);
        }
    }
}

