/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.service.base.OAuth2AuthorizationServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@JSONWebService(mode=JSONWebServiceMode.IGNORE)
@Component(service={AopService.class})
public class OAuth2AuthorizationServiceImpl
extends OAuth2AuthorizationServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.oauth2.provider.model.OAuth2Application)")
    private ModelResourcePermission<OAuth2Application> _oAuth2ApplicationModelResourcePermission;

    public List<OAuth2Authorization> getApplicationOAuth2Authorizations(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) throws PortalException {
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), oAuth2ApplicationId, "VIEW");
        return this.oAuth2AuthorizationLocalService.getOAuth2Authorizations(oAuth2ApplicationId, start, end, orderByComparator);
    }

    public int getApplicationOAuth2AuthorizationsCount(long oAuth2ApplicationId) throws PortalException {
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), oAuth2ApplicationId, "VIEW");
        return this.oAuth2AuthorizationLocalService.getOAuth2AuthorizationsCount(oAuth2ApplicationId);
    }

    public List<OAuth2Authorization> getUserOAuth2Authorizations(int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) throws PortalException {
        User user = this.getUser();
        return this.oAuth2AuthorizationLocalService.getUserOAuth2Authorizations(user.getUserId(), start, end, orderByComparator);
    }

    public int getUserOAuth2AuthorizationsCount() throws PortalException {
        User user = this.getUser();
        return this.oAuth2AuthorizationLocalService.getUserOAuth2AuthorizationsCount(user.getUserId());
    }

    public void revokeAllOAuth2Authorizations(long oAuth2ApplicationId) throws PortalException {
        User user = this.getUser();
        List oAuth2Authorizations = this.oAuth2AuthorizationLocalService.getOAuth2Authorizations(oAuth2ApplicationId, -1, -1, null);
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            if (user.getUserId() != oAuth2Authorization.getUserId()) {
                this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), oAuth2Authorization.getOAuth2ApplicationId(), "REVOKE_TOKEN");
            }
            this.oAuth2AuthorizationLocalService.deleteOAuth2Authorization(oAuth2Authorization);
        }
    }

    public void revokeOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        OAuth2Authorization oAuth2Authorization = this.oAuth2AuthorizationLocalService.getOAuth2Authorization(oAuth2AuthorizationId);
        User user = this.getUser();
        if (user.getUserId() != oAuth2Authorization.getUserId()) {
            this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), oAuth2Authorization.getOAuth2ApplicationId(), "REVOKE_TOKEN");
        }
        this.oAuth2AuthorizationLocalService.deleteOAuth2Authorization(oAuth2AuthorizationId);
    }
}

