/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth2.provider.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the OAuth2Application service. Represents a row in the &quot;OAuth2Application&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>OAuth2ApplicationModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuth2ApplicationImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2ApplicationImpl
 * @generated
 */
@JSON(strict = true)
public class OAuth2ApplicationModelImpl
	extends BaseModelImpl<OAuth2Application> implements OAuth2ApplicationModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth2 application model instance should use the <code>OAuth2Application</code> interface instead.
	 */
	public static final String TABLE_NAME = "OAuth2Application";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"oAuth2ApplicationId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"oA2AScopeAliasesId", Types.BIGINT},
		{"allowedGrantTypes", Types.VARCHAR},
		{"clientAuthenticationMethod", Types.VARCHAR},
		{"clientCredentialUserId", Types.BIGINT},
		{"clientCredentialUserName", Types.VARCHAR},
		{"clientId", Types.VARCHAR}, {"clientProfile", Types.INTEGER},
		{"clientSecret", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"features", Types.VARCHAR}, {"homePageURL", Types.VARCHAR},
		{"iconFileEntryId", Types.BIGINT}, {"jwks", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"privacyPolicyURL", Types.VARCHAR},
		{"redirectURIs", Types.VARCHAR}, {"rememberDevice", Types.BOOLEAN},
		{"trustedApplication", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("oAuth2ApplicationId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("oA2AScopeAliasesId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("allowedGrantTypes", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientAuthenticationMethod", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientCredentialUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("clientCredentialUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("clientProfile", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("clientSecret", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("features", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("homePageURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("iconFileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("jwks", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("privacyPolicyURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("redirectURIs", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("rememberDevice", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("trustedApplication", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table OAuth2Application (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(1000) null,oAuth2ApplicationId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,oA2AScopeAliasesId LONG,allowedGrantTypes VARCHAR(128) null,clientAuthenticationMethod VARCHAR(75) null,clientCredentialUserId LONG,clientCredentialUserName VARCHAR(75) null,clientId VARCHAR(75) null,clientProfile INTEGER,clientSecret VARCHAR(75) null,description STRING null,features STRING null,homePageURL STRING null,iconFileEntryId LONG,jwks VARCHAR(3999) null,name VARCHAR(255) null,privacyPolicyURL STRING null,redirectURIs STRING null,rememberDevice BOOLEAN,trustedApplication BOOLEAN)";

	public static final String TABLE_SQL_DROP = "drop table OAuth2Application";

	public static final String ORDER_BY_JPQL =
		" ORDER BY oAuth2Application.oAuth2ApplicationId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY OAuth2Application.oAuth2ApplicationId ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY oAuth2Application.oAuth2ApplicationId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLIENTID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLIENTPROFILE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OAUTH2APPLICATIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public OAuth2ApplicationModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _oAuth2ApplicationId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setOAuth2ApplicationId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _oAuth2ApplicationId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return OAuth2Application.class;
	}

	@Override
	public String getModelClassName() {
		return OAuth2Application.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<OAuth2Application, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<OAuth2Application, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuth2Application, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((OAuth2Application)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<OAuth2Application, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<OAuth2Application, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(OAuth2Application)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<OAuth2Application, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<OAuth2Application, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<OAuth2Application, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<OAuth2Application, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<OAuth2Application, Object>>();

			attributeGetterFunctions.put("uuid", OAuth2Application::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				OAuth2Application::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"oAuth2ApplicationId",
				OAuth2Application::getOAuth2ApplicationId);
			attributeGetterFunctions.put(
				"companyId", OAuth2Application::getCompanyId);
			attributeGetterFunctions.put(
				"userId", OAuth2Application::getUserId);
			attributeGetterFunctions.put(
				"userName", OAuth2Application::getUserName);
			attributeGetterFunctions.put(
				"createDate", OAuth2Application::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", OAuth2Application::getModifiedDate);
			attributeGetterFunctions.put(
				"oAuth2ApplicationScopeAliasesId",
				OAuth2Application::getOAuth2ApplicationScopeAliasesId);
			attributeGetterFunctions.put(
				"allowedGrantTypes", OAuth2Application::getAllowedGrantTypes);
			attributeGetterFunctions.put(
				"clientAuthenticationMethod",
				OAuth2Application::getClientAuthenticationMethod);
			attributeGetterFunctions.put(
				"clientCredentialUserId",
				OAuth2Application::getClientCredentialUserId);
			attributeGetterFunctions.put(
				"clientCredentialUserName",
				OAuth2Application::getClientCredentialUserName);
			attributeGetterFunctions.put(
				"clientId", OAuth2Application::getClientId);
			attributeGetterFunctions.put(
				"clientProfile", OAuth2Application::getClientProfile);
			attributeGetterFunctions.put(
				"clientSecret", OAuth2Application::getClientSecret);
			attributeGetterFunctions.put(
				"description", OAuth2Application::getDescription);
			attributeGetterFunctions.put(
				"features", OAuth2Application::getFeatures);
			attributeGetterFunctions.put(
				"homePageURL", OAuth2Application::getHomePageURL);
			attributeGetterFunctions.put(
				"iconFileEntryId", OAuth2Application::getIconFileEntryId);
			attributeGetterFunctions.put("jwks", OAuth2Application::getJwks);
			attributeGetterFunctions.put("name", OAuth2Application::getName);
			attributeGetterFunctions.put(
				"privacyPolicyURL", OAuth2Application::getPrivacyPolicyURL);
			attributeGetterFunctions.put(
				"redirectURIs", OAuth2Application::getRedirectURIs);
			attributeGetterFunctions.put(
				"rememberDevice", OAuth2Application::getRememberDevice);
			attributeGetterFunctions.put(
				"trustedApplication", OAuth2Application::getTrustedApplication);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<OAuth2Application, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<OAuth2Application, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<OAuth2Application, ?>>();

			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"oAuth2ApplicationId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setOAuth2ApplicationId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<OAuth2Application, Date>)
					OAuth2Application::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<OAuth2Application, Date>)
					OAuth2Application::setModifiedDate);
			attributeSetterBiConsumers.put(
				"oAuth2ApplicationScopeAliasesId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setOAuth2ApplicationScopeAliasesId);
			attributeSetterBiConsumers.put(
				"allowedGrantTypes",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setAllowedGrantTypes);
			attributeSetterBiConsumers.put(
				"clientAuthenticationMethod",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setClientAuthenticationMethod);
			attributeSetterBiConsumers.put(
				"clientCredentialUserId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setClientCredentialUserId);
			attributeSetterBiConsumers.put(
				"clientCredentialUserName",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setClientCredentialUserName);
			attributeSetterBiConsumers.put(
				"clientId",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setClientId);
			attributeSetterBiConsumers.put(
				"clientProfile",
				(BiConsumer<OAuth2Application, Integer>)
					OAuth2Application::setClientProfile);
			attributeSetterBiConsumers.put(
				"clientSecret",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setClientSecret);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setDescription);
			attributeSetterBiConsumers.put(
				"features",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setFeatures);
			attributeSetterBiConsumers.put(
				"homePageURL",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setHomePageURL);
			attributeSetterBiConsumers.put(
				"iconFileEntryId",
				(BiConsumer<OAuth2Application, Long>)
					OAuth2Application::setIconFileEntryId);
			attributeSetterBiConsumers.put(
				"jwks",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setJwks);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setName);
			attributeSetterBiConsumers.put(
				"privacyPolicyURL",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setPrivacyPolicyURL);
			attributeSetterBiConsumers.put(
				"redirectURIs",
				(BiConsumer<OAuth2Application, String>)
					OAuth2Application::setRedirectURIs);
			attributeSetterBiConsumers.put(
				"rememberDevice",
				(BiConsumer<OAuth2Application, Boolean>)
					OAuth2Application::setRememberDevice);
			attributeSetterBiConsumers.put(
				"trustedApplication",
				(BiConsumer<OAuth2Application, Boolean>)
					OAuth2Application::setTrustedApplication);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getOAuth2ApplicationId() {
		return _oAuth2ApplicationId;
	}

	@Override
	public void setOAuth2ApplicationId(long oAuth2ApplicationId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_oAuth2ApplicationId = oAuth2ApplicationId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getOAuth2ApplicationScopeAliasesId() {
		return _oAuth2ApplicationScopeAliasesId;
	}

	@Override
	public void setOAuth2ApplicationScopeAliasesId(
		long oAuth2ApplicationScopeAliasesId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_oAuth2ApplicationScopeAliasesId = oAuth2ApplicationScopeAliasesId;
	}

	@JSON
	@Override
	public String getAllowedGrantTypes() {
		if (_allowedGrantTypes == null) {
			return "";
		}
		else {
			return _allowedGrantTypes;
		}
	}

	@Override
	public void setAllowedGrantTypes(String allowedGrantTypes) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_allowedGrantTypes = allowedGrantTypes;
	}

	@JSON
	@Override
	public String getClientAuthenticationMethod() {
		if (_clientAuthenticationMethod == null) {
			return "";
		}
		else {
			return _clientAuthenticationMethod;
		}
	}

	@Override
	public void setClientAuthenticationMethod(
		String clientAuthenticationMethod) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientAuthenticationMethod = clientAuthenticationMethod;
	}

	@JSON
	@Override
	public long getClientCredentialUserId() {
		return _clientCredentialUserId;
	}

	@Override
	public void setClientCredentialUserId(long clientCredentialUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientCredentialUserId = clientCredentialUserId;
	}

	@Override
	public String getClientCredentialUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(
				getClientCredentialUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setClientCredentialUserUuid(String clientCredentialUserUuid) {
	}

	@JSON
	@Override
	public String getClientCredentialUserName() {
		if (_clientCredentialUserName == null) {
			return "";
		}
		else {
			return _clientCredentialUserName;
		}
	}

	@Override
	public void setClientCredentialUserName(String clientCredentialUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientCredentialUserName = clientCredentialUserName;
	}

	@JSON
	@Override
	public String getClientId() {
		if (_clientId == null) {
			return "";
		}
		else {
			return _clientId;
		}
	}

	@Override
	public void setClientId(String clientId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientId = clientId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalClientId() {
		return getColumnOriginalValue("clientId");
	}

	@JSON
	@Override
	public int getClientProfile() {
		return _clientProfile;
	}

	@Override
	public void setClientProfile(int clientProfile) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientProfile = clientProfile;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalClientProfile() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("clientProfile"));
	}

	@JSON
	@Override
	public String getClientSecret() {
		if (_clientSecret == null) {
			return "";
		}
		else {
			return _clientSecret;
		}
	}

	@Override
	public void setClientSecret(String clientSecret) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_clientSecret = clientSecret;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getFeatures() {
		if (_features == null) {
			return "";
		}
		else {
			return _features;
		}
	}

	@Override
	public void setFeatures(String features) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_features = features;
	}

	@JSON
	@Override
	public String getHomePageURL() {
		if (_homePageURL == null) {
			return "";
		}
		else {
			return _homePageURL;
		}
	}

	@Override
	public void setHomePageURL(String homePageURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_homePageURL = homePageURL;
	}

	@JSON
	@Override
	public long getIconFileEntryId() {
		return _iconFileEntryId;
	}

	@Override
	public void setIconFileEntryId(long iconFileEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_iconFileEntryId = iconFileEntryId;
	}

	@JSON
	@Override
	public String getJwks() {
		if (_jwks == null) {
			return "";
		}
		else {
			return _jwks;
		}
	}

	@Override
	public void setJwks(String jwks) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_jwks = jwks;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getPrivacyPolicyURL() {
		if (_privacyPolicyURL == null) {
			return "";
		}
		else {
			return _privacyPolicyURL;
		}
	}

	@Override
	public void setPrivacyPolicyURL(String privacyPolicyURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_privacyPolicyURL = privacyPolicyURL;
	}

	@JSON
	@Override
	public String getRedirectURIs() {
		if (_redirectURIs == null) {
			return "";
		}
		else {
			return _redirectURIs;
		}
	}

	@Override
	public void setRedirectURIs(String redirectURIs) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_redirectURIs = redirectURIs;
	}

	@JSON
	@Override
	public boolean getRememberDevice() {
		return _rememberDevice;
	}

	@JSON
	@Override
	public boolean isRememberDevice() {
		return _rememberDevice;
	}

	@Override
	public void setRememberDevice(boolean rememberDevice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rememberDevice = rememberDevice;
	}

	@JSON
	@Override
	public boolean getTrustedApplication() {
		return _trustedApplication;
	}

	@JSON
	@Override
	public boolean isTrustedApplication() {
		return _trustedApplication;
	}

	@Override
	public void setTrustedApplication(boolean trustedApplication) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_trustedApplication = trustedApplication;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(OAuth2Application.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), OAuth2Application.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public OAuth2Application toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, OAuth2Application>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		OAuth2ApplicationImpl oAuth2ApplicationImpl =
			new OAuth2ApplicationImpl();

		oAuth2ApplicationImpl.setUuid(getUuid());
		oAuth2ApplicationImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		oAuth2ApplicationImpl.setOAuth2ApplicationId(getOAuth2ApplicationId());
		oAuth2ApplicationImpl.setCompanyId(getCompanyId());
		oAuth2ApplicationImpl.setUserId(getUserId());
		oAuth2ApplicationImpl.setUserName(getUserName());
		oAuth2ApplicationImpl.setCreateDate(getCreateDate());
		oAuth2ApplicationImpl.setModifiedDate(getModifiedDate());
		oAuth2ApplicationImpl.setOAuth2ApplicationScopeAliasesId(
			getOAuth2ApplicationScopeAliasesId());
		oAuth2ApplicationImpl.setAllowedGrantTypes(getAllowedGrantTypes());
		oAuth2ApplicationImpl.setClientAuthenticationMethod(
			getClientAuthenticationMethod());
		oAuth2ApplicationImpl.setClientCredentialUserId(
			getClientCredentialUserId());
		oAuth2ApplicationImpl.setClientCredentialUserName(
			getClientCredentialUserName());
		oAuth2ApplicationImpl.setClientId(getClientId());
		oAuth2ApplicationImpl.setClientProfile(getClientProfile());
		oAuth2ApplicationImpl.setClientSecret(getClientSecret());
		oAuth2ApplicationImpl.setDescription(getDescription());
		oAuth2ApplicationImpl.setFeatures(getFeatures());
		oAuth2ApplicationImpl.setHomePageURL(getHomePageURL());
		oAuth2ApplicationImpl.setIconFileEntryId(getIconFileEntryId());
		oAuth2ApplicationImpl.setJwks(getJwks());
		oAuth2ApplicationImpl.setName(getName());
		oAuth2ApplicationImpl.setPrivacyPolicyURL(getPrivacyPolicyURL());
		oAuth2ApplicationImpl.setRedirectURIs(getRedirectURIs());
		oAuth2ApplicationImpl.setRememberDevice(isRememberDevice());
		oAuth2ApplicationImpl.setTrustedApplication(isTrustedApplication());

		oAuth2ApplicationImpl.resetOriginalValues();

		return oAuth2ApplicationImpl;
	}

	@Override
	public OAuth2Application cloneWithOriginalValues() {
		OAuth2ApplicationImpl oAuth2ApplicationImpl =
			new OAuth2ApplicationImpl();

		oAuth2ApplicationImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		oAuth2ApplicationImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		oAuth2ApplicationImpl.setOAuth2ApplicationId(
			this.<Long>getColumnOriginalValue("oAuth2ApplicationId"));
		oAuth2ApplicationImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		oAuth2ApplicationImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		oAuth2ApplicationImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		oAuth2ApplicationImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		oAuth2ApplicationImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		oAuth2ApplicationImpl.setOAuth2ApplicationScopeAliasesId(
			this.<Long>getColumnOriginalValue("oA2AScopeAliasesId"));
		oAuth2ApplicationImpl.setAllowedGrantTypes(
			this.<String>getColumnOriginalValue("allowedGrantTypes"));
		oAuth2ApplicationImpl.setClientAuthenticationMethod(
			this.<String>getColumnOriginalValue("clientAuthenticationMethod"));
		oAuth2ApplicationImpl.setClientCredentialUserId(
			this.<Long>getColumnOriginalValue("clientCredentialUserId"));
		oAuth2ApplicationImpl.setClientCredentialUserName(
			this.<String>getColumnOriginalValue("clientCredentialUserName"));
		oAuth2ApplicationImpl.setClientId(
			this.<String>getColumnOriginalValue("clientId"));
		oAuth2ApplicationImpl.setClientProfile(
			this.<Integer>getColumnOriginalValue("clientProfile"));
		oAuth2ApplicationImpl.setClientSecret(
			this.<String>getColumnOriginalValue("clientSecret"));
		oAuth2ApplicationImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		oAuth2ApplicationImpl.setFeatures(
			this.<String>getColumnOriginalValue("features"));
		oAuth2ApplicationImpl.setHomePageURL(
			this.<String>getColumnOriginalValue("homePageURL"));
		oAuth2ApplicationImpl.setIconFileEntryId(
			this.<Long>getColumnOriginalValue("iconFileEntryId"));
		oAuth2ApplicationImpl.setJwks(
			this.<String>getColumnOriginalValue("jwks"));
		oAuth2ApplicationImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		oAuth2ApplicationImpl.setPrivacyPolicyURL(
			this.<String>getColumnOriginalValue("privacyPolicyURL"));
		oAuth2ApplicationImpl.setRedirectURIs(
			this.<String>getColumnOriginalValue("redirectURIs"));
		oAuth2ApplicationImpl.setRememberDevice(
			this.<Boolean>getColumnOriginalValue("rememberDevice"));
		oAuth2ApplicationImpl.setTrustedApplication(
			this.<Boolean>getColumnOriginalValue("trustedApplication"));

		return oAuth2ApplicationImpl;
	}

	@Override
	public int compareTo(OAuth2Application oAuth2Application) {
		long primaryKey = oAuth2Application.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof OAuth2Application)) {
			return false;
		}

		OAuth2Application oAuth2Application = (OAuth2Application)object;

		long primaryKey = oAuth2Application.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<OAuth2Application> toCacheModel() {
		OAuth2ApplicationCacheModel oAuth2ApplicationCacheModel =
			new OAuth2ApplicationCacheModel();

		oAuth2ApplicationCacheModel.uuid = getUuid();

		String uuid = oAuth2ApplicationCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			oAuth2ApplicationCacheModel.uuid = null;
		}

		oAuth2ApplicationCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			oAuth2ApplicationCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			oAuth2ApplicationCacheModel.externalReferenceCode = null;
		}

		oAuth2ApplicationCacheModel.oAuth2ApplicationId =
			getOAuth2ApplicationId();

		oAuth2ApplicationCacheModel.companyId = getCompanyId();

		oAuth2ApplicationCacheModel.userId = getUserId();

		oAuth2ApplicationCacheModel.userName = getUserName();

		String userName = oAuth2ApplicationCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			oAuth2ApplicationCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			oAuth2ApplicationCacheModel.createDate = createDate.getTime();
		}
		else {
			oAuth2ApplicationCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			oAuth2ApplicationCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			oAuth2ApplicationCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		oAuth2ApplicationCacheModel.oAuth2ApplicationScopeAliasesId =
			getOAuth2ApplicationScopeAliasesId();

		oAuth2ApplicationCacheModel.allowedGrantTypes = getAllowedGrantTypes();

		String allowedGrantTypes =
			oAuth2ApplicationCacheModel.allowedGrantTypes;

		if ((allowedGrantTypes != null) && (allowedGrantTypes.length() == 0)) {
			oAuth2ApplicationCacheModel.allowedGrantTypes = null;
		}

		oAuth2ApplicationCacheModel.clientAuthenticationMethod =
			getClientAuthenticationMethod();

		String clientAuthenticationMethod =
			oAuth2ApplicationCacheModel.clientAuthenticationMethod;

		if ((clientAuthenticationMethod != null) &&
			(clientAuthenticationMethod.length() == 0)) {

			oAuth2ApplicationCacheModel.clientAuthenticationMethod = null;
		}

		oAuth2ApplicationCacheModel.clientCredentialUserId =
			getClientCredentialUserId();

		oAuth2ApplicationCacheModel.clientCredentialUserName =
			getClientCredentialUserName();

		String clientCredentialUserName =
			oAuth2ApplicationCacheModel.clientCredentialUserName;

		if ((clientCredentialUserName != null) &&
			(clientCredentialUserName.length() == 0)) {

			oAuth2ApplicationCacheModel.clientCredentialUserName = null;
		}

		oAuth2ApplicationCacheModel.clientId = getClientId();

		String clientId = oAuth2ApplicationCacheModel.clientId;

		if ((clientId != null) && (clientId.length() == 0)) {
			oAuth2ApplicationCacheModel.clientId = null;
		}

		oAuth2ApplicationCacheModel.clientProfile = getClientProfile();

		oAuth2ApplicationCacheModel.clientSecret = getClientSecret();

		String clientSecret = oAuth2ApplicationCacheModel.clientSecret;

		if ((clientSecret != null) && (clientSecret.length() == 0)) {
			oAuth2ApplicationCacheModel.clientSecret = null;
		}

		oAuth2ApplicationCacheModel.description = getDescription();

		String description = oAuth2ApplicationCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			oAuth2ApplicationCacheModel.description = null;
		}

		oAuth2ApplicationCacheModel.features = getFeatures();

		String features = oAuth2ApplicationCacheModel.features;

		if ((features != null) && (features.length() == 0)) {
			oAuth2ApplicationCacheModel.features = null;
		}

		oAuth2ApplicationCacheModel.homePageURL = getHomePageURL();

		String homePageURL = oAuth2ApplicationCacheModel.homePageURL;

		if ((homePageURL != null) && (homePageURL.length() == 0)) {
			oAuth2ApplicationCacheModel.homePageURL = null;
		}

		oAuth2ApplicationCacheModel.iconFileEntryId = getIconFileEntryId();

		oAuth2ApplicationCacheModel.jwks = getJwks();

		String jwks = oAuth2ApplicationCacheModel.jwks;

		if ((jwks != null) && (jwks.length() == 0)) {
			oAuth2ApplicationCacheModel.jwks = null;
		}

		oAuth2ApplicationCacheModel.name = getName();

		String name = oAuth2ApplicationCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			oAuth2ApplicationCacheModel.name = null;
		}

		oAuth2ApplicationCacheModel.privacyPolicyURL = getPrivacyPolicyURL();

		String privacyPolicyURL = oAuth2ApplicationCacheModel.privacyPolicyURL;

		if ((privacyPolicyURL != null) && (privacyPolicyURL.length() == 0)) {
			oAuth2ApplicationCacheModel.privacyPolicyURL = null;
		}

		oAuth2ApplicationCacheModel.redirectURIs = getRedirectURIs();

		String redirectURIs = oAuth2ApplicationCacheModel.redirectURIs;

		if ((redirectURIs != null) && (redirectURIs.length() == 0)) {
			oAuth2ApplicationCacheModel.redirectURIs = null;
		}

		oAuth2ApplicationCacheModel.rememberDevice = isRememberDevice();

		oAuth2ApplicationCacheModel.trustedApplication = isTrustedApplication();

		return oAuth2ApplicationCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<OAuth2Application, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<OAuth2Application, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<OAuth2Application, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(OAuth2Application)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, OAuth2Application>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					OAuth2Application.class, ModelWrapper.class);

	}

	private String _uuid;
	private String _externalReferenceCode;
	private long _oAuth2ApplicationId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _oAuth2ApplicationScopeAliasesId;
	private String _allowedGrantTypes;
	private String _clientAuthenticationMethod;
	private long _clientCredentialUserId;
	private String _clientCredentialUserName;
	private String _clientId;
	private int _clientProfile;
	private String _clientSecret;
	private String _description;
	private String _features;
	private String _homePageURL;
	private long _iconFileEntryId;
	private String _jwks;
	private String _name;
	private String _privacyPolicyURL;
	private String _redirectURIs;
	private boolean _rememberDevice;
	private boolean _trustedApplication;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<OAuth2Application, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((OAuth2Application)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("oAuth2ApplicationId", _oAuth2ApplicationId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"oA2AScopeAliasesId", _oAuth2ApplicationScopeAliasesId);
		_columnOriginalValues.put("allowedGrantTypes", _allowedGrantTypes);
		_columnOriginalValues.put(
			"clientAuthenticationMethod", _clientAuthenticationMethod);
		_columnOriginalValues.put(
			"clientCredentialUserId", _clientCredentialUserId);
		_columnOriginalValues.put(
			"clientCredentialUserName", _clientCredentialUserName);
		_columnOriginalValues.put("clientId", _clientId);
		_columnOriginalValues.put("clientProfile", _clientProfile);
		_columnOriginalValues.put("clientSecret", _clientSecret);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("features", _features);
		_columnOriginalValues.put("homePageURL", _homePageURL);
		_columnOriginalValues.put("iconFileEntryId", _iconFileEntryId);
		_columnOriginalValues.put("jwks", _jwks);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("privacyPolicyURL", _privacyPolicyURL);
		_columnOriginalValues.put("redirectURIs", _redirectURIs);
		_columnOriginalValues.put("rememberDevice", _rememberDevice);
		_columnOriginalValues.put("trustedApplication", _trustedApplication);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"oA2AScopeAliasesId", "oAuth2ApplicationScopeAliasesId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("uuid_", 1L);

		columnBitmasks.put("externalReferenceCode", 2L);

		columnBitmasks.put("oAuth2ApplicationId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("oA2AScopeAliasesId", 256L);

		columnBitmasks.put("allowedGrantTypes", 512L);

		columnBitmasks.put("clientAuthenticationMethod", 1024L);

		columnBitmasks.put("clientCredentialUserId", 2048L);

		columnBitmasks.put("clientCredentialUserName", 4096L);

		columnBitmasks.put("clientId", 8192L);

		columnBitmasks.put("clientProfile", 16384L);

		columnBitmasks.put("clientSecret", 32768L);

		columnBitmasks.put("description", 65536L);

		columnBitmasks.put("features", 131072L);

		columnBitmasks.put("homePageURL", 262144L);

		columnBitmasks.put("iconFileEntryId", 524288L);

		columnBitmasks.put("jwks", 1048576L);

		columnBitmasks.put("name", 2097152L);

		columnBitmasks.put("privacyPolicyURL", 4194304L);

		columnBitmasks.put("redirectURIs", 8388608L);

		columnBitmasks.put("rememberDevice", 16777216L);

		columnBitmasks.put("trustedApplication", 33554432L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private OAuth2Application _escapedModel;

}