/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.security.permission.resource;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth2.provider.model.OAuth2Application"}, service={ModelResourcePermission.class})
public class OAuth2ApplicationModelResourcePermission
implements ModelResourcePermission<OAuth2Application> {
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference(target="(resource.name=com.liferay.oauth2.provider)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, long oAuth2ApplicationId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, oAuth2ApplicationId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, OAuth2Application.class.getName(), oAuth2ApplicationId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, OAuth2Application oAuth2Application, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, oAuth2Application, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long oAuth2ApplicationId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, OAuth2Application oAuth2Application, String actionId) throws PortalException {
        if (permissionChecker.hasOwnerPermission(oAuth2Application.getCompanyId(), OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), oAuth2Application.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(null, OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), actionId);
    }

    public String getModelName() {
        return OAuth2Application.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

