/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.configuration;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationHeadlessServerConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.internal.configuration.BaseConfigurationFactory;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationHeadlessServerConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"_portalK8sConfigMapModifier.cardinality.minimum=1"}, service={})
public class OAuth2ProviderApplicationHeadlessServerConfigurationFactory
extends BaseConfigurationFactory {
    private static final String _COMPANY_DEFAULT_USER_TOKEN = "<company.default.user>";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ProviderApplicationHeadlessServerConfigurationFactory.class);
    @Reference
    private ScopeLocator _scopeLocator;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Activate " + String.valueOf(properties)));
        }
        ConfigurationFactoryUtil.executeAsCompany((CompanyLocalService)this.companyLocalService, properties, companyId -> {
            String externalReferenceCode = ConfigurationFactoryUtil.getExternalReferenceCode((Map)properties);
            Collection scopeAliases = this._scopeLocator.getScopeAliases(companyId.longValue());
            OAuth2ProviderApplicationHeadlessServerConfiguration oAuth2ProviderApplicationHeadlessServerConfiguration = (OAuth2ProviderApplicationHeadlessServerConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderApplicationHeadlessServerConfiguration.class, (Map)properties);
            List scopeAliasesList = TransformUtil.transformToList((Object[])oAuth2ProviderApplicationHeadlessServerConfiguration.scopes(), scopeAlias -> {
                if (!scopeAliases.contains(scopeAlias)) {
                    for (String curScopeAlias : scopeAliases) {
                        if (!StringUtil.equalsIgnoreCase((String)curScopeAlias, (String)scopeAlias)) continue;
                        return curScopeAlias;
                    }
                }
                return scopeAlias;
            });
            this.oAuth2Application = this._addOrUpdateOAuth2Application((long)companyId, externalReferenceCode, oAuth2ProviderApplicationHeadlessServerConfiguration, scopeAliasesList);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("OAuth 2 application " + String.valueOf(this.oAuth2Application)));
            }
            this.modifyConfigMap(this.companyLocalService.getCompanyById(companyId.longValue()), HashMapBuilder.put((Object)(externalReferenceCode + ".oauth2.headless.server.audience"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.headless.server.client.id"), (Object)this.oAuth2Application.getClientId()).put((Object)(externalReferenceCode + ".oauth2.headless.server.client.secret"), (Object)this.oAuth2Application.getClientSecret()).put((Object)(externalReferenceCode + ".oauth2.headless.server.scopes"), (Object)StringUtil.merge((Collection)scopeAliasesList, (String)"\n")).put((Object)(externalReferenceCode + ".oauth2.authorization.uri"), (Object)"/o/oauth2/authorize").put((Object)(externalReferenceCode + ".oauth2.home.page.uri"), (Object)this.oAuth2Application.getHomePageURL()).put((Object)(externalReferenceCode + ".oauth2.introspection.uri"), (Object)"/o/oauth2/introspect").put((Object)(externalReferenceCode + ".oauth2.jwks.uri"), (Object)"/o/oauth2/jwks").put((Object)(externalReferenceCode + ".oauth2.redirect.uris"), (Object)"/o/oauth2/redirect").put((Object)(externalReferenceCode + ".oauth2.token.uri"), (Object)"/o/oauth2/token").build(), properties);
        });
    }

    @Override
    protected Log getLog() {
        return _log;
    }

    private OAuth2Application _addOrUpdateOAuth2Application(long companyId, String externalReferenceCode, OAuth2ProviderApplicationHeadlessServerConfiguration oAuth2ProviderApplicationHeadlessServerConfiguration, List<String> scopeAliasesList) throws Exception {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.fetchOAuth2ApplicationByExternalReferenceCode(externalReferenceCode, companyId);
        User user = this.userLocalService.getGuestUser(companyId);
        User serviceUser = null;
        String clientId = OAuth2SecureRandomGenerator.generateClientId();
        String clientSecret = OAuth2SecureRandomGenerator.generateClientSecret();
        if (oAuth2Application != null) {
            serviceUser = this.userLocalService.getUserById(companyId, oAuth2Application.getClientCredentialUserId());
            clientId = oAuth2Application.getClientId();
            clientSecret = oAuth2Application.getClientSecret();
        } else {
            serviceUser = this._getServiceUser(companyId, oAuth2ProviderApplicationHeadlessServerConfiguration);
        }
        String homePageURL = this.getHomePageURL(oAuth2ProviderApplicationHeadlessServerConfiguration.homePageURL(), oAuth2ProviderApplicationHeadlessServerConfiguration.baseURL());
        oAuth2Application = this.oAuth2ApplicationLocalService.addOrUpdateOAuth2Application(externalReferenceCode, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.CLIENT_CREDENTIALS, GrantType.JWT_BEARER}), "client_secret_post", serviceUser.getUserId(), clientId, ClientProfile.HEADLESS_SERVER.id(), clientSecret, oAuth2ProviderApplicationHeadlessServerConfiguration.description(), Arrays.asList("token.introspection"), homePageURL, 0L, null, this.getName(oAuth2ProviderApplicationHeadlessServerConfiguration.name(), externalReferenceCode), oAuth2ProviderApplicationHeadlessServerConfiguration.privacyPolicyURL(), Collections.emptyList(), false, true, null, new ServiceContext());
        this.updateScopes(oAuth2Application, scopeAliasesList);
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"OAuth 2 application with external reference code ", oAuth2Application.getExternalReferenceCode(), " and company ID ", oAuth2Application.getCompanyId(), " has client ID ", oAuth2Application.getClientId()}));
        }
        return oAuth2Application;
    }

    private User _getServiceUser(long companyId, OAuth2ProviderApplicationHeadlessServerConfiguration oAuth2ProviderApplicationHeadlessServerConfiguration) throws Exception {
        String userAccountEmailAddress = oAuth2ProviderApplicationHeadlessServerConfiguration.userAccountEmailAddress();
        String userAccountScreenName = oAuth2ProviderApplicationHeadlessServerConfiguration.userAccountScreenName();
        if (!Objects.equals(_COMPANY_DEFAULT_USER_TOKEN, userAccountEmailAddress) && Objects.equals(_COMPANY_DEFAULT_USER_TOKEN, userAccountScreenName)) {
            if (!Validator.isEmailAddress((String)userAccountEmailAddress)) {
                throw new IllegalArgumentException("User account email address is not an email address");
            }
            return this.userLocalService.getUserByEmailAddress(companyId, userAccountEmailAddress);
        }
        if (Validator.isNull((String)userAccountScreenName)) {
            throw new IllegalArgumentException("User account screen name is null");
        }
        if (Objects.equals(_COMPANY_DEFAULT_USER_TOKEN, userAccountScreenName)) {
            return this.userLocalService.getUserByScreenName(companyId, "default-service-account");
        }
        return this.userLocalService.getUserByScreenName(companyId, userAccountScreenName);
    }
}

