/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.exception.DuplicateOAuth2ApplicationExternalReferenceCodeException;
import com.liferay.oauth2.provider.exception.NoSuchOAuth2ApplicationException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationTable;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationModelImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2ApplicationPersistence;
import com.liferay.oauth2.provider.service.persistence.OAuth2ApplicationUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuth2ApplicationPersistence.class})
public class OAuth2ApplicationPersistenceImpl
extends BasePersistenceImpl<OAuth2Application>
implements OAuth2ApplicationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuth2ApplicationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "oAuth2Application.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(oAuth2Application.uuid IS NULL OR oAuth2Application.uuid = '')";
    private static final String _FINDER_COLUMN_UUID_UUID_2_SQL = "oAuth2Application.uuid_ = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3_SQL = "(oAuth2Application.uuid_ IS NULL OR oAuth2Application.uuid_ = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "oAuth2Application.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(oAuth2Application.uuid IS NULL OR oAuth2Application.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2_SQL = "oAuth2Application.uuid_ = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3_SQL = "(oAuth2Application.uuid_ IS NULL OR oAuth2Application.uuid_ = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "oAuth2Application.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "oAuth2Application.companyId = ?";
    private FinderPath _finderPathFetchByC_C;
    private static final String _FINDER_COLUMN_C_C_COMPANYID_2 = "oAuth2Application.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLIENTID_2 = "oAuth2Application.clientId = ?";
    private static final String _FINDER_COLUMN_C_C_CLIENTID_3 = "(oAuth2Application.clientId IS NULL OR oAuth2Application.clientId = '')";
    private FinderPath _finderPathWithPaginationFindByC_CP;
    private FinderPath _finderPathWithoutPaginationFindByC_CP;
    private FinderPath _finderPathCountByC_CP;
    private static final String _FINDER_COLUMN_C_CP_COMPANYID_2 = "oAuth2Application.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_CP_CLIENTPROFILE_2 = "oAuth2Application.clientProfile = ?";
    private FinderPath _finderPathFetchByERC_C;
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2 = "oAuth2Application.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3 = "(oAuth2Application.externalReferenceCode IS NULL OR oAuth2Application.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_C_COMPANYID_2 = "oAuth2Application.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OAUTH2APPLICATION = "SELECT oAuth2Application FROM OAuth2Application oAuth2Application";
    private static final String _SQL_SELECT_OAUTH2APPLICATION_WHERE = "SELECT oAuth2Application FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _SQL_COUNT_OAUTH2APPLICATION = "SELECT COUNT(oAuth2Application) FROM OAuth2Application oAuth2Application";
    private static final String _SQL_COUNT_OAUTH2APPLICATION_WHERE = "SELECT COUNT(oAuth2Application) FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "oAuth2Application.oAuth2ApplicationId";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE = "SELECT DISTINCT {oAuth2Application.*} FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {OAuth2Application.*} FROM (SELECT DISTINCT oAuth2Application.oAuth2ApplicationId FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN OAuth2Application ON TEMP_TABLE.oAuth2ApplicationId = OAuth2Application.oAuth2ApplicationId";
    private static final String _FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE = "SELECT COUNT(DISTINCT oAuth2Application.oAuth2ApplicationId) AS COUNT_VALUE FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "oAuth2Application";
    private static final String _FILTER_ENTITY_TABLE = "OAuth2Application";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuth2Application.";
    private static final String _ORDER_BY_ENTITY_TABLE = "OAuth2Application.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuth2Application exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuth2Application exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ApplicationPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "oAuth2ApplicationScopeAliasesId"});

    public List<OAuth2Application> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<OAuth2Application> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<OAuth2Application> findByUuid(String uuid, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findByUuid(String uuid, int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuth2Application oAuth2Application : list) {
                if (uuid.equals(oAuth2Application.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Application findByUuid_First(String uuid, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByUuid_First(uuid, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByUuid_First(String uuid, OrderByComparator<OAuth2Application> orderByComparator) {
        List<OAuth2Application> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application findByUuid_Last(String uuid, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByUuid_Last(uuid, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByUuid_Last(String uuid, OrderByComparator<OAuth2Application> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<OAuth2Application> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application[] findByUuid_PrevAndNext(long oAuth2ApplicationId, String uuid, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        uuid = Objects.toString(uuid, "");
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.getByUuid_PrevAndNext(session, oAuth2Application, uuid, orderByComparator, true), oAuth2Application, this.getByUuid_PrevAndNext(session, oAuth2Application, uuid, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application getByUuid_PrevAndNext(Session session, OAuth2Application oAuth2Application, String uuid, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public List<OAuth2Application> filterFindByUuid(String uuid) {
        return this.filterFindByUuid(uuid, -1, -1, null);
    }

    public List<OAuth2Application> filterFindByUuid(String uuid, int start, int end) {
        return this.filterFindByUuid(uuid, start, end, null);
    }

    public List<OAuth2Application> filterFindByUuid(String uuid, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUuid(uuid, start, end, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindUuid) {
                queryPos.add(uuid);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application[] filterFindByUuid_PrevAndNext(long oAuth2ApplicationId, String uuid, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUuid_PrevAndNext(oAuth2ApplicationId, uuid, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.filterGetByUuid_PrevAndNext(session, oAuth2Application, uuid, orderByComparator, true), oAuth2Application, this.filterGetByUuid_PrevAndNext(session, oAuth2Application, uuid, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application filterGetByUuid_PrevAndNext(Session session, OAuth2Application oAuth2Application, String uuid, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (OAuth2Application oAuth2Application : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByUuid(String uuid) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByUuid(uuid);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2_SQL);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindUuid) {
                queryPos.add(uuid);
            }
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<OAuth2Application> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<OAuth2Application> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<OAuth2Application> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuth2Application oAuth2Application : list) {
                if (uuid.equals(oAuth2Application.getUuid()) && companyId == oAuth2Application.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("oAuth2Application.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Application findByUuid_C_First(String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        List<OAuth2Application> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application findByUuid_C_Last(String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Application> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application[] findByUuid_C_PrevAndNext(long oAuth2ApplicationId, String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        uuid = Objects.toString(uuid, "");
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.getByUuid_C_PrevAndNext(session, oAuth2Application, uuid, companyId, orderByComparator, true), oAuth2Application, this.getByUuid_C_PrevAndNext(session, oAuth2Application, uuid, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application getByUuid_C_PrevAndNext(Session session, OAuth2Application oAuth2Application, String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("oAuth2Application.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public List<OAuth2Application> filterFindByUuid_C(String uuid, long companyId) {
        return this.filterFindByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<OAuth2Application> filterFindByUuid_C(String uuid, long companyId, int start, int end) {
        return this.filterFindByUuid_C(uuid, companyId, start, end, null);
    }

    public List<OAuth2Application> filterFindByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByUuid_C(uuid, companyId, start, end, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        sb.append("oAuth2Application.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindUuid) {
                queryPos.add(uuid);
            }
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application[] filterFindByUuid_C_PrevAndNext(long oAuth2ApplicationId, String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByUuid_C_PrevAndNext(oAuth2ApplicationId, uuid, companyId, orderByComparator);
        }
        uuid = Objects.toString(uuid, "");
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.filterGetByUuid_C_PrevAndNext(session, oAuth2Application, uuid, companyId, orderByComparator, true), oAuth2Application, this.filterGetByUuid_C_PrevAndNext(session, oAuth2Application, uuid, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application filterGetByUuid_C_PrevAndNext(Session session, OAuth2Application oAuth2Application, String uuid, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        sb.append("oAuth2Application.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (OAuth2Application oAuth2Application : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("oAuth2Application.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByUuid_C(String uuid, long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByUuid_C(uuid, companyId);
        }
        uuid = Objects.toString(uuid, "");
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3_SQL);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2_SQL);
        }
        sb.append("oAuth2Application.companyId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            if (bindUuid) {
                queryPos.add(uuid);
            }
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<OAuth2Application> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<OAuth2Application> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<OAuth2Application> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuth2Application oAuth2Application : list) {
                if (companyId == oAuth2Application.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            sb.append("oAuth2Application.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Application findByCompanyId_First(long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByCompanyId_First(long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        List<OAuth2Application> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application findByCompanyId_Last(long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByCompanyId_Last(long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Application> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application[] findByCompanyId_PrevAndNext(long oAuth2ApplicationId, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.getByCompanyId_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, true), oAuth2Application, this.getByCompanyId_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application getByCompanyId_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        sb.append("oAuth2Application.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public List<OAuth2Application> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<OAuth2Application> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<OAuth2Application> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuth2Application.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application[] filterFindByCompanyId_PrevAndNext(long oAuth2ApplicationId, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(oAuth2ApplicationId, companyId, orderByComparator);
        }
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.filterGetByCompanyId_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, true), oAuth2Application, this.filterGetByCompanyId_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application filterGetByCompanyId_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuth2Application.companyId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (OAuth2Application oAuth2Application : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            sb.append("oAuth2Application.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE);
        sb.append("oAuth2Application.companyId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application findByC_C(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_C(companyId, clientId);
        if (oAuth2Application == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", clientId=");
            sb.append(clientId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOAuth2ApplicationException(sb.toString());
        }
        return oAuth2Application;
    }

    public OAuth2Application fetchByC_C(long companyId, String clientId) {
        return this.fetchByC_C(companyId, clientId, true);
    }

    public OAuth2Application fetchByC_C(long companyId, String clientId, boolean useFinderCache) {
        OAuth2Application oAuth2Application;
        clientId = Objects.toString(clientId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, clientId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof OAuth2Application && (companyId != (oAuth2Application = (OAuth2Application)result).getCompanyId() || !Objects.equals(clientId, oAuth2Application.getClientId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            sb.append("oAuth2Application.companyId = ? AND ");
            boolean bindClientId = false;
            if (clientId.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_3);
            } else {
                bindClientId = true;
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindClientId) {
                    queryPos.add(clientId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, clientId};
                            }
                            _log.warn((Object)("OAuth2ApplicationPersistenceImpl.fetchByC_C(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    OAuth2Application oAuth2Application2 = (OAuth2Application)list.get(0);
                    result = oAuth2Application2;
                    this.cacheResult(oAuth2Application2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuth2Application)result;
    }

    public OAuth2Application removeByC_C(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByC_C(companyId, clientId);
        return (OAuth2Application)this.remove((BaseModel)oAuth2Application);
    }

    public int countByC_C(long companyId, String clientId) {
        OAuth2Application oAuth2Application = this.fetchByC_C(companyId, clientId);
        if (oAuth2Application == null) {
            return 0;
        }
        return 1;
    }

    public List<OAuth2Application> findByC_CP(long companyId, int clientProfile) {
        return this.findByC_CP(companyId, clientProfile, -1, -1, null);
    }

    public List<OAuth2Application> findByC_CP(long companyId, int clientProfile, int start, int end) {
        return this.findByC_CP(companyId, clientProfile, start, end, null);
    }

    public List<OAuth2Application> findByC_CP(long companyId, int clientProfile, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findByC_CP(companyId, clientProfile, start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findByC_CP(long companyId, int clientProfile, int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_CP;
                finderArgs = new Object[]{companyId, clientProfile};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_CP;
            finderArgs = new Object[]{companyId, clientProfile, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuth2Application oAuth2Application : list) {
                if (companyId == oAuth2Application.getCompanyId() && clientProfile == oAuth2Application.getClientProfile()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            sb.append("oAuth2Application.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(clientProfile);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Application findByC_CP_First(long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_CP_First(companyId, clientProfile, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", clientProfile=");
        sb.append(clientProfile);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByC_CP_First(long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) {
        List<OAuth2Application> list = this.findByC_CP(companyId, clientProfile, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application findByC_CP_Last(long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_CP_Last(companyId, clientProfile, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", clientProfile=");
        sb.append(clientProfile);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByC_CP_Last(long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) {
        int count = this.countByC_CP(companyId, clientProfile);
        if (count == 0) {
            return null;
        }
        List<OAuth2Application> list = this.findByC_CP(companyId, clientProfile, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application[] findByC_CP_PrevAndNext(long oAuth2ApplicationId, long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.getByC_CP_PrevAndNext(session, oAuth2Application, companyId, clientProfile, orderByComparator, true), oAuth2Application, this.getByC_CP_PrevAndNext(session, oAuth2Application, companyId, clientProfile, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application getByC_CP_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        sb.append("oAuth2Application.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(clientProfile);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public List<OAuth2Application> filterFindByC_CP(long companyId, int clientProfile) {
        return this.filterFindByC_CP(companyId, clientProfile, -1, -1, null);
    }

    public List<OAuth2Application> filterFindByC_CP(long companyId, int clientProfile, int start, int end) {
        return this.filterFindByC_CP(companyId, clientProfile, start, end, null);
    }

    public List<OAuth2Application> filterFindByC_CP(long companyId, int clientProfile, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_CP(companyId, clientProfile, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuth2Application.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(clientProfile);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application[] filterFindByC_CP_PrevAndNext(long oAuth2ApplicationId, long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_CP_PrevAndNext(oAuth2ApplicationId, companyId, clientProfile, orderByComparator);
        }
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.filterGetByC_CP_PrevAndNext(session, oAuth2Application, companyId, clientProfile, orderByComparator, true), oAuth2Application, this.filterGetByC_CP_PrevAndNext(session, oAuth2Application, companyId, clientProfile, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application filterGetByC_CP_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, int clientProfile, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuth2Application.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        queryPos.add(clientProfile);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public void removeByC_CP(long companyId, int clientProfile) {
        for (OAuth2Application oAuth2Application : this.findByC_CP(companyId, clientProfile, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countByC_CP(long companyId, int clientProfile) {
        FinderPath finderPath = this._finderPathCountByC_CP;
        Object[] finderArgs = new Object[]{companyId, clientProfile};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            sb.append("oAuth2Application.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(clientProfile);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC_CP(long companyId, int clientProfile) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC_CP(companyId, clientProfile);
        }
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE);
        sb.append("oAuth2Application.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_CP_CLIENTPROFILE_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(clientProfile);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application findByERC_C(String externalReferenceCode, long companyId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByERC_C(externalReferenceCode, companyId);
        if (oAuth2Application == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOAuth2ApplicationException(sb.toString());
        }
        return oAuth2Application;
    }

    public OAuth2Application fetchByERC_C(String externalReferenceCode, long companyId) {
        return this.fetchByERC_C(externalReferenceCode, companyId, true);
    }

    public OAuth2Application fetchByERC_C(String externalReferenceCode, long companyId, boolean useFinderCache) {
        OAuth2Application oAuth2Application;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof OAuth2Application && (!Objects.equals(externalReferenceCode, (oAuth2Application = (OAuth2Application)result).getExternalReferenceCode()) || companyId != oAuth2Application.getCompanyId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2);
            }
            sb.append("oAuth2Application.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_C, finderArgs, (Object)list);
                    }
                } else {
                    OAuth2Application oAuth2Application2 = (OAuth2Application)list.get(0);
                    result = oAuth2Application2;
                    this.cacheResult(oAuth2Application2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuth2Application)result;
    }

    public OAuth2Application removeByERC_C(String externalReferenceCode, long companyId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByERC_C(externalReferenceCode, companyId);
        return (OAuth2Application)this.remove((BaseModel)oAuth2Application);
    }

    public int countByERC_C(String externalReferenceCode, long companyId) {
        OAuth2Application oAuth2Application = this.fetchByERC_C(externalReferenceCode, companyId);
        if (oAuth2Application == null) {
            return 0;
        }
        return 1;
    }

    public OAuth2ApplicationPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("oAuth2ApplicationScopeAliasesId", "oA2AScopeAliasesId");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(OAuth2Application.class);
        this.setModelImplClass(OAuth2ApplicationImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)OAuth2ApplicationTable.INSTANCE);
    }

    public void cacheResult(OAuth2Application oAuth2Application) {
        this.entityCache.putResult(OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey()), (Serializable)oAuth2Application);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{oAuth2Application.getCompanyId(), oAuth2Application.getClientId()}, (Object)oAuth2Application);
        this.finderCache.putResult(this._finderPathFetchByERC_C, new Object[]{oAuth2Application.getExternalReferenceCode(), oAuth2Application.getCompanyId()}, (Object)oAuth2Application);
    }

    public void cacheResult(List<OAuth2Application> oAuth2Applications) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuth2Applications.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuth2Application oAuth2Application : oAuth2Applications) {
            if (this.entityCache.getResult(OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey())) != null) continue;
            this.cacheResult(oAuth2Application);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuth2ApplicationImpl.class);
        this.finderCache.clearCache(OAuth2ApplicationImpl.class);
    }

    public void clearCache(OAuth2Application oAuth2Application) {
        this.entityCache.removeResult(OAuth2ApplicationImpl.class, (BaseModel)oAuth2Application);
    }

    public void clearCache(List<OAuth2Application> oAuth2Applications) {
        for (OAuth2Application oAuth2Application : oAuth2Applications) {
            this.entityCache.removeResult(OAuth2ApplicationImpl.class, (BaseModel)oAuth2Application);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(OAuth2ApplicationImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuth2ApplicationImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl) {
        Object[] args = new Object[]{oAuth2ApplicationModelImpl.getCompanyId(), oAuth2ApplicationModelImpl.getClientId()};
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)oAuth2ApplicationModelImpl);
        args = new Object[]{oAuth2ApplicationModelImpl.getExternalReferenceCode(), oAuth2ApplicationModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathFetchByERC_C, args, (Object)oAuth2ApplicationModelImpl);
    }

    public OAuth2Application create(long oAuth2ApplicationId) {
        OAuth2ApplicationImpl oAuth2Application = new OAuth2ApplicationImpl();
        oAuth2Application.setNew(true);
        oAuth2Application.setPrimaryKey(oAuth2ApplicationId);
        String uuid = PortalUUIDUtil.generate();
        oAuth2Application.setUuid(uuid);
        oAuth2Application.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuth2Application;
    }

    public OAuth2Application remove(long oAuth2ApplicationId) throws NoSuchOAuth2ApplicationException {
        return this.remove(Long.valueOf(oAuth2ApplicationId));
    }

    public OAuth2Application remove(Serializable primaryKey) throws NoSuchOAuth2ApplicationException {
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application oAuth2Application = (OAuth2Application)session.get(OAuth2ApplicationImpl.class, primaryKey);
            if (oAuth2Application == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchOAuth2ApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            OAuth2Application oAuth2Application2 = (OAuth2Application)this.remove((BaseModel)oAuth2Application);
            return oAuth2Application2;
        }
        catch (NoSuchOAuth2ApplicationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application removeImpl(OAuth2Application oAuth2Application) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuth2Application)) {
                oAuth2Application = (OAuth2Application)session.get(OAuth2ApplicationImpl.class, oAuth2Application.getPrimaryKeyObj());
            }
            if (oAuth2Application != null) {
                session.delete((Object)oAuth2Application);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuth2Application != null) {
            this.clearCache(oAuth2Application);
        }
        return oAuth2Application;
    }

    public OAuth2Application updateImpl(OAuth2Application oAuth2Application) {
        boolean isNew = oAuth2Application.isNew();
        if (!(oAuth2Application instanceof OAuth2ApplicationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)oAuth2Application.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuth2Application);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuth2Application proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuth2Application implementation " + String.valueOf(oAuth2Application.getClass()));
        }
        OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl = (OAuth2ApplicationModelImpl)oAuth2Application;
        if (Validator.isNull((String)oAuth2Application.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            oAuth2Application.setUuid(uuid);
        }
        if (Validator.isNull((String)oAuth2Application.getExternalReferenceCode())) {
            oAuth2Application.setExternalReferenceCode(oAuth2Application.getUuid());
        } else {
            long userId;
            if (!Objects.equals(oAuth2ApplicationModelImpl.getColumnOriginalValue("externalReferenceCode"), oAuth2Application.getExternalReferenceCode()) && (userId = GetterUtil.getLong((String)PrincipalThreadLocal.getName())) > 0L) {
                long companyId = oAuth2Application.getCompanyId();
                long groupId = 0L;
                long classPK = 0L;
                if (!isNew) {
                    classPK = oAuth2Application.getPrimaryKey();
                }
                try {
                    oAuth2Application.setExternalReferenceCode(SanitizerUtil.sanitize((long)companyId, (long)groupId, (long)userId, (String)OAuth2Application.class.getName(), (long)classPK, (String)"text/html", (String)"ALL", (String)oAuth2Application.getExternalReferenceCode(), null));
                }
                catch (SanitizerException sanitizerException) {
                    throw new SystemException((Throwable)sanitizerException);
                }
            }
            OAuth2Application ercOAuth2Application = this.fetchByERC_C(oAuth2Application.getExternalReferenceCode(), oAuth2Application.getCompanyId());
            if (isNew ? ercOAuth2Application != null : ercOAuth2Application != null && oAuth2Application.getOAuth2ApplicationId() != ercOAuth2Application.getOAuth2ApplicationId()) {
                throw new DuplicateOAuth2ApplicationExternalReferenceCodeException("Duplicate o auth2 application with external reference code " + oAuth2Application.getExternalReferenceCode() + " and company " + oAuth2Application.getCompanyId());
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && oAuth2Application.getCreateDate() == null) {
            if (serviceContext == null) {
                oAuth2Application.setCreateDate(date);
            } else {
                oAuth2Application.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!oAuth2ApplicationModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                oAuth2Application.setModifiedDate(date);
            } else {
                oAuth2Application.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuth2Application);
            } else {
                oAuth2Application = (OAuth2Application)session.merge((Object)oAuth2Application);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(OAuth2ApplicationImpl.class, (BaseModel)oAuth2ApplicationModelImpl, false, true);
        this.cacheUniqueFindersCache(oAuth2ApplicationModelImpl);
        if (isNew) {
            oAuth2Application.setNew(false);
        }
        oAuth2Application.resetOriginalValues();
        return oAuth2Application;
    }

    public OAuth2Application findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = (OAuth2Application)this.fetchByPrimaryKey(primaryKey);
        if (oAuth2Application == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchOAuth2ApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return oAuth2Application;
    }

    public OAuth2Application findByPrimaryKey(long oAuth2ApplicationId) throws NoSuchOAuth2ApplicationException {
        return this.findByPrimaryKey(Long.valueOf(oAuth2ApplicationId));
    }

    public OAuth2Application fetchByPrimaryKey(long oAuth2ApplicationId) {
        return (OAuth2Application)this.fetchByPrimaryKey(Long.valueOf(oAuth2ApplicationId));
    }

    public List<OAuth2Application> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuth2Application> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuth2Application> findAll(int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findAll(int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTH2APPLICATION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTH2APPLICATION;
                sql = sql.concat(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuth2Application oAuth2Application : this.findAll()) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTH2APPLICATION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuth2ApplicationId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTH2APPLICATION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuth2ApplicationModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "clientId"}, true);
        this._finderPathWithPaginationFindByC_CP = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_CP", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "clientProfile"}, true);
        this._finderPathWithoutPaginationFindByC_CP = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_CP", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "clientProfile"}, true);
        this._finderPathCountByC_CP = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_CP", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "clientProfile"}, false);
        this._finderPathFetchByERC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId"}, true);
        OAuth2ApplicationUtil.setPersistence((OAuth2ApplicationPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        OAuth2ApplicationUtil.setPersistence(null);
        this.entityCache.removeCache(OAuth2ApplicationImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

