/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.scheduler;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration"}, service={SchedulerJobConfiguration.class})
public class OAuth2AuthorizationSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private OAuth2AuthorizationLocalService _oAuth2AuthorizationLocalService;
    private TriggerConfiguration _triggerConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> ((OAuth2AuthorizationLocalService)this._oAuth2AuthorizationLocalService).deleteExpiredOAuth2Authorizations();
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        OAuth2ProviderConfiguration oAuth2ProviderConfiguration = (OAuth2ProviderConfiguration)ConfigurableUtil.createConfigurable(OAuth2ProviderConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)oAuth2ProviderConfiguration.expiredAuthorizationsCheckInterval(), (TimeUnit)TimeUnit.MINUTE);
    }
}

