/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.upgrade.v2_0_0;

import com.liferay.oauth2.provider.scope.liferay.LiferayOAuth2Scope;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UpgradeOAuth2ApplicationScopeAliases
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ScopeLocator _scopeLocator;

    public UpgradeOAuth2ApplicationScopeAliases(CompanyLocalService companyLocalService, ScopeLocator scopeLocator) {
        this._companyLocalService = companyLocalService;
        this._scopeLocator = scopeLocator;
    }

    protected void doUpgrade() throws Exception {
        for (Company company : this._companyLocalService.getCompanies()) {
            this.upgradeCompany(company.getCompanyId());
        }
    }

    protected void upgradeCompany(long companyId) throws Exception {
        HashMap<LiferayOAuth2Scope, Set<String>> liferayOAuth2ScopeScopeAliases = new HashMap<LiferayOAuth2Scope, Set<String>>();
        ArrayList scopeAliases = new ArrayList(this._scopeLocator.getScopeAliases(companyId));
        for (String scopeAlias : scopeAliases) {
            for (LiferayOAuth2Scope liferayOAuth2Scope : this._scopeLocator.getLiferayOAuth2Scopes(companyId, scopeAlias)) {
                Set set = liferayOAuth2ScopeScopeAliases.computeIfAbsent(liferayOAuth2Scope, x -> new HashSet());
                set.add(scopeAlias);
            }
        }
        try (LoggingTimer loggingTimer = new LoggingTimer();
             ResultSet applicationScopeAliasesResultSet = this._getApplicationScopeAliases(companyId);){
            while (applicationScopeAliasesResultSet.next()) {
                String scopeAliasesString = applicationScopeAliasesResultSet.getString("scopeAliases");
                if (Validator.isNull((String)scopeAliasesString)) continue;
                long oAuth2ApplicationScopeAliasesId = applicationScopeAliasesResultSet.getLong("oA2AScopeAliasesId");
                Set assignedScopeAliases = SetUtil.fromArray((Object[])StringUtil.split((String)scopeAliasesString, (String)" "));
                this._upgradeOAuth2ScopeGrants(oAuth2ApplicationScopeAliasesId, companyId, liferayOAuth2ScopeScopeAliases, assignedScopeAliases);
            }
        }
    }

    private ResultSet _getApplicationScopeAliases(long companyId) throws SQLException {
        String sql = StringBundler.concat((String[])new String[]{"select oa2asa.oA2AScopeAliasesId, oa2asa.scopeAliases from ", "OAuth2Application oa2a inner join OAuth2ApplicationScopeAliases ", "oa2asa on oa2a.oA2AScopeAliasesId = oa2asa.oA2AScopeAliasesId ", "where oa2a.companyId = ?"});
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setLong(1, companyId);
        return preparedStatement.executeQuery();
    }

    private ResultSet _getOAuth2ScopeGrantResultSet(long oAuth2ApplicationScopeAliasesId) throws SQLException {
        String sql = "select * from OAuth2ScopeGrant where oA2AScopeAliasesId = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setLong(1, oAuth2ApplicationScopeAliasesId);
        return preparedStatement.executeQuery();
    }

    private void _updateOAuth2ScopeGrant(long oAuth2ScopeGrantId, Set<String> scopeAliases) throws SQLException {
        String sql = "update OAuth2ScopeGrant set scopeAliases = ? where oAuth2ScopeGrantId = ?";
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, StringUtil.merge((Collection)ListUtil.sort(new ArrayList<String>(scopeAliases)), (String)" "));
            preparedStatement.setLong(2, oAuth2ScopeGrantId);
            preparedStatement.execute();
        }
    }

    private void _upgradeOAuth2ScopeGrants(long oAuth2ApplicationScopeAliasesId, long companyId, Map<LiferayOAuth2Scope, Set<String>> liferayOAuth2ScopesScopeAliases, Set<String> assignedScopeAliases) throws SQLException {
        try (ResultSet resultSet = this._getOAuth2ScopeGrantResultSet(oAuth2ApplicationScopeAliasesId);){
            while (resultSet.next()) {
                String scope;
                long oAuth2ScopeGrantId = resultSet.getLong("oAuth2ScopeGrantId");
                String applicationName = resultSet.getString("applicationName");
                LiferayOAuth2Scope liferayOAuth2Scope = this._scopeLocator.getLiferayOAuth2Scope(companyId, applicationName, scope = resultSet.getString("scope"));
                if (liferayOAuth2Scope == null) {
                    this._updateOAuth2ScopeGrant(oAuth2ScopeGrantId, Collections.singleton("legacy"));
                    continue;
                }
                Set<String> availableScopeAliases = liferayOAuth2ScopesScopeAliases.get(liferayOAuth2Scope);
                HashSet<String> assignedAvailableScopeAliases = new HashSet<String>(assignedScopeAliases);
                assignedAvailableScopeAliases.retainAll(availableScopeAliases);
                if (assignedAvailableScopeAliases.isEmpty()) {
                    this._updateOAuth2ScopeGrant(oAuth2ScopeGrantId, Collections.singleton("legacy"));
                    continue;
                }
                this._updateOAuth2ScopeGrant(oAuth2ScopeGrantId, assignedAvailableScopeAliases);
            }
        }
    }
}

