/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2AuthorizationException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationModelImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2AuthorizationPersistence;
import com.liferay.oauth2.provider.service.persistence.OAuth2AuthorizationUtil;
import com.liferay.oauth2.provider.service.persistence.OAuth2ScopeGrantPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OAuth2AuthorizationPersistenceImpl
extends BasePersistenceImpl<OAuth2Authorization>
implements OAuth2AuthorizationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuth2AuthorizationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "oAuth2Authorization.userId = ?";
    private FinderPath _finderPathWithPaginationFindByOAuth2ApplicationId;
    private FinderPath _finderPathWithoutPaginationFindByOAuth2ApplicationId;
    private FinderPath _finderPathCountByOAuth2ApplicationId;
    private static final String _FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2 = "oAuth2Authorization.oAuth2ApplicationId = ?";
    private FinderPath _finderPathWithPaginationFindByAccessTokenContentHash;
    private FinderPath _finderPathWithoutPaginationFindByAccessTokenContentHash;
    private FinderPath _finderPathCountByAccessTokenContentHash;
    private static final String _FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2 = "oAuth2Authorization.accessTokenContentHash = ?";
    private FinderPath _finderPathWithPaginationFindByRefreshTokenContentHash;
    private FinderPath _finderPathWithoutPaginationFindByRefreshTokenContentHash;
    private FinderPath _finderPathCountByRefreshTokenContentHash;
    private static final String _FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2 = "oAuth2Authorization.refreshTokenContentHash = ?";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    @BeanReference(type=OAuth2ScopeGrantPersistence.class)
    protected OAuth2ScopeGrantPersistence oAuth2ScopeGrantPersistence;
    protected TableMapper<OAuth2Authorization, OAuth2ScopeGrant> oAuth2AuthorizationToOAuth2ScopeGrantTableMapper;
    private static final String _SQL_SELECT_OAUTH2AUTHORIZATION = "SELECT oAuth2Authorization FROM OAuth2Authorization oAuth2Authorization";
    private static final String _SQL_SELECT_OAUTH2AUTHORIZATION_WHERE_PKS_IN = "SELECT oAuth2Authorization FROM OAuth2Authorization oAuth2Authorization WHERE oAuth2AuthorizationId IN (";
    private static final String _SQL_SELECT_OAUTH2AUTHORIZATION_WHERE = "SELECT oAuth2Authorization FROM OAuth2Authorization oAuth2Authorization WHERE ";
    private static final String _SQL_COUNT_OAUTH2AUTHORIZATION = "SELECT COUNT(oAuth2Authorization) FROM OAuth2Authorization oAuth2Authorization";
    private static final String _SQL_COUNT_OAUTH2AUTHORIZATION_WHERE = "SELECT COUNT(oAuth2Authorization) FROM OAuth2Authorization oAuth2Authorization WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuth2Authorization.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuth2Authorization exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuth2Authorization exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2AuthorizationPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"oAuth2ApplicationScopeAliasesId"});

    public List<OAuth2Authorization> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (userId == oAuth2Authorization.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByUserId_First(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByUserId_First(userId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByUserId_First(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByUserId_Last(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByUserId_Last(userId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByUserId_Last(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByUserId_PrevAndNext(long oAuth2AuthorizationId, long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByUserId_PrevAndNext(session, oAuth2Authorization, userId, orderByComparator, true), oAuth2Authorization, this.getByUserId_PrevAndNext(session, oAuth2Authorization, userId, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByUserId_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long userId, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OAuth2Authorization oAuth2Authorization : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, -1, -1, null);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, null);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByOAuth2ApplicationId;
                finderArgs = new Object[]{oAuth2ApplicationId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByOAuth2ApplicationId;
            finderArgs = new Object[]{oAuth2ApplicationId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (oAuth2ApplicationId == oAuth2Authorization.getOAuth2ApplicationId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuth2ApplicationId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByOAuth2ApplicationId_First(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByOAuth2ApplicationId_First(oAuth2ApplicationId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuth2ApplicationId=");
        sb.append(oAuth2ApplicationId);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByOAuth2ApplicationId_First(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByOAuth2ApplicationId(oAuth2ApplicationId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByOAuth2ApplicationId_Last(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByOAuth2ApplicationId_Last(oAuth2ApplicationId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuth2ApplicationId=");
        sb.append(oAuth2ApplicationId);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByOAuth2ApplicationId_Last(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByOAuth2ApplicationId(oAuth2ApplicationId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByOAuth2ApplicationId(oAuth2ApplicationId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByOAuth2ApplicationId_PrevAndNext(long oAuth2AuthorizationId, long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByOAuth2ApplicationId_PrevAndNext(session, oAuth2Authorization, oAuth2ApplicationId, orderByComparator, true), oAuth2Authorization, this.getByOAuth2ApplicationId_PrevAndNext(session, oAuth2Authorization, oAuth2ApplicationId, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByOAuth2ApplicationId_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(oAuth2ApplicationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByOAuth2ApplicationId(long oAuth2ApplicationId) {
        for (OAuth2Authorization oAuth2Authorization : this.findByOAuth2ApplicationId(oAuth2ApplicationId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByOAuth2ApplicationId(long oAuth2ApplicationId) {
        FinderPath finderPath = this._finderPathCountByOAuth2ApplicationId;
        Object[] finderArgs = new Object[]{oAuth2ApplicationId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuth2ApplicationId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long accessTokenContentHash) {
        return this.findByAccessTokenContentHash(accessTokenContentHash, -1, -1, null);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long accessTokenContentHash, int start, int end) {
        return this.findByAccessTokenContentHash(accessTokenContentHash, start, end, null);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long accessTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByAccessTokenContentHash(accessTokenContentHash, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long accessTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByAccessTokenContentHash;
                finderArgs = new Object[]{accessTokenContentHash};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByAccessTokenContentHash;
            finderArgs = new Object[]{accessTokenContentHash, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (accessTokenContentHash == oAuth2Authorization.getAccessTokenContentHash()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accessTokenContentHash);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByAccessTokenContentHash_First(long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByAccessTokenContentHash_First(accessTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accessTokenContentHash=");
        sb.append(accessTokenContentHash);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByAccessTokenContentHash_First(long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByAccessTokenContentHash(accessTokenContentHash, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByAccessTokenContentHash_Last(long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByAccessTokenContentHash_Last(accessTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("accessTokenContentHash=");
        sb.append(accessTokenContentHash);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByAccessTokenContentHash_Last(long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByAccessTokenContentHash(accessTokenContentHash);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByAccessTokenContentHash(accessTokenContentHash, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByAccessTokenContentHash_PrevAndNext(long oAuth2AuthorizationId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByAccessTokenContentHash_PrevAndNext(session, oAuth2Authorization, accessTokenContentHash, orderByComparator, true), oAuth2Authorization, this.getByAccessTokenContentHash_PrevAndNext(session, oAuth2Authorization, accessTokenContentHash, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByAccessTokenContentHash_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        sb.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(accessTokenContentHash);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByAccessTokenContentHash(long accessTokenContentHash) {
        for (OAuth2Authorization oAuth2Authorization : this.findByAccessTokenContentHash(accessTokenContentHash, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByAccessTokenContentHash(long accessTokenContentHash) {
        FinderPath finderPath = this._finderPathCountByAccessTokenContentHash;
        Object[] finderArgs = new Object[]{accessTokenContentHash};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(accessTokenContentHash);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long refreshTokenContentHash) {
        return this.findByRefreshTokenContentHash(refreshTokenContentHash, -1, -1, null);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long refreshTokenContentHash, int start, int end) {
        return this.findByRefreshTokenContentHash(refreshTokenContentHash, start, end, null);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long refreshTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByRefreshTokenContentHash(refreshTokenContentHash, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long refreshTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByRefreshTokenContentHash;
                finderArgs = new Object[]{refreshTokenContentHash};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByRefreshTokenContentHash;
            finderArgs = new Object[]{refreshTokenContentHash, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (refreshTokenContentHash == oAuth2Authorization.getRefreshTokenContentHash()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(refreshTokenContentHash);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByRefreshTokenContentHash_First(long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByRefreshTokenContentHash_First(refreshTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("refreshTokenContentHash=");
        sb.append(refreshTokenContentHash);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByRefreshTokenContentHash_First(long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByRefreshTokenContentHash(refreshTokenContentHash, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByRefreshTokenContentHash_Last(long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByRefreshTokenContentHash_Last(refreshTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("refreshTokenContentHash=");
        sb.append(refreshTokenContentHash);
        sb.append("}");
        throw new NoSuchOAuth2AuthorizationException(sb.toString());
    }

    public OAuth2Authorization fetchByRefreshTokenContentHash_Last(long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByRefreshTokenContentHash(refreshTokenContentHash);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByRefreshTokenContentHash(refreshTokenContentHash, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByRefreshTokenContentHash_PrevAndNext(long oAuth2AuthorizationId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByRefreshTokenContentHash_PrevAndNext(session, oAuth2Authorization, refreshTokenContentHash, orderByComparator, true), oAuth2Authorization, this.getByRefreshTokenContentHash_PrevAndNext(session, oAuth2Authorization, refreshTokenContentHash, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByRefreshTokenContentHash_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        sb.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(refreshTokenContentHash);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByRefreshTokenContentHash(long refreshTokenContentHash) {
        for (OAuth2Authorization oAuth2Authorization : this.findByRefreshTokenContentHash(refreshTokenContentHash, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByRefreshTokenContentHash(long refreshTokenContentHash) {
        FinderPath finderPath = this._finderPathCountByRefreshTokenContentHash;
        Object[] finderArgs = new Object[]{refreshTokenContentHash};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            sb.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(refreshTokenContentHash);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuth2AuthorizationPersistenceImpl() {
        block2: {
            HashMap<String, String> dbColumnNames = new HashMap<String, String>();
            dbColumnNames.put("oAuth2ApplicationScopeAliasesId", "oA2AScopeAliasesId");
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        this.setModelClass(OAuth2Authorization.class);
    }

    public void cacheResult(OAuth2Authorization oAuth2Authorization) {
        this.entityCache.putResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()), (Serializable)oAuth2Authorization);
        oAuth2Authorization.resetOriginalValues();
    }

    public void cacheResult(List<OAuth2Authorization> oAuth2Authorizations) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuth2Authorizations.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            if (this.entityCache.getResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey())) == null) {
                this.cacheResult(oAuth2Authorization);
                continue;
            }
            oAuth2Authorization.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuth2AuthorizationImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OAuth2Authorization oAuth2Authorization) {
        this.entityCache.removeResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<OAuth2Authorization> oAuth2Authorizations) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            this.entityCache.removeResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, primaryKey);
        }
    }

    public OAuth2Authorization create(long oAuth2AuthorizationId) {
        OAuth2AuthorizationImpl oAuth2Authorization = new OAuth2AuthorizationImpl();
        oAuth2Authorization.setNew(true);
        oAuth2Authorization.setPrimaryKey(oAuth2AuthorizationId);
        oAuth2Authorization.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuth2Authorization;
    }

    public OAuth2Authorization remove(long oAuth2AuthorizationId) throws NoSuchOAuth2AuthorizationException {
        return this.remove(Long.valueOf(oAuth2AuthorizationId));
    }

    public OAuth2Authorization remove(Serializable primaryKey) throws NoSuchOAuth2AuthorizationException {
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)session.get(OAuth2AuthorizationImpl.class, primaryKey);
            if (oAuth2Authorization == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOAuth2AuthorizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuth2Authorization oAuth2Authorization2 = (OAuth2Authorization)this.remove((BaseModel)oAuth2Authorization);
            return oAuth2Authorization2;
        }
        catch (NoSuchOAuth2AuthorizationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization removeImpl(OAuth2Authorization oAuth2Authorization) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteLeftPrimaryKeyTableMappings(oAuth2Authorization.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuth2Authorization)) {
                oAuth2Authorization = (OAuth2Authorization)session.get(OAuth2AuthorizationImpl.class, oAuth2Authorization.getPrimaryKeyObj());
            }
            if (oAuth2Authorization != null) {
                session.delete((Object)oAuth2Authorization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuth2Authorization != null) {
            this.clearCache(oAuth2Authorization);
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization updateImpl(OAuth2Authorization oAuth2Authorization) {
        Object[] args;
        boolean isNew = oAuth2Authorization.isNew();
        if (!(oAuth2Authorization instanceof OAuth2AuthorizationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuth2Authorization.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuth2Authorization);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuth2Authorization proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuth2Authorization implementation " + oAuth2Authorization.getClass());
        }
        OAuth2AuthorizationModelImpl oAuth2AuthorizationModelImpl = (OAuth2AuthorizationModelImpl)oAuth2Authorization;
        if (isNew && oAuth2Authorization.getCreateDate() == null) {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            Date date = new Date();
            if (serviceContext == null) {
                oAuth2Authorization.setCreateDate(date);
            } else {
                oAuth2Authorization.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuth2Authorization);
                oAuth2Authorization.setNew(false);
            } else {
                oAuth2Authorization = (OAuth2Authorization)session.merge((Object)oAuth2Authorization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!OAuth2AuthorizationModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            args = new Object[]{oAuth2AuthorizationModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getOAuth2ApplicationId()};
            this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getAccessTokenContentHash()};
            this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getRefreshTokenContentHash()};
            this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByOAuth2ApplicationId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalOAuth2ApplicationId()};
                this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getOAuth2ApplicationId()};
                this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByAccessTokenContentHash.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalAccessTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getAccessTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByRefreshTokenContentHash.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalRefreshTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getRefreshTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
            }
        }
        this.entityCache.putResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()), (Serializable)oAuth2Authorization, false);
        oAuth2Authorization.resetOriginalValues();
        return oAuth2Authorization;
    }

    public OAuth2Authorization findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(primaryKey);
        if (oAuth2Authorization == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOAuth2AuthorizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization findByPrimaryKey(long oAuth2AuthorizationId) throws NoSuchOAuth2AuthorizationException {
        return this.findByPrimaryKey(Long.valueOf(oAuth2AuthorizationId));
    }

    public OAuth2Authorization fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)serializable;
        if (oAuth2Authorization == null) {
            Session session = null;
            try {
                session = this.openSession();
                oAuth2Authorization = (OAuth2Authorization)session.get(OAuth2AuthorizationImpl.class, primaryKey);
                if (oAuth2Authorization != null) {
                    this.cacheResult(oAuth2Authorization);
                } else {
                    this.entityCache.putResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization fetchByPrimaryKey(long oAuth2AuthorizationId) {
        return this.fetchByPrimaryKey(Long.valueOf(oAuth2AuthorizationId));
    }

    public Map<Serializable, OAuth2Authorization> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, OAuth2Authorization> map = new HashMap<Serializable, OAuth2Authorization>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(primaryKey);
            if (oAuth2Authorization != null) {
                map.put(primaryKey, oAuth2Authorization);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (OAuth2Authorization)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (OAuth2Authorization oAuth2Authorization : query.list()) {
                map.put(oAuth2Authorization.getPrimaryKeyObj(), oAuth2Authorization);
                this.cacheResult(oAuth2Authorization);
                uncachedPrimaryKeys.remove(oAuth2Authorization.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<OAuth2Authorization> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuth2Authorization> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuth2Authorization> findAll(int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findAll(int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTH2AUTHORIZATION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTH2AUTHORIZATION;
                sql = sql.concat(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuth2Authorization oAuth2Authorization : this.findAll()) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTH2AUTHORIZATION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public long[] getOAuth2ScopeGrantPrimaryKeys(long pk) {
        long[] pks = this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    public List<OAuth2ScopeGrant> getOAuth2ScopeGrants(long pk) {
        return this.getOAuth2ScopeGrants(pk, -1, -1);
    }

    public List<OAuth2ScopeGrant> getOAuth2ScopeGrants(long pk, int start, int end) {
        return this.getOAuth2ScopeGrants(pk, start, end, null);
    }

    public List<OAuth2ScopeGrant> getOAuth2ScopeGrants(long pk, int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        return this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    public int getOAuth2ScopeGrantsSize(long pk) {
        long[] pks = this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    public boolean containsOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        return this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.containsTableMapping(pk, oAuth2ScopeGrantPK);
    }

    public boolean containsOAuth2ScopeGrants(long pk) {
        return this.getOAuth2ScopeGrantsSize(pk) > 0;
    }

    public void addOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        if (oAuth2Authorization == null) {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2ScopeGrantPK);
        } else {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(oAuth2Authorization.getCompanyId(), pk, oAuth2ScopeGrantPK);
        }
    }

    public void addOAuth2ScopeGrant(long pk, OAuth2ScopeGrant oAuth2ScopeGrant) {
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        if (oAuth2Authorization == null) {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2ScopeGrant.getPrimaryKey());
        } else {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(oAuth2Authorization.getCompanyId(), pk, oAuth2ScopeGrant.getPrimaryKey());
        }
    }

    public void addOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        long companyId = 0L;
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        companyId = oAuth2Authorization == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2Authorization.getCompanyId();
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMappings(companyId, pk, oAuth2ScopeGrantPKs);
    }

    public void addOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        this.addOAuth2ScopeGrants(pk, ListUtil.toLongArray(oAuth2ScopeGrants, (Accessor)OAuth2ScopeGrant.O_AUTH2_SCOPE_GRANT_ID_ACCESSOR));
    }

    public void clearOAuth2ScopeGrants(long pk) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    public void removeOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMapping(pk, oAuth2ScopeGrantPK);
    }

    public void removeOAuth2ScopeGrant(long pk, OAuth2ScopeGrant oAuth2ScopeGrant) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMapping(pk, oAuth2ScopeGrant.getPrimaryKey());
    }

    public void removeOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMappings(pk, oAuth2ScopeGrantPKs);
    }

    public void removeOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        this.removeOAuth2ScopeGrants(pk, ListUtil.toLongArray(oAuth2ScopeGrants, (Accessor)OAuth2ScopeGrant.O_AUTH2_SCOPE_GRANT_ID_ACCESSOR));
    }

    public void setOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        Set newOAuth2ScopeGrantPKsSet = SetUtil.fromArray((long[])oAuth2ScopeGrantPKs);
        Set oldOAuth2ScopeGrantPKsSet = SetUtil.fromArray((long[])this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk));
        HashSet removeOAuth2ScopeGrantPKsSet = new HashSet(oldOAuth2ScopeGrantPKsSet);
        removeOAuth2ScopeGrantPKsSet.removeAll(newOAuth2ScopeGrantPKsSet);
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeOAuth2ScopeGrantPKsSet));
        newOAuth2ScopeGrantPKsSet.removeAll(oldOAuth2ScopeGrantPKsSet);
        long companyId = 0L;
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        companyId = oAuth2Authorization == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2Authorization.getCompanyId();
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray((Collection)newOAuth2ScopeGrantPKsSet));
    }

    public void setOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        try {
            long[] oAuth2ScopeGrantPKs = new long[oAuth2ScopeGrants.size()];
            for (int i = 0; i < oAuth2ScopeGrants.size(); ++i) {
                OAuth2ScopeGrant oAuth2ScopeGrant = oAuth2ScopeGrants.get(i);
                oAuth2ScopeGrantPKs[i] = oAuth2ScopeGrant.getPrimaryKey();
            }
            this.setOAuth2ScopeGrants(pk, oAuth2ScopeGrantPKs);
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuth2AuthorizationModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper = TableMapperFactory.getTableMapper((String)"OA2Auths_OA2ScopeGrants", (String)"companyId", (String)"oAuth2AuthorizationId", (String)"oAuth2ScopeGrantId", (BasePersistence)this, (BasePersistence)this.oAuth2ScopeGrantPersistence);
        this._finderPathWithPaginationFindAll = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUserId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 8L);
        this._finderPathCountByUserId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByOAuth2ApplicationId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOAuth2ApplicationId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByOAuth2ApplicationId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOAuth2ApplicationId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByOAuth2ApplicationId = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOAuth2ApplicationId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByAccessTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccessTokenContentHash", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByAccessTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccessTokenContentHash", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByAccessTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccessTokenContentHash", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByRefreshTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRefreshTokenContentHash", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByRefreshTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRefreshTokenContentHash", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByRefreshTokenContentHash = new FinderPath(OAuth2AuthorizationModelImpl.ENTITY_CACHE_ENABLED, OAuth2AuthorizationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRefreshTokenContentHash", new String[]{Long.class.getName()});
        OAuth2AuthorizationUtil.setPersistence((OAuth2AuthorizationPersistence)this);
    }

    public void destroy() {
        OAuth2AuthorizationUtil.setPersistence(null);
        this.entityCache.removeCache(OAuth2AuthorizationImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        TableMapperFactory.removeTableMapper((String)"OA2Auths_OA2ScopeGrants");
    }
}

