/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2ApplicationException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationModelImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2ApplicationPersistence;
import com.liferay.oauth2.provider.service.persistence.OAuth2ApplicationUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OAuth2ApplicationPersistenceImpl
extends BasePersistenceImpl<OAuth2Application>
implements OAuth2ApplicationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuth2ApplicationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC;
    private FinderPath _finderPathWithoutPaginationFindByC;
    private FinderPath _finderPathCountByC;
    private static final String _FINDER_COLUMN_C_COMPANYID_2 = "oAuth2Application.companyId = ?";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_COMPANYID_2 = "oAuth2Application.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLIENTID_2 = "oAuth2Application.clientId = ?";
    private static final String _FINDER_COLUMN_C_C_CLIENTID_3 = "(oAuth2Application.clientId IS NULL OR oAuth2Application.clientId = '')";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OAUTH2APPLICATION = "SELECT oAuth2Application FROM OAuth2Application oAuth2Application";
    private static final String _SQL_SELECT_OAUTH2APPLICATION_WHERE_PKS_IN = "SELECT oAuth2Application FROM OAuth2Application oAuth2Application WHERE oAuth2ApplicationId IN (";
    private static final String _SQL_SELECT_OAUTH2APPLICATION_WHERE = "SELECT oAuth2Application FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _SQL_COUNT_OAUTH2APPLICATION = "SELECT COUNT(oAuth2Application) FROM OAuth2Application oAuth2Application";
    private static final String _SQL_COUNT_OAUTH2APPLICATION_WHERE = "SELECT COUNT(oAuth2Application) FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "oAuth2Application.oAuth2ApplicationId";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE = "SELECT DISTINCT {oAuth2Application.*} FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {OAuth2Application.*} FROM (SELECT DISTINCT oAuth2Application.oAuth2ApplicationId FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN OAuth2Application ON TEMP_TABLE.oAuth2ApplicationId = OAuth2Application.oAuth2ApplicationId";
    private static final String _FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE = "SELECT COUNT(DISTINCT oAuth2Application.oAuth2ApplicationId) AS COUNT_VALUE FROM OAuth2Application oAuth2Application WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "oAuth2Application";
    private static final String _FILTER_ENTITY_TABLE = "OAuth2Application";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuth2Application.";
    private static final String _ORDER_BY_ENTITY_TABLE = "OAuth2Application.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuth2Application exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuth2Application exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ApplicationPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"oAuth2ApplicationScopeAliasesId"});

    public List<OAuth2Application> findByC(long companyId) {
        return this.findByC(companyId, -1, -1, null);
    }

    public List<OAuth2Application> findByC(long companyId, int start, int end) {
        return this.findByC(companyId, start, end, null);
    }

    public List<OAuth2Application> findByC(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findByC(companyId, start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findByC(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Application oAuth2Application : list) {
                if (companyId == oAuth2Application.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Application findByC_First(long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_First(companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByC_First(long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        List<OAuth2Application> list = this.findByC(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application findByC_Last(long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_Last(companyId, orderByComparator);
        if (oAuth2Application != null) {
            return oAuth2Application;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuth2ApplicationException(sb.toString());
    }

    public OAuth2Application fetchByC_Last(long companyId, OrderByComparator<OAuth2Application> orderByComparator) {
        int count = this.countByC(companyId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Application> list = this.findByC(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Application[] findByC_PrevAndNext(long oAuth2ApplicationId, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.getByC_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, true), oAuth2Application, this.getByC_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application getByC_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public List<OAuth2Application> filterFindByC(long companyId) {
        return this.filterFindByC(companyId, -1, -1, null);
    }

    public List<OAuth2Application> filterFindByC(long companyId, int start, int end) {
        return this.filterFindByC(companyId, start, end, null);
    }

    public List<OAuth2Application> filterFindByC(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application[] filterFindByC_PrevAndNext(long oAuth2ApplicationId, long companyId, OrderByComparator<OAuth2Application> orderByComparator) throws NoSuchOAuth2ApplicationException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_PrevAndNext(oAuth2ApplicationId, companyId, orderByComparator);
        }
        OAuth2Application oAuth2Application = this.findByPrimaryKey(oAuth2ApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application[] array = new OAuth2ApplicationImpl[]{this.filterGetByC_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, true), oAuth2Application, this.filterGetByC_PrevAndNext(session, oAuth2Application, companyId, orderByComparator, false)};
            OAuth2Application[] oAuth2ApplicationArray = array;
            return oAuth2ApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application filterGetByC_PrevAndNext(Session session, OAuth2Application oAuth2Application, long companyId, OrderByComparator<OAuth2Application> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_C_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTH2APPLICATION_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
        } else {
            sb.append(" ORDER BY OAuth2Application.oAuth2ApplicationId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuth2ApplicationImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuth2ApplicationImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Application)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuth2Application)list.get(1);
        }
        return null;
    }

    public void removeByC(long companyId) {
        for (OAuth2Application oAuth2Application : this.findByC(companyId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countByC(long companyId) {
        FinderPath finderPath = this._finderPathCountByC;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTH2APPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_C_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuth2Application.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuth2Application findByC_C(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByC_C(companyId, clientId);
        if (oAuth2Application == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", clientId=");
            sb.append(clientId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOAuth2ApplicationException(sb.toString());
        }
        return oAuth2Application;
    }

    public OAuth2Application fetchByC_C(long companyId, String clientId) {
        return this.fetchByC_C(companyId, clientId, true);
    }

    public OAuth2Application fetchByC_C(long companyId, String clientId, boolean useFinderCache) {
        OAuth2Application oAuth2Application;
        clientId = Objects.toString(clientId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, clientId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof OAuth2Application && (companyId != (oAuth2Application = (OAuth2Application)result).getCompanyId() || !Objects.equals(clientId, oAuth2Application.getClientId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_COMPANYID_2);
            boolean bindClientId = false;
            if (clientId.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_3);
            } else {
                bindClientId = true;
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindClientId) {
                    queryPos.add(clientId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_C, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, clientId};
                            }
                            _log.warn((Object)("OAuth2ApplicationPersistenceImpl.fetchByC_C(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    OAuth2Application oAuth2Application2 = (OAuth2Application)list.get(0);
                    result = oAuth2Application2;
                    this.cacheResult(oAuth2Application2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_C, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuth2Application)result;
    }

    public OAuth2Application removeByC_C(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.findByC_C(companyId, clientId);
        return (OAuth2Application)this.remove((BaseModel)oAuth2Application);
    }

    public int countByC_C(long companyId, String clientId) {
        clientId = Objects.toString(clientId, "");
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{companyId, clientId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTH2APPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_C_COMPANYID_2);
            boolean bindClientId = false;
            if (clientId.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_3);
            } else {
                bindClientId = true;
                sb.append(_FINDER_COLUMN_C_C_CLIENTID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindClientId) {
                    queryPos.add(clientId);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuth2ApplicationPersistenceImpl() {
        block2: {
            HashMap<String, String> dbColumnNames = new HashMap<String, String>();
            dbColumnNames.put("oAuth2ApplicationScopeAliasesId", "oA2AScopeAliasesId");
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        this.setModelClass(OAuth2Application.class);
    }

    public void cacheResult(OAuth2Application oAuth2Application) {
        this.entityCache.putResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey()), (Serializable)oAuth2Application);
        this.finderCache.putResult(this._finderPathFetchByC_C, new Object[]{oAuth2Application.getCompanyId(), oAuth2Application.getClientId()}, (Object)oAuth2Application);
        oAuth2Application.resetOriginalValues();
    }

    public void cacheResult(List<OAuth2Application> oAuth2Applications) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuth2Applications.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuth2Application oAuth2Application : oAuth2Applications) {
            if (this.entityCache.getResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey())) == null) {
                this.cacheResult(oAuth2Application);
                continue;
            }
            oAuth2Application.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuth2ApplicationImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OAuth2Application oAuth2Application) {
        this.entityCache.removeResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((OAuth2ApplicationModelImpl)oAuth2Application, true);
    }

    public void clearCache(List<OAuth2Application> oAuth2Applications) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (OAuth2Application oAuth2Application : oAuth2Applications) {
            this.entityCache.removeResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey()));
            this.clearUniqueFindersCache((OAuth2ApplicationModelImpl)oAuth2Application, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl) {
        Object[] args = new Object[]{oAuth2ApplicationModelImpl.getCompanyId(), oAuth2ApplicationModelImpl.getClientId()};
        this.finderCache.putResult(this._finderPathCountByC_C, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_C, args, (Object)oAuth2ApplicationModelImpl, false);
    }

    protected void clearUniqueFindersCache(OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{oAuth2ApplicationModelImpl.getCompanyId(), oAuth2ApplicationModelImpl.getClientId()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
        if ((oAuth2ApplicationModelImpl.getColumnBitmask() & this._finderPathFetchByC_C.getColumnBitmask()) != 0L) {
            args = new Object[]{oAuth2ApplicationModelImpl.getOriginalCompanyId(), oAuth2ApplicationModelImpl.getOriginalClientId()};
            this.finderCache.removeResult(this._finderPathCountByC_C, args);
            this.finderCache.removeResult(this._finderPathFetchByC_C, args);
        }
    }

    public OAuth2Application create(long oAuth2ApplicationId) {
        OAuth2ApplicationImpl oAuth2Application = new OAuth2ApplicationImpl();
        oAuth2Application.setNew(true);
        oAuth2Application.setPrimaryKey(oAuth2ApplicationId);
        oAuth2Application.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuth2Application;
    }

    public OAuth2Application remove(long oAuth2ApplicationId) throws NoSuchOAuth2ApplicationException {
        return this.remove(Long.valueOf(oAuth2ApplicationId));
    }

    public OAuth2Application remove(Serializable primaryKey) throws NoSuchOAuth2ApplicationException {
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Application oAuth2Application = (OAuth2Application)session.get(OAuth2ApplicationImpl.class, primaryKey);
            if (oAuth2Application == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOAuth2ApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuth2Application oAuth2Application2 = (OAuth2Application)this.remove((BaseModel)oAuth2Application);
            return oAuth2Application2;
        }
        catch (NoSuchOAuth2ApplicationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Application removeImpl(OAuth2Application oAuth2Application) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuth2Application)) {
                oAuth2Application = (OAuth2Application)session.get(OAuth2ApplicationImpl.class, oAuth2Application.getPrimaryKeyObj());
            }
            if (oAuth2Application != null) {
                session.delete((Object)oAuth2Application);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuth2Application != null) {
            this.clearCache(oAuth2Application);
        }
        return oAuth2Application;
    }

    public OAuth2Application updateImpl(OAuth2Application oAuth2Application) {
        boolean isNew = oAuth2Application.isNew();
        if (!(oAuth2Application instanceof OAuth2ApplicationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuth2Application.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuth2Application);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuth2Application proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuth2Application implementation " + oAuth2Application.getClass());
        }
        OAuth2ApplicationModelImpl oAuth2ApplicationModelImpl = (OAuth2ApplicationModelImpl)oAuth2Application;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && oAuth2Application.getCreateDate() == null) {
            if (serviceContext == null) {
                oAuth2Application.setCreateDate(date);
            } else {
                oAuth2Application.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!oAuth2ApplicationModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                oAuth2Application.setModifiedDate(date);
            } else {
                oAuth2Application.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuth2Application);
                oAuth2Application.setNew(false);
            } else {
                oAuth2Application = (OAuth2Application)session.merge((Object)oAuth2Application);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!OAuth2ApplicationModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{oAuth2ApplicationModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByC, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else if ((oAuth2ApplicationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{oAuth2ApplicationModelImpl.getOriginalCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByC, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC, args);
            args = new Object[]{oAuth2ApplicationModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByC, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC, args);
        }
        this.entityCache.putResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, (Serializable)Long.valueOf(oAuth2Application.getPrimaryKey()), (Serializable)oAuth2Application, false);
        this.clearUniqueFindersCache(oAuth2ApplicationModelImpl, false);
        this.cacheUniqueFindersCache(oAuth2ApplicationModelImpl);
        oAuth2Application.resetOriginalValues();
        return oAuth2Application;
    }

    public OAuth2Application findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuth2ApplicationException {
        OAuth2Application oAuth2Application = this.fetchByPrimaryKey(primaryKey);
        if (oAuth2Application == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOAuth2ApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuth2Application;
    }

    public OAuth2Application findByPrimaryKey(long oAuth2ApplicationId) throws NoSuchOAuth2ApplicationException {
        return this.findByPrimaryKey(Long.valueOf(oAuth2ApplicationId));
    }

    public OAuth2Application fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        OAuth2Application oAuth2Application = (OAuth2Application)serializable;
        if (oAuth2Application == null) {
            Session session = null;
            try {
                session = this.openSession();
                oAuth2Application = (OAuth2Application)session.get(OAuth2ApplicationImpl.class, primaryKey);
                if (oAuth2Application != null) {
                    this.cacheResult(oAuth2Application);
                } else {
                    this.entityCache.putResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return oAuth2Application;
    }

    public OAuth2Application fetchByPrimaryKey(long oAuth2ApplicationId) {
        return this.fetchByPrimaryKey(Long.valueOf(oAuth2ApplicationId));
    }

    public Map<Serializable, OAuth2Application> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, OAuth2Application> map = new HashMap<Serializable, OAuth2Application>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            OAuth2Application oAuth2Application = this.fetchByPrimaryKey(primaryKey);
            if (oAuth2Application != null) {
                map.put(primaryKey, oAuth2Application);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (OAuth2Application)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_OAUTH2APPLICATION_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (OAuth2Application oAuth2Application : query.list()) {
                map.put(oAuth2Application.getPrimaryKeyObj(), oAuth2Application);
                this.cacheResult(oAuth2Application);
                uncachedPrimaryKeys.remove(oAuth2Application.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<OAuth2Application> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuth2Application> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuth2Application> findAll(int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuth2Application> findAll(int start, int end, OrderByComparator<OAuth2Application> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTH2APPLICATION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTH2APPLICATION;
                sql = sql.concat(" ORDER BY oAuth2Application.oAuth2ApplicationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuth2Application oAuth2Application : this.findAll()) {
            this.remove((BaseModel)oAuth2Application);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTH2APPLICATION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuth2ApplicationModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, OAuth2ApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, OAuth2ApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByC = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, OAuth2ApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, OAuth2ApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByC = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC", new String[]{Long.class.getName()});
        this._finderPathFetchByC_C = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, OAuth2ApplicationImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), String.class.getName()}, 3L);
        this._finderPathCountByC_C = new FinderPath(OAuth2ApplicationModelImpl.ENTITY_CACHE_ENABLED, OAuth2ApplicationModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), String.class.getName()});
        OAuth2ApplicationUtil.setPersistence((OAuth2ApplicationPersistence)this);
    }

    public void destroy() {
        OAuth2ApplicationUtil.setPersistence(null);
        this.entityCache.removeCache(OAuth2ApplicationImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

