/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth2.provider.model.impl;

import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalServiceUtil;

/**
 * The extended model base implementation for the OAuth2ScopeGrant service. Represents a row in the &quot;OAuth2ScopeGrant&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuth2ScopeGrantImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuth2ScopeGrantImpl
 * @see OAuth2ScopeGrant
 * @generated
 */
public abstract class OAuth2ScopeGrantBaseImpl
	extends OAuth2ScopeGrantModelImpl implements OAuth2ScopeGrant {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth2 scope grant model instance should use the <code>OAuth2ScopeGrant</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuth2ScopeGrantLocalServiceUtil.addOAuth2ScopeGrant(this);
		}
		else {
			OAuth2ScopeGrantLocalServiceUtil.updateOAuth2ScopeGrant(this);
		}
	}

}