/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.client.persistence.service.persistence.impl;

import com.liferay.oauth.client.persistence.exception.NoSuchOAuthClientEntryException;
import com.liferay.oauth.client.persistence.model.OAuthClientEntry;
import com.liferay.oauth.client.persistence.model.OAuthClientEntryTable;
import com.liferay.oauth.client.persistence.model.impl.OAuthClientEntryImpl;
import com.liferay.oauth.client.persistence.model.impl.OAuthClientEntryModelImpl;
import com.liferay.oauth.client.persistence.service.persistence.OAuthClientEntryPersistence;
import com.liferay.oauth.client.persistence.service.persistence.OAuthClientEntryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuthClientEntryPersistence.class})
public class OAuthClientEntryPersistenceImpl
extends BasePersistenceImpl<OAuthClientEntry>
implements OAuthClientEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuthClientEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "oAuthClientEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "oAuthClientEntry.userId = ?";
    private FinderPath _finderPathWithPaginationFindByC_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A;
    private FinderPath _finderPathCountByC_A;
    private static final String _FINDER_COLUMN_C_A_COMPANYID_2 = "oAuthClientEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2 = "oAuthClientEntry.authServerWellKnownURI = ?";
    private static final String _FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3 = "(oAuthClientEntry.authServerWellKnownURI IS NULL OR oAuthClientEntry.authServerWellKnownURI = '')";
    private FinderPath _finderPathFetchByC_A_C;
    private static final String _FINDER_COLUMN_C_A_C_COMPANYID_2 = "oAuthClientEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_C_AUTHSERVERWELLKNOWNURI_2 = "oAuthClientEntry.authServerWellKnownURI = ? AND ";
    private static final String _FINDER_COLUMN_C_A_C_AUTHSERVERWELLKNOWNURI_3 = "(oAuthClientEntry.authServerWellKnownURI IS NULL OR oAuthClientEntry.authServerWellKnownURI = '') AND ";
    private static final String _FINDER_COLUMN_C_A_C_CLIENTID_2 = "oAuthClientEntry.clientId = ?";
    private static final String _FINDER_COLUMN_C_A_C_CLIENTID_3 = "(oAuthClientEntry.clientId IS NULL OR oAuthClientEntry.clientId = '')";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OAUTHCLIENTENTRY = "SELECT oAuthClientEntry FROM OAuthClientEntry oAuthClientEntry";
    private static final String _SQL_SELECT_OAUTHCLIENTENTRY_WHERE = "SELECT oAuthClientEntry FROM OAuthClientEntry oAuthClientEntry WHERE ";
    private static final String _SQL_COUNT_OAUTHCLIENTENTRY = "SELECT COUNT(oAuthClientEntry) FROM OAuthClientEntry oAuthClientEntry";
    private static final String _SQL_COUNT_OAUTHCLIENTENTRY_WHERE = "SELECT COUNT(oAuthClientEntry) FROM OAuthClientEntry oAuthClientEntry WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "oAuthClientEntry.oAuthClientEntryId";
    private static final String _FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE = "SELECT DISTINCT {oAuthClientEntry.*} FROM OAuthClientEntry oAuthClientEntry WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {OAuthClientEntry.*} FROM (SELECT DISTINCT oAuthClientEntry.oAuthClientEntryId FROM OAuthClientEntry oAuthClientEntry WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN OAuthClientEntry ON TEMP_TABLE.oAuthClientEntryId = OAuthClientEntry.oAuthClientEntryId";
    private static final String _FILTER_SQL_COUNT_OAUTHCLIENTENTRY_WHERE = "SELECT COUNT(DISTINCT oAuthClientEntry.oAuthClientEntryId) AS COUNT_VALUE FROM OAuthClientEntry oAuthClientEntry WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "oAuthClientEntry";
    private static final String _FILTER_ENTITY_TABLE = "OAuthClientEntry";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuthClientEntry.";
    private static final String _ORDER_BY_ENTITY_TABLE = "OAuthClientEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuthClientEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuthClientEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuthClientEntryPersistenceImpl.class);

    public List<OAuthClientEntry> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<OAuthClientEntry> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<OAuthClientEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<OAuthClientEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuthClientEntry oAuthClientEntry : list) {
                if (companyId == oAuthClientEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthClientEntry findByCompanyId_First(long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByCompanyId_First(long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) {
        List<OAuthClientEntry> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry findByCompanyId_Last(long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByCompanyId_Last(long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<OAuthClientEntry> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry[] findByCompanyId_PrevAndNext(long oAuthClientEntryId, long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.getByCompanyId_PrevAndNext(session, oAuthClientEntry, companyId, orderByComparator, true), oAuthClientEntry, this.getByCompanyId_PrevAndNext(session, oAuthClientEntry, companyId, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry getByCompanyId_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long companyId, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public List<OAuthClientEntry> filterFindByCompanyId(long companyId) {
        return this.filterFindByCompanyId(companyId, -1, -1, null);
    }

    public List<OAuthClientEntry> filterFindByCompanyId(long companyId, int start, int end) {
        return this.filterFindByCompanyId(companyId, start, end, null);
    }

    public List<OAuthClientEntry> filterFindByCompanyId(long companyId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId(companyId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthClientEntry[] filterFindByCompanyId_PrevAndNext(long oAuthClientEntryId, long companyId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByCompanyId_PrevAndNext(oAuthClientEntryId, companyId, orderByComparator);
        }
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.filterGetByCompanyId_PrevAndNext(session, oAuthClientEntry, companyId, orderByComparator, true), oAuthClientEntry, this.filterGetByCompanyId_PrevAndNext(session, oAuthClientEntry, companyId, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry filterGetByCompanyId_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long companyId, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (OAuthClientEntry oAuthClientEntry : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)oAuthClientEntry);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByCompanyId(long companyId) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByCompanyId(companyId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<OAuthClientEntry> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OAuthClientEntry> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OAuthClientEntry> findByUserId(long userId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OAuthClientEntry> findByUserId(long userId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuthClientEntry oAuthClientEntry : list) {
                if (userId == oAuthClientEntry.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthClientEntry findByUserId_First(long userId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByUserId_First(userId, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByUserId_First(long userId, OrderByComparator<OAuthClientEntry> orderByComparator) {
        List<OAuthClientEntry> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry findByUserId_Last(long userId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByUserId_Last(userId, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByUserId_Last(long userId, OrderByComparator<OAuthClientEntry> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OAuthClientEntry> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry[] findByUserId_PrevAndNext(long oAuthClientEntryId, long userId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.getByUserId_PrevAndNext(session, oAuthClientEntry, userId, orderByComparator, true), oAuthClientEntry, this.getByUserId_PrevAndNext(session, oAuthClientEntry, userId, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry getByUserId_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long userId, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public List<OAuthClientEntry> filterFindByUserId(long userId) {
        return this.filterFindByUserId(userId, -1, -1, null);
    }

    public List<OAuthClientEntry> filterFindByUserId(long userId, int start, int end) {
        return this.filterFindByUserId(userId, start, end, null);
    }

    public List<OAuthClientEntry> filterFindByUserId(long userId, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUserId(userId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthClientEntry[] filterFindByUserId_PrevAndNext(long oAuthClientEntryId, long userId, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUserId_PrevAndNext(oAuthClientEntryId, userId, orderByComparator);
        }
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.filterGetByUserId_PrevAndNext(session, oAuthClientEntry, userId, orderByComparator, true), oAuthClientEntry, this.filterGetByUserId_PrevAndNext(session, oAuthClientEntry, userId, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry filterGetByUserId_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long userId, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OAuthClientEntry oAuthClientEntry : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)oAuthClientEntry);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByUserId(long userId) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByUserId(userId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<OAuthClientEntry> findByC_A(long companyId, String authServerWellKnownURI) {
        return this.findByC_A(companyId, authServerWellKnownURI, -1, -1, null);
    }

    public List<OAuthClientEntry> findByC_A(long companyId, String authServerWellKnownURI, int start, int end) {
        return this.findByC_A(companyId, authServerWellKnownURI, start, end, null);
    }

    public List<OAuthClientEntry> findByC_A(long companyId, String authServerWellKnownURI, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        return this.findByC_A(companyId, authServerWellKnownURI, start, end, orderByComparator, true);
    }

    public List<OAuthClientEntry> findByC_A(long companyId, String authServerWellKnownURI, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator, boolean useFinderCache) {
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_A;
                finderArgs = new Object[]{companyId, authServerWellKnownURI};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_A;
            finderArgs = new Object[]{companyId, authServerWellKnownURI, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (OAuthClientEntry oAuthClientEntry : list) {
                if (companyId == oAuthClientEntry.getCompanyId() && authServerWellKnownURI.equals(oAuthClientEntry.getAuthServerWellKnownURI())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
            sb.append("oAuthClientEntry.companyId = ? AND ");
            boolean bindAuthServerWellKnownURI = false;
            if (authServerWellKnownURI.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
            } else {
                bindAuthServerWellKnownURI = true;
                sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAuthServerWellKnownURI) {
                    queryPos.add(authServerWellKnownURI);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthClientEntry findByC_A_First(long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByC_A_First(companyId, authServerWellKnownURI, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", authServerWellKnownURI=");
        sb.append(authServerWellKnownURI);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByC_A_First(long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) {
        List<OAuthClientEntry> list = this.findByC_A(companyId, authServerWellKnownURI, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry findByC_A_Last(long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByC_A_Last(companyId, authServerWellKnownURI, orderByComparator);
        if (oAuthClientEntry != null) {
            return oAuthClientEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", authServerWellKnownURI=");
        sb.append(authServerWellKnownURI);
        sb.append("}");
        throw new NoSuchOAuthClientEntryException(sb.toString());
    }

    public OAuthClientEntry fetchByC_A_Last(long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) {
        int count = this.countByC_A(companyId, authServerWellKnownURI);
        if (count == 0) {
            return null;
        }
        List<OAuthClientEntry> list = this.findByC_A(companyId, authServerWellKnownURI, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthClientEntry[] findByC_A_PrevAndNext(long oAuthClientEntryId, long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.getByC_A_PrevAndNext(session, oAuthClientEntry, companyId, authServerWellKnownURI, orderByComparator, true), oAuthClientEntry, this.getByC_A_PrevAndNext(session, oAuthClientEntry, companyId, authServerWellKnownURI, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry getByC_A_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        sb.append("oAuthClientEntry.companyId = ? AND ");
        boolean bindAuthServerWellKnownURI = false;
        if (authServerWellKnownURI.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
        } else {
            bindAuthServerWellKnownURI = true;
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindAuthServerWellKnownURI) {
            queryPos.add(authServerWellKnownURI);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public List<OAuthClientEntry> filterFindByC_A(long companyId, String authServerWellKnownURI) {
        return this.filterFindByC_A(companyId, authServerWellKnownURI, -1, -1, null);
    }

    public List<OAuthClientEntry> filterFindByC_A(long companyId, String authServerWellKnownURI, int start, int end) {
        return this.filterFindByC_A(companyId, authServerWellKnownURI, start, end, null);
    }

    public List<OAuthClientEntry> filterFindByC_A(long companyId, String authServerWellKnownURI, int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_A(companyId, authServerWellKnownURI, start, end, orderByComparator);
        }
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuthClientEntry.companyId = ? AND ");
        boolean bindAuthServerWellKnownURI = false;
        if (authServerWellKnownURI.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
        } else {
            bindAuthServerWellKnownURI = true;
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            if (bindAuthServerWellKnownURI) {
                queryPos.add(authServerWellKnownURI);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthClientEntry[] filterFindByC_A_PrevAndNext(long oAuthClientEntryId, long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator) throws NoSuchOAuthClientEntryException {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.findByC_A_PrevAndNext(oAuthClientEntryId, companyId, authServerWellKnownURI, orderByComparator);
        }
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        OAuthClientEntry oAuthClientEntry = this.findByPrimaryKey(oAuthClientEntryId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry[] array = new OAuthClientEntryImpl[]{this.filterGetByC_A_PrevAndNext(session, oAuthClientEntry, companyId, authServerWellKnownURI, orderByComparator, true), oAuthClientEntry, this.filterGetByC_A_PrevAndNext(session, oAuthClientEntry, companyId, authServerWellKnownURI, orderByComparator, false)};
            OAuthClientEntry[] oAuthClientEntryArray = array;
            return oAuthClientEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry filterGetByC_A_PrevAndNext(Session session, OAuthClientEntry oAuthClientEntry, long companyId, String authServerWellKnownURI, OrderByComparator<OAuthClientEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuthClientEntry.companyId = ? AND ");
        boolean bindAuthServerWellKnownURI = false;
        if (authServerWellKnownURI.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
        } else {
            bindAuthServerWellKnownURI = true;
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
        }
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHCLIENTENTRY_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
        } else {
            sb.append(" ORDER BY OAuthClientEntry.oAuthClientEntryId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthClientEntryImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthClientEntryImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(companyId);
        if (bindAuthServerWellKnownURI) {
            queryPos.add(authServerWellKnownURI);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthClientEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuthClientEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_A(long companyId, String authServerWellKnownURI) {
        for (OAuthClientEntry oAuthClientEntry : this.findByC_A(companyId, authServerWellKnownURI, -1, -1, null)) {
            this.remove((BaseModel)oAuthClientEntry);
        }
    }

    public int countByC_A(long companyId, String authServerWellKnownURI) {
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        FinderPath finderPath = this._finderPathCountByC_A;
        Object[] finderArgs = new Object[]{companyId, authServerWellKnownURI};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
            sb.append("oAuthClientEntry.companyId = ? AND ");
            boolean bindAuthServerWellKnownURI = false;
            if (authServerWellKnownURI.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
            } else {
                bindAuthServerWellKnownURI = true;
                sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAuthServerWellKnownURI) {
                    queryPos.add(authServerWellKnownURI);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByC_A(long companyId, String authServerWellKnownURI) {
        if (!InlineSQLHelperUtil.isEnabled((long)companyId, (long)0L)) {
            return this.countByC_A(companyId, authServerWellKnownURI);
        }
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        StringBundler sb = new StringBundler(3);
        sb.append(_FILTER_SQL_COUNT_OAUTHCLIENTENTRY_WHERE);
        sb.append("oAuthClientEntry.companyId = ? AND ");
        boolean bindAuthServerWellKnownURI = false;
        if (authServerWellKnownURI.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_3);
        } else {
            bindAuthServerWellKnownURI = true;
            sb.append(_FINDER_COLUMN_C_A_AUTHSERVERWELLKNOWNURI_2);
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthClientEntry.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            if (bindAuthServerWellKnownURI) {
                queryPos.add(authServerWellKnownURI);
            }
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthClientEntry findByC_A_C(long companyId, String authServerWellKnownURI, String clientId) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.fetchByC_A_C(companyId, authServerWellKnownURI, clientId);
        if (oAuthClientEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", authServerWellKnownURI=");
            sb.append(authServerWellKnownURI);
            sb.append(", clientId=");
            sb.append(clientId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOAuthClientEntryException(sb.toString());
        }
        return oAuthClientEntry;
    }

    public OAuthClientEntry fetchByC_A_C(long companyId, String authServerWellKnownURI, String clientId) {
        return this.fetchByC_A_C(companyId, authServerWellKnownURI, clientId, true);
    }

    public OAuthClientEntry fetchByC_A_C(long companyId, String authServerWellKnownURI, String clientId, boolean useFinderCache) {
        OAuthClientEntry oAuthClientEntry;
        authServerWellKnownURI = Objects.toString(authServerWellKnownURI, "");
        clientId = Objects.toString(clientId, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, authServerWellKnownURI, clientId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_A_C, finderArgs, (BasePersistence)this);
        }
        if (!(!(result instanceof OAuthClientEntry) || companyId == (oAuthClientEntry = (OAuthClientEntry)result).getCompanyId() && Objects.equals(authServerWellKnownURI, oAuthClientEntry.getAuthServerWellKnownURI()) && Objects.equals(clientId, oAuthClientEntry.getClientId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_OAUTHCLIENTENTRY_WHERE);
            sb.append("oAuthClientEntry.companyId = ? AND ");
            boolean bindAuthServerWellKnownURI = false;
            if (authServerWellKnownURI.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_C_AUTHSERVERWELLKNOWNURI_3);
            } else {
                bindAuthServerWellKnownURI = true;
                sb.append(_FINDER_COLUMN_C_A_C_AUTHSERVERWELLKNOWNURI_2);
            }
            boolean bindClientId = false;
            if (clientId.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_A_C_CLIENTID_3);
            } else {
                bindClientId = true;
                sb.append(_FINDER_COLUMN_C_A_C_CLIENTID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindAuthServerWellKnownURI) {
                    queryPos.add(authServerWellKnownURI);
                }
                if (bindClientId) {
                    queryPos.add(clientId);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_A_C, finderArgs, (Object)list);
                    }
                } else {
                    OAuthClientEntry oAuthClientEntry2 = (OAuthClientEntry)list.get(0);
                    result = oAuthClientEntry2;
                    this.cacheResult(oAuthClientEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuthClientEntry)result;
    }

    public OAuthClientEntry removeByC_A_C(long companyId, String authServerWellKnownURI, String clientId) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = this.findByC_A_C(companyId, authServerWellKnownURI, clientId);
        return (OAuthClientEntry)this.remove((BaseModel)oAuthClientEntry);
    }

    public int countByC_A_C(long companyId, String authServerWellKnownURI, String clientId) {
        OAuthClientEntry oAuthClientEntry = this.fetchByC_A_C(companyId, authServerWellKnownURI, clientId);
        if (oAuthClientEntry == null) {
            return 0;
        }
        return 1;
    }

    public OAuthClientEntryPersistenceImpl() {
        this.setModelClass(OAuthClientEntry.class);
        this.setModelImplClass(OAuthClientEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)OAuthClientEntryTable.INSTANCE);
    }

    public void cacheResult(OAuthClientEntry oAuthClientEntry) {
        this.entityCache.putResult(OAuthClientEntryImpl.class, (Serializable)Long.valueOf(oAuthClientEntry.getPrimaryKey()), (Serializable)oAuthClientEntry);
        this.finderCache.putResult(this._finderPathFetchByC_A_C, new Object[]{oAuthClientEntry.getCompanyId(), oAuthClientEntry.getAuthServerWellKnownURI(), oAuthClientEntry.getClientId()}, (Object)oAuthClientEntry);
    }

    public void cacheResult(List<OAuthClientEntry> oAuthClientEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuthClientEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuthClientEntry oAuthClientEntry : oAuthClientEntries) {
            if (this.entityCache.getResult(OAuthClientEntryImpl.class, (Serializable)Long.valueOf(oAuthClientEntry.getPrimaryKey())) != null) continue;
            this.cacheResult(oAuthClientEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuthClientEntryImpl.class);
        this.finderCache.clearCache(OAuthClientEntryImpl.class);
    }

    public void clearCache(OAuthClientEntry oAuthClientEntry) {
        this.entityCache.removeResult(OAuthClientEntryImpl.class, (BaseModel)oAuthClientEntry);
    }

    public void clearCache(List<OAuthClientEntry> oAuthClientEntries) {
        for (OAuthClientEntry oAuthClientEntry : oAuthClientEntries) {
            this.entityCache.removeResult(OAuthClientEntryImpl.class, (BaseModel)oAuthClientEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(OAuthClientEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuthClientEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuthClientEntryModelImpl oAuthClientEntryModelImpl) {
        Object[] args = new Object[]{oAuthClientEntryModelImpl.getCompanyId(), oAuthClientEntryModelImpl.getAuthServerWellKnownURI(), oAuthClientEntryModelImpl.getClientId()};
        this.finderCache.putResult(this._finderPathFetchByC_A_C, args, (Object)oAuthClientEntryModelImpl);
    }

    public OAuthClientEntry create(long oAuthClientEntryId) {
        OAuthClientEntryImpl oAuthClientEntry = new OAuthClientEntryImpl();
        oAuthClientEntry.setNew(true);
        oAuthClientEntry.setPrimaryKey(oAuthClientEntryId);
        oAuthClientEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuthClientEntry;
    }

    public OAuthClientEntry remove(long oAuthClientEntryId) throws NoSuchOAuthClientEntryException {
        return this.remove(Long.valueOf(oAuthClientEntryId));
    }

    public OAuthClientEntry remove(Serializable primaryKey) throws NoSuchOAuthClientEntryException {
        Session session = null;
        try {
            session = this.openSession();
            OAuthClientEntry oAuthClientEntry = (OAuthClientEntry)session.get(OAuthClientEntryImpl.class, primaryKey);
            if (oAuthClientEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOAuthClientEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuthClientEntry oAuthClientEntry2 = (OAuthClientEntry)this.remove((BaseModel)oAuthClientEntry);
            return oAuthClientEntry2;
        }
        catch (NoSuchOAuthClientEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthClientEntry removeImpl(OAuthClientEntry oAuthClientEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuthClientEntry)) {
                oAuthClientEntry = (OAuthClientEntry)session.get(OAuthClientEntryImpl.class, oAuthClientEntry.getPrimaryKeyObj());
            }
            if (oAuthClientEntry != null) {
                session.delete((Object)oAuthClientEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuthClientEntry != null) {
            this.clearCache(oAuthClientEntry);
        }
        return oAuthClientEntry;
    }

    public OAuthClientEntry updateImpl(OAuthClientEntry oAuthClientEntry) {
        boolean isNew = oAuthClientEntry.isNew();
        if (!(oAuthClientEntry instanceof OAuthClientEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuthClientEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuthClientEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuthClientEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuthClientEntry implementation " + oAuthClientEntry.getClass());
        }
        OAuthClientEntryModelImpl oAuthClientEntryModelImpl = (OAuthClientEntryModelImpl)oAuthClientEntry;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && oAuthClientEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                oAuthClientEntry.setCreateDate(date);
            } else {
                oAuthClientEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!oAuthClientEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                oAuthClientEntry.setModifiedDate(date);
            } else {
                oAuthClientEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuthClientEntry);
            } else {
                oAuthClientEntry = (OAuthClientEntry)session.merge((Object)oAuthClientEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(OAuthClientEntryImpl.class, (BaseModel)oAuthClientEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(oAuthClientEntryModelImpl);
        if (isNew) {
            oAuthClientEntry.setNew(false);
        }
        oAuthClientEntry.resetOriginalValues();
        return oAuthClientEntry;
    }

    public OAuthClientEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuthClientEntryException {
        OAuthClientEntry oAuthClientEntry = (OAuthClientEntry)this.fetchByPrimaryKey(primaryKey);
        if (oAuthClientEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOAuthClientEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuthClientEntry;
    }

    public OAuthClientEntry findByPrimaryKey(long oAuthClientEntryId) throws NoSuchOAuthClientEntryException {
        return this.findByPrimaryKey(Long.valueOf(oAuthClientEntryId));
    }

    public OAuthClientEntry fetchByPrimaryKey(long oAuthClientEntryId) {
        return (OAuthClientEntry)this.fetchByPrimaryKey(Long.valueOf(oAuthClientEntryId));
    }

    public List<OAuthClientEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuthClientEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuthClientEntry> findAll(int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuthClientEntry> findAll(int start, int end, OrderByComparator<OAuthClientEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTHCLIENTENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTHCLIENTENTRY;
                sql = sql.concat(" ORDER BY oAuthClientEntry.oAuthClientEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuthClientEntry oAuthClientEntry : this.findAll()) {
            this.remove((BaseModel)oAuthClientEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTHCLIENTENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuthClientEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTHCLIENTENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuthClientEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathWithPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathWithPaginationFindByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "authServerWellKnownURI"}, true);
        this._finderPathWithoutPaginationFindByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "authServerWellKnownURI"}, true);
        this._finderPathCountByC_A = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "authServerWellKnownURI"}, false);
        this._finderPathFetchByC_A_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_A_C", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "authServerWellKnownURI", "clientId"}, true);
        OAuthClientEntryUtil.setPersistence((OAuthClientEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        OAuthClientEntryUtil.setPersistence(null);
        this.entityCache.removeCache(OAuthClientEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth.client.persistence.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.client.persistence.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.client.persistence.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

