/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MBMessage service. Represents a row in the &quot;MBMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MBMessageModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBMessageImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBMessageImpl
 * @generated
 */
@JSON(strict = true)
public class MBMessageModelImpl
	extends BaseModelImpl<MBMessage> implements MBMessageModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message-boards message model instance should use the <code>MBMessage</code> interface instead.
	 */
	public static final String TABLE_NAME = "MBMessage";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"messageId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"categoryId", Types.BIGINT},
		{"threadId", Types.BIGINT}, {"rootMessageId", Types.BIGINT},
		{"parentMessageId", Types.BIGINT}, {"treePath", Types.VARCHAR},
		{"subject", Types.VARCHAR}, {"urlSubject", Types.VARCHAR},
		{"body", Types.CLOB}, {"format", Types.VARCHAR},
		{"anonymous", Types.BOOLEAN}, {"priority", Types.DOUBLE},
		{"allowPingbacks", Types.BOOLEAN}, {"answer", Types.BOOLEAN},
		{"lastPublishDate", Types.TIMESTAMP}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("messageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("categoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("threadId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("rootMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentMessageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("urlSubject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("format", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("anonymous", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("allowPingbacks", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("answer", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MBMessage (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,messageId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,categoryId LONG,threadId LONG,rootMessageId LONG,parentMessageId LONG,treePath STRING null,subject VARCHAR(255) null,urlSubject VARCHAR(255) null,body TEXT null,format VARCHAR(75) null,anonymous BOOLEAN,priority DOUBLE,allowPingbacks BOOLEAN,answer BOOLEAN,lastPublishDate DATE null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null,primary key (messageId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table MBMessage";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mbMessage.createDate ASC, mbMessage.messageId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MBMessage.createDate ASC, MBMessage.messageId ASC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY mbMessage.createDate ASC, mbMessage.messageId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ANSWER_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CATEGORYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTMESSAGEID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long THREADID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long URLSUBJECT_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 8192L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MESSAGEID_COLUMN_BITMASK = 16384L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MBMessageModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _messageId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMessageId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _messageId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MBMessage.class;
	}

	@Override
	public String getModelClassName() {
		return MBMessage.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MBMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMessage, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((MBMessage)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MBMessage, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MBMessage, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MBMessage)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MBMessage, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MBMessage, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<MBMessage, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
				new LinkedHashMap<String, Function<MBMessage, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", MBMessage::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", MBMessage::getCtCollectionId);
			attributeGetterFunctions.put("uuid", MBMessage::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode", MBMessage::getExternalReferenceCode);
			attributeGetterFunctions.put("messageId", MBMessage::getMessageId);
			attributeGetterFunctions.put("groupId", MBMessage::getGroupId);
			attributeGetterFunctions.put("companyId", MBMessage::getCompanyId);
			attributeGetterFunctions.put("userId", MBMessage::getUserId);
			attributeGetterFunctions.put("userName", MBMessage::getUserName);
			attributeGetterFunctions.put(
				"createDate", MBMessage::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", MBMessage::getModifiedDate);
			attributeGetterFunctions.put(
				"classNameId", MBMessage::getClassNameId);
			attributeGetterFunctions.put("classPK", MBMessage::getClassPK);
			attributeGetterFunctions.put(
				"categoryId", MBMessage::getCategoryId);
			attributeGetterFunctions.put("threadId", MBMessage::getThreadId);
			attributeGetterFunctions.put(
				"rootMessageId", MBMessage::getRootMessageId);
			attributeGetterFunctions.put(
				"parentMessageId", MBMessage::getParentMessageId);
			attributeGetterFunctions.put("treePath", MBMessage::getTreePath);
			attributeGetterFunctions.put("subject", MBMessage::getSubject);
			attributeGetterFunctions.put(
				"urlSubject", MBMessage::getUrlSubject);
			attributeGetterFunctions.put("body", MBMessage::getBody);
			attributeGetterFunctions.put("format", MBMessage::getFormat);
			attributeGetterFunctions.put("anonymous", MBMessage::getAnonymous);
			attributeGetterFunctions.put("priority", MBMessage::getPriority);
			attributeGetterFunctions.put(
				"allowPingbacks", MBMessage::getAllowPingbacks);
			attributeGetterFunctions.put("answer", MBMessage::getAnswer);
			attributeGetterFunctions.put(
				"lastPublishDate", MBMessage::getLastPublishDate);
			attributeGetterFunctions.put("status", MBMessage::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId", MBMessage::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName", MBMessage::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", MBMessage::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<MBMessage, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<MBMessage, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<MBMessage, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<MBMessage, Long>)MBMessage::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<MBMessage, Long>)MBMessage::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<MBMessage, String>)MBMessage::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<MBMessage, String>)
					MBMessage::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"messageId",
				(BiConsumer<MBMessage, Long>)MBMessage::setMessageId);
			attributeSetterBiConsumers.put(
				"groupId", (BiConsumer<MBMessage, Long>)MBMessage::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<MBMessage, Long>)MBMessage::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId", (BiConsumer<MBMessage, Long>)MBMessage::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<MBMessage, String>)MBMessage::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<MBMessage, Date>)MBMessage::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<MBMessage, Date>)MBMessage::setModifiedDate);
			attributeSetterBiConsumers.put(
				"classNameId",
				(BiConsumer<MBMessage, Long>)MBMessage::setClassNameId);
			attributeSetterBiConsumers.put(
				"classPK", (BiConsumer<MBMessage, Long>)MBMessage::setClassPK);
			attributeSetterBiConsumers.put(
				"categoryId",
				(BiConsumer<MBMessage, Long>)MBMessage::setCategoryId);
			attributeSetterBiConsumers.put(
				"threadId",
				(BiConsumer<MBMessage, Long>)MBMessage::setThreadId);
			attributeSetterBiConsumers.put(
				"rootMessageId",
				(BiConsumer<MBMessage, Long>)MBMessage::setRootMessageId);
			attributeSetterBiConsumers.put(
				"parentMessageId",
				(BiConsumer<MBMessage, Long>)MBMessage::setParentMessageId);
			attributeSetterBiConsumers.put(
				"treePath",
				(BiConsumer<MBMessage, String>)MBMessage::setTreePath);
			attributeSetterBiConsumers.put(
				"subject",
				(BiConsumer<MBMessage, String>)MBMessage::setSubject);
			attributeSetterBiConsumers.put(
				"urlSubject",
				(BiConsumer<MBMessage, String>)MBMessage::setUrlSubject);
			attributeSetterBiConsumers.put(
				"body", (BiConsumer<MBMessage, String>)MBMessage::setBody);
			attributeSetterBiConsumers.put(
				"format", (BiConsumer<MBMessage, String>)MBMessage::setFormat);
			attributeSetterBiConsumers.put(
				"anonymous",
				(BiConsumer<MBMessage, Boolean>)MBMessage::setAnonymous);
			attributeSetterBiConsumers.put(
				"priority",
				(BiConsumer<MBMessage, Double>)MBMessage::setPriority);
			attributeSetterBiConsumers.put(
				"allowPingbacks",
				(BiConsumer<MBMessage, Boolean>)MBMessage::setAllowPingbacks);
			attributeSetterBiConsumers.put(
				"answer", (BiConsumer<MBMessage, Boolean>)MBMessage::setAnswer);
			attributeSetterBiConsumers.put(
				"lastPublishDate",
				(BiConsumer<MBMessage, Date>)MBMessage::setLastPublishDate);
			attributeSetterBiConsumers.put(
				"status", (BiConsumer<MBMessage, Integer>)MBMessage::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<MBMessage, Long>)MBMessage::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<MBMessage, String>)MBMessage::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<MBMessage, Date>)MBMessage::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_messageId = messageId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCategoryId() {
		return _categoryId;
	}

	@Override
	public void setCategoryId(long categoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_categoryId = categoryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCategoryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("categoryId"));
	}

	@JSON
	@Override
	public long getThreadId() {
		return _threadId;
	}

	@Override
	public void setThreadId(long threadId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_threadId = threadId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalThreadId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("threadId"));
	}

	@JSON
	@Override
	public long getRootMessageId() {
		return _rootMessageId;
	}

	@Override
	public void setRootMessageId(long rootMessageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_rootMessageId = rootMessageId;
	}

	@JSON
	@Override
	public long getParentMessageId() {
		return _parentMessageId;
	}

	@Override
	public void setParentMessageId(long parentMessageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentMessageId = parentMessageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentMessageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentMessageId"));
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public void setSubject(String subject) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subject = subject;
	}

	@JSON
	@Override
	public String getUrlSubject() {
		if (_urlSubject == null) {
			return "";
		}
		else {
			return _urlSubject;
		}
	}

	@Override
	public void setUrlSubject(String urlSubject) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_urlSubject = urlSubject;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUrlSubject() {
		return getColumnOriginalValue("urlSubject");
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public void setBody(String body) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_body = body;
	}

	@JSON
	@Override
	public String getFormat() {
		if (_format == null) {
			return "";
		}
		else {
			return _format;
		}
	}

	@Override
	public void setFormat(String format) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_format = format;
	}

	@JSON
	@Override
	public boolean getAnonymous() {
		return _anonymous;
	}

	@JSON
	@Override
	public boolean isAnonymous() {
		return _anonymous;
	}

	@Override
	public void setAnonymous(boolean anonymous) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_anonymous = anonymous;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getAllowPingbacks() {
		return _allowPingbacks;
	}

	@JSON
	@Override
	public boolean isAllowPingbacks() {
		return _allowPingbacks;
	}

	@Override
	public void setAllowPingbacks(boolean allowPingbacks) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_allowPingbacks = allowPingbacks;
	}

	@JSON
	@Override
	public boolean getAnswer() {
		return _answer;
	}

	@JSON
	@Override
	public boolean isAnswer() {
		return _answer;
	}

	@Override
	public void setAnswer(boolean answer) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_answer = answer;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalAnswer() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("answer"));
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPublishDate = lastPublishDate;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(MBMessage.class.getName()),
			getClassNameId());
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MBMessage.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MBMessage toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MBMessage>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MBMessageImpl mbMessageImpl = new MBMessageImpl();

		mbMessageImpl.setMvccVersion(getMvccVersion());
		mbMessageImpl.setCtCollectionId(getCtCollectionId());
		mbMessageImpl.setUuid(getUuid());
		mbMessageImpl.setExternalReferenceCode(getExternalReferenceCode());
		mbMessageImpl.setMessageId(getMessageId());
		mbMessageImpl.setGroupId(getGroupId());
		mbMessageImpl.setCompanyId(getCompanyId());
		mbMessageImpl.setUserId(getUserId());
		mbMessageImpl.setUserName(getUserName());
		mbMessageImpl.setCreateDate(getCreateDate());
		mbMessageImpl.setModifiedDate(getModifiedDate());
		mbMessageImpl.setClassNameId(getClassNameId());
		mbMessageImpl.setClassPK(getClassPK());
		mbMessageImpl.setCategoryId(getCategoryId());
		mbMessageImpl.setThreadId(getThreadId());
		mbMessageImpl.setRootMessageId(getRootMessageId());
		mbMessageImpl.setParentMessageId(getParentMessageId());
		mbMessageImpl.setTreePath(getTreePath());
		mbMessageImpl.setSubject(getSubject());
		mbMessageImpl.setUrlSubject(getUrlSubject());
		mbMessageImpl.setBody(getBody());
		mbMessageImpl.setFormat(getFormat());
		mbMessageImpl.setAnonymous(isAnonymous());
		mbMessageImpl.setPriority(getPriority());
		mbMessageImpl.setAllowPingbacks(isAllowPingbacks());
		mbMessageImpl.setAnswer(isAnswer());
		mbMessageImpl.setLastPublishDate(getLastPublishDate());
		mbMessageImpl.setStatus(getStatus());
		mbMessageImpl.setStatusByUserId(getStatusByUserId());
		mbMessageImpl.setStatusByUserName(getStatusByUserName());
		mbMessageImpl.setStatusDate(getStatusDate());

		mbMessageImpl.resetOriginalValues();

		return mbMessageImpl;
	}

	@Override
	public MBMessage cloneWithOriginalValues() {
		MBMessageImpl mbMessageImpl = new MBMessageImpl();

		mbMessageImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		mbMessageImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		mbMessageImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		mbMessageImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		mbMessageImpl.setMessageId(
			this.<Long>getColumnOriginalValue("messageId"));
		mbMessageImpl.setGroupId(this.<Long>getColumnOriginalValue("groupId"));
		mbMessageImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		mbMessageImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		mbMessageImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		mbMessageImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		mbMessageImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		mbMessageImpl.setClassNameId(
			this.<Long>getColumnOriginalValue("classNameId"));
		mbMessageImpl.setClassPK(this.<Long>getColumnOriginalValue("classPK"));
		mbMessageImpl.setCategoryId(
			this.<Long>getColumnOriginalValue("categoryId"));
		mbMessageImpl.setThreadId(
			this.<Long>getColumnOriginalValue("threadId"));
		mbMessageImpl.setRootMessageId(
			this.<Long>getColumnOriginalValue("rootMessageId"));
		mbMessageImpl.setParentMessageId(
			this.<Long>getColumnOriginalValue("parentMessageId"));
		mbMessageImpl.setTreePath(
			this.<String>getColumnOriginalValue("treePath"));
		mbMessageImpl.setSubject(
			this.<String>getColumnOriginalValue("subject"));
		mbMessageImpl.setUrlSubject(
			this.<String>getColumnOriginalValue("urlSubject"));
		mbMessageImpl.setBody(this.<String>getColumnOriginalValue("body"));
		mbMessageImpl.setFormat(this.<String>getColumnOriginalValue("format"));
		mbMessageImpl.setAnonymous(
			this.<Boolean>getColumnOriginalValue("anonymous"));
		mbMessageImpl.setPriority(
			this.<Double>getColumnOriginalValue("priority"));
		mbMessageImpl.setAllowPingbacks(
			this.<Boolean>getColumnOriginalValue("allowPingbacks"));
		mbMessageImpl.setAnswer(this.<Boolean>getColumnOriginalValue("answer"));
		mbMessageImpl.setLastPublishDate(
			this.<Date>getColumnOriginalValue("lastPublishDate"));
		mbMessageImpl.setStatus(this.<Integer>getColumnOriginalValue("status"));
		mbMessageImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		mbMessageImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		mbMessageImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return mbMessageImpl;
	}

	@Override
	public int compareTo(MBMessage mbMessage) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(), mbMessage.getCreateDate());

		if (value != 0) {
			return value;
		}

		if (getMessageId() < mbMessage.getMessageId()) {
			value = -1;
		}
		else if (getMessageId() > mbMessage.getMessageId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MBMessage)) {
			return false;
		}

		MBMessage mbMessage = (MBMessage)object;

		long primaryKey = mbMessage.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MBMessage> toCacheModel() {
		MBMessageCacheModel mbMessageCacheModel = new MBMessageCacheModel();

		mbMessageCacheModel.mvccVersion = getMvccVersion();

		mbMessageCacheModel.ctCollectionId = getCtCollectionId();

		mbMessageCacheModel.uuid = getUuid();

		String uuid = mbMessageCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			mbMessageCacheModel.uuid = null;
		}

		mbMessageCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode =
			mbMessageCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			mbMessageCacheModel.externalReferenceCode = null;
		}

		mbMessageCacheModel.messageId = getMessageId();

		mbMessageCacheModel.groupId = getGroupId();

		mbMessageCacheModel.companyId = getCompanyId();

		mbMessageCacheModel.userId = getUserId();

		mbMessageCacheModel.userName = getUserName();

		String userName = mbMessageCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mbMessageCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mbMessageCacheModel.createDate = createDate.getTime();
		}
		else {
			mbMessageCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mbMessageCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			mbMessageCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mbMessageCacheModel.classNameId = getClassNameId();

		mbMessageCacheModel.classPK = getClassPK();

		mbMessageCacheModel.categoryId = getCategoryId();

		mbMessageCacheModel.threadId = getThreadId();

		mbMessageCacheModel.rootMessageId = getRootMessageId();

		mbMessageCacheModel.parentMessageId = getParentMessageId();

		mbMessageCacheModel.treePath = getTreePath();

		String treePath = mbMessageCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			mbMessageCacheModel.treePath = null;
		}

		mbMessageCacheModel.subject = getSubject();

		String subject = mbMessageCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			mbMessageCacheModel.subject = null;
		}

		mbMessageCacheModel.urlSubject = getUrlSubject();

		String urlSubject = mbMessageCacheModel.urlSubject;

		if ((urlSubject != null) && (urlSubject.length() == 0)) {
			mbMessageCacheModel.urlSubject = null;
		}

		mbMessageCacheModel.body = getBody();

		String body = mbMessageCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			mbMessageCacheModel.body = null;
		}

		mbMessageCacheModel.format = getFormat();

		String format = mbMessageCacheModel.format;

		if ((format != null) && (format.length() == 0)) {
			mbMessageCacheModel.format = null;
		}

		mbMessageCacheModel.anonymous = isAnonymous();

		mbMessageCacheModel.priority = getPriority();

		mbMessageCacheModel.allowPingbacks = isAllowPingbacks();

		mbMessageCacheModel.answer = isAnswer();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			mbMessageCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			mbMessageCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		mbMessageCacheModel.status = getStatus();

		mbMessageCacheModel.statusByUserId = getStatusByUserId();

		mbMessageCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = mbMessageCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			mbMessageCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			mbMessageCacheModel.statusDate = statusDate.getTime();
		}
		else {
			mbMessageCacheModel.statusDate = Long.MIN_VALUE;
		}

		return mbMessageCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MBMessage, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MBMessage, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMessage, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((MBMessage)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MBMessage>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					MBMessage.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _externalReferenceCode;
	private long _messageId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _categoryId;
	private long _threadId;
	private long _rootMessageId;
	private long _parentMessageId;
	private String _treePath;
	private String _subject;
	private String _urlSubject;
	private String _body;
	private String _format;
	private boolean _anonymous;
	private double _priority;
	private boolean _allowPingbacks;
	private boolean _answer;
	private Date _lastPublishDate;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<MBMessage, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MBMessage)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("messageId", _messageId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("categoryId", _categoryId);
		_columnOriginalValues.put("threadId", _threadId);
		_columnOriginalValues.put("rootMessageId", _rootMessageId);
		_columnOriginalValues.put("parentMessageId", _parentMessageId);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("subject", _subject);
		_columnOriginalValues.put("urlSubject", _urlSubject);
		_columnOriginalValues.put("body", _body);
		_columnOriginalValues.put("format", _format);
		_columnOriginalValues.put("anonymous", _anonymous);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("allowPingbacks", _allowPingbacks);
		_columnOriginalValues.put("answer", _answer);
		_columnOriginalValues.put("lastPublishDate", _lastPublishDate);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("externalReferenceCode", 8L);

		columnBitmasks.put("messageId", 16L);

		columnBitmasks.put("groupId", 32L);

		columnBitmasks.put("companyId", 64L);

		columnBitmasks.put("userId", 128L);

		columnBitmasks.put("userName", 256L);

		columnBitmasks.put("createDate", 512L);

		columnBitmasks.put("modifiedDate", 1024L);

		columnBitmasks.put("classNameId", 2048L);

		columnBitmasks.put("classPK", 4096L);

		columnBitmasks.put("categoryId", 8192L);

		columnBitmasks.put("threadId", 16384L);

		columnBitmasks.put("rootMessageId", 32768L);

		columnBitmasks.put("parentMessageId", 65536L);

		columnBitmasks.put("treePath", 131072L);

		columnBitmasks.put("subject", 262144L);

		columnBitmasks.put("urlSubject", 524288L);

		columnBitmasks.put("body", 1048576L);

		columnBitmasks.put("format", 2097152L);

		columnBitmasks.put("anonymous", 4194304L);

		columnBitmasks.put("priority", 8388608L);

		columnBitmasks.put("allowPingbacks", 16777216L);

		columnBitmasks.put("answer", 33554432L);

		columnBitmasks.put("lastPublishDate", 67108864L);

		columnBitmasks.put("status", 134217728L);

		columnBitmasks.put("statusByUserId", 268435456L);

		columnBitmasks.put("statusByUserName", 536870912L);

		columnBitmasks.put("statusDate", 1073741824L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MBMessage _escapedModel;

}