/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.persistence.impl;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.impl.MBCategoryImpl;
import com.liferay.message.boards.service.persistence.MBCategoryFinder;
import com.liferay.message.boards.service.persistence.MBCategoryUtil;
import com.liferay.message.boards.service.persistence.MBThreadUtil;
import com.liferay.message.boards.service.persistence.impl.MBCategoryFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.subscription.model.Subscription;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MBCategoryFinder.class})
public class MBCategoryFinderImpl
extends MBCategoryFinderBaseImpl
implements MBCategoryFinder {
    public static final String COUNT_C_BY_G_P = MBCategoryFinder.class.getName() + ".countC_ByG_P";
    public static final String COUNT_C_BY_S_G_U_P = MBCategoryFinder.class.getName() + ".countC_ByS_G_U_P";
    public static final String COUNT_T_BY_G_C = MBCategoryFinder.class.getName() + ".countT_ByG_C";
    public static final String FIND_C_BY_G_P = MBCategoryFinder.class.getName() + ".findC_ByG_P";
    public static final String FIND_C_BY_S_G_U_P = MBCategoryFinder.class.getName() + ".findC_ByS_G_U_P";
    public static final String FIND_T_BY_G_C = MBCategoryFinder.class.getName() + ".findT_ByG_C";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public int countC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<?> queryDefinition) {
        return this.doCountC_ByG_P(groupId, parentCategoryId, queryDefinition, false);
    }

    public int countC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition) {
        return this.doCountC_ByS_G_U_P(groupId, userId, parentCategoryIds, queryDefinition, false);
    }

    public int countC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition) {
        return this.doCountC_T_ByG_C(groupId, categoryId, queryDefinition, false);
    }

    public int filterCountC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<?> queryDefinition) {
        return this.doCountC_ByG_P(groupId, parentCategoryId, queryDefinition, true);
    }

    public int filterCountC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition) {
        return this.doCountC_ByS_G_U_P(groupId, userId, parentCategoryIds, queryDefinition, true);
    }

    public int filterCountC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition) {
        return this.doCountC_T_ByG_C(groupId, categoryId, queryDefinition, true);
    }

    public List<MBCategory> filterFindC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<MBCategory> queryDefinition) {
        return this.doFindC_ByG_P(groupId, parentCategoryId, queryDefinition, true);
    }

    public List<MBCategory> filterFindC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition) {
        return this.doFindC_ByS_G_U_P(groupId, userId, parentCategoryIds, queryDefinition, true);
    }

    public List<Object> filterFindC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition) {
        return this.doFindC_T_ByG_C(groupId, categoryId, queryDefinition, true);
    }

    public List<MBCategory> findC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<MBCategory> queryDefinition) {
        return this.doFindC_ByG_P(groupId, parentCategoryId, queryDefinition, false);
    }

    public List<MBCategory> findC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition) {
        return this.doFindC_ByS_G_U_P(groupId, userId, parentCategoryIds, queryDefinition, false);
    }

    public List<Object> findC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition) {
        return this.doFindC_T_ByG_C(groupId, categoryId, queryDefinition, false);
    }

    protected int doCountC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        if (!inlineSQLHelper || !InlineSQLHelperUtil.isEnabled((long)groupId)) {
            if (queryDefinition.isExcludeStatus()) {
                return MBCategoryUtil.countByG_P_NotS((long)groupId, (long)parentCategoryId, (int)queryDefinition.getStatus());
            }
            if (queryDefinition.getStatus() != -1) {
                return MBCategoryUtil.countByG_P_S((long)groupId, (long)parentCategoryId, (int)queryDefinition.getStatus());
            }
            return MBCategoryUtil.countByG_P((long)groupId, (long)parentCategoryId);
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_C_BY_G_P, queryDefinition, "MBCategory");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(parentCategoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long count = (Long)iterator.next();
                if (count == null) continue;
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Group group;
            Subscription subscription;
            Long l;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_C_BY_S_G_U_P);
            if (ArrayUtil.isEmpty((long[])parentCategoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBCategory.parentCategoryId = ?) AND");
            } else {
                String mergedParentCategoryIds = StringUtil.merge((long[])parentCategoryIds, (String)" OR MBCategory.parentCategoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBCategory.parentCategoryId = ?", (String)("MBCategory.parentCategoryId = " + mergedParentCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBCategory.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (l = (Long)iterator.next()) != null) {
                count = l.intValue();
            }
            if ((subscription = this._subscriptionLocalService.fetchSubscription((group = this._groupLocalService.getGroup(groupId)).getCompanyId(), userId, MBCategory.class.getName(), groupId)) != null) {
                ++count;
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_T_BY_G_C, queryDefinition, "MBThread");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            }
            sb.append(sql);
            sb.append(") UNION ALL (");
            sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_C_BY_G_P, queryDefinition, "MBCategory");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            sb.append(sql);
            sb.append(")");
            sql = sb.toString();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<MBCategory> doFindC_ByG_P(long groupId, long parentCategoryId, QueryDefinition<MBCategory> queryDefinition, boolean inlineSQLHelper) {
        if (!inlineSQLHelper || !InlineSQLHelperUtil.isEnabled((long)groupId)) {
            if (queryDefinition.isExcludeStatus()) {
                return MBCategoryUtil.findByG_P_NotS((long)groupId, (long)parentCategoryId, (int)queryDefinition.getStatus(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
            }
            if (queryDefinition.getStatus() != -1) {
                return MBCategoryUtil.findByG_P_S((long)groupId, (long)parentCategoryId, (int)queryDefinition.getStatus(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
            }
            return MBCategoryUtil.findByG_P((long)groupId, (long)parentCategoryId, (int)queryDefinition.getStart(), (int)queryDefinition.getEnd(), (OrderByComparator)queryDefinition.getOrderByComparator());
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_C_BY_G_P, queryDefinition, "MBCategory");
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("modelId", Type.LONG);
            sqlQuery.addScalar("modelCategory", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(parentCategoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            ArrayList<MBCategory> categories = new ArrayList<MBCategory>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                long modelId = (Long)array[0];
                MBCategory category = MBCategoryUtil.findByPrimaryKey((long)modelId);
                categories.add(category);
            }
            ArrayList<MBCategory> arrayList = categories;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<MBCategory> doFindC_ByS_G_U_P(long groupId, long userId, long[] parentCategoryIds, QueryDefinition<MBCategory> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_C_BY_S_G_U_P);
            if (ArrayUtil.isEmpty((long[])parentCategoryIds)) {
                sql = StringUtil.removeSubstring((String)sql, (String)"(MBCategory.parentCategoryId = ?) AND");
            } else {
                String mergedParentCategoryIds = StringUtil.merge((long[])parentCategoryIds, (String)" OR MBCategory.parentCategoryId = ");
                sql = StringUtil.replace((String)sql, (String)"MBCategory.parentCategoryId = ?", (String)("MBCategory.parentCategoryId = " + mergedParentCategoryIds));
            }
            sql = this.updateSQL(sql, queryDefinition);
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("MBCategory", MBCategoryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(this._portal.getClassNameId(MBCategory.class.getName()));
            queryPos.add(groupId);
            queryPos.add(userId);
            if (queryDefinition.getStatus() != -1) {
                queryPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)-1, (int)-1, (boolean)false);
            Group group = this._groupLocalService.getGroup(groupId);
            Subscription subscription = this._subscriptionLocalService.fetchSubscription(group.getCompanyId(), userId, MBCategory.class.getName(), groupId);
            if (subscription != null) {
                MBCategoryImpl category = new MBCategoryImpl();
                category.setGroupId(group.getGroupId());
                category.setCompanyId(group.getCompanyId());
                category.setName(group.getDescriptiveName());
                category.setDescription(group.getDescription(LocaleUtil.getMostRelevantLocale()));
                list.add(category);
            }
            List<MBCategory> list2 = Collections.unmodifiableList(ListUtil.subList((List)list, (int)queryDefinition.getStart(), (int)queryDefinition.getEnd()));
            return list2;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindC_T_ByG_C(long groupId, long categoryId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(6);
            sb.append("SELECT * FROM (");
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_T_BY_G_C, queryDefinition, "MBThread");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"MBThread.rootMessageId", (long)groupId);
            }
            sb.append(sql);
            sb.append(" UNION ALL ");
            sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_C_BY_G_P, queryDefinition, "MBCategory");
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBCategory.class.getName(), (String)"MBCategory.categoryId", (long)groupId);
            }
            sb.append(sql);
            sb.append(") TEMP_TABLE ORDER BY modelCategory ASC, priority ");
            sb.append("DESC, modelId ASC");
            sql = sb.toString();
            sql = this._customSQL.replaceOrderBy(sql, queryDefinition.getOrderByComparator());
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("modelId", Type.LONG);
            sqlQuery.addScalar("modelCategory", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            queryPos.add(groupId);
            queryPos.add(categoryId);
            queryPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                queryPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    queryPos.add(8);
                }
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator iterator = QueryUtil.iterate((Query)sqlQuery, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (iterator.hasNext()) {
                Object[] array = (Object[])iterator.next();
                long modelId = (Long)array[0];
                long modelCategory = (Long)array[1];
                Object object = null;
                object = modelCategory == 1L ? MBThreadUtil.findByPrimaryKey((long)modelId) : MBCategoryUtil.findByPrimaryKey((long)modelId);
                models.add(object);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String updateSQL(String sql, QueryDefinition<MBCategory> queryDefinition) {
        if (queryDefinition.getStatus() == -1) {
            return sql;
        }
        if (queryDefinition.isExcludeStatus()) {
            return this._customSQL.appendCriteria(sql, "AND (MBCategory.status != ?)");
        }
        return this._customSQL.appendCriteria(sql, "AND (MBCategory.status = ?)");
    }
}

